/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationDatasetHelper;
import com.dataiku.dip.coremodel.Schema;

public class WeightParams {
    public WeightMethod weightMethod;
    public String sampleWeightVariable;

    public boolean isSampleWeightEnabled() {
        return this.weightMethod == WeightMethod.SAMPLE_WEIGHT || this.weightMethod == WeightMethod.CLASS_AND_SAMPLE_WEIGHT;
    }

    public void checkHasSampleWeightColumn(Schema schema) {
        this.checkHasSampleWeightColumn(schema, EvaluationDatasetHelper.EvaluationDatasetType.CLASSIC);
    }

    public void checkHasSampleWeightColumn(Schema schema, EvaluationDatasetHelper.EvaluationDatasetType datasetType) {
        if (!this.isSampleWeightEnabled()) {
            return;
        }
        switch (datasetType) {
            case API_NODE_LOGS: {
                String weightColumn = "clientEvent.features." + this.sampleWeightVariable;
                if (schema.hasColumn(weightColumn)) break;
                throw new IllegalArgumentException("Missing sample weight column \"" + weightColumn + "\" in the api logs dataset");
            }
            case CLOUD_API_NODE_LOGS: {
                String cloudWeightColumn = "message.features." + this.sampleWeightVariable;
                if (schema.hasColumn(cloudWeightColumn)) break;
                throw new IllegalArgumentException("Missing sample weight column \"" + cloudWeightColumn + "\" in the api logs dataset");
            }
            case SAGEMAKER_LOGS: {
                break;
            }
            default: {
                if (schema.hasColumn(this.sampleWeightVariable)) break;
                throw new IllegalArgumentException("Missing sample weight column \"" + this.sampleWeightVariable + "\" in the input dataset");
            }
        }
    }

    public static enum WeightMethod {
        NO_WEIGHTING,
        SAMPLE_WEIGHT,
        CLASS_WEIGHT,
        CLASS_AND_SAMPLE_WEIGHT;

    }
}

