/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.snowpark;

import com.dataiku.dip.apideployer.datamodel.actual.snowpark.SnowparkDataModelBuilder;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SnowparkAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.SnowparkDeploymentInfo;
import com.dataiku.dip.externalinfras.snowpark.datamodel.SnowparkDetailedService;
import com.dataiku.dip.variables.VariablesContext;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class SnowparkDeploymentLocalSummary {
    @Nullable
    public final SnowparkDetailedService service;
    @Nullable
    public final String udfName;
    @Nullable
    public final String endpointUrl;

    private SnowparkDeploymentLocalSummary(@Nullable SnowparkDetailedService service, @Nullable String udfName, @Nullable String endpointUrl) {
        this.service = service;
        this.udfName = udfName;
        this.endpointUrl = endpointUrl;
    }

    @Nonnull
    public static SnowparkDeploymentLocalSummary buildFromLocalConfig(SnowparkAPIDeployment deployment, SnowparkAPIDeploymentInfra infra, VariablesContext vc, @Nonnull SnowparkDeploymentInfo deploymentInfo) {
        String serviceName = deploymentInfo.snowparkServiceName;
        String databaseName = deploymentInfo.snowflakeDatabaseName;
        String schemaName = deploymentInfo.snowflakeSchemaName;
        SnowparkDetailedService snowparkService = StringUtils.isNotBlank((CharSequence)serviceName) && StringUtils.isNotBlank((CharSequence)databaseName) && StringUtils.isNotBlank((CharSequence)schemaName) ? SnowparkDataModelBuilder.buildDetailedService(deployment, infra, vc, serviceName, databaseName, schemaName, deploymentInfo.containerImageUri) : null;
        return new SnowparkDeploymentLocalSummary(snowparkService, deploymentInfo.snowparkUdfName, deploymentInfo.snowparkEndpointUrl);
    }
}

