/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.vertexai;

import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.VertexAIDeploymentInfo;
import com.dataiku.dip.apideployer.deployments.VertexAIDeploymentConfigManager;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModelConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpoint;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpointConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelInternalConfig;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.EndpointName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ModelName;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class VertexAIDataModelBuilder {
    private VertexAIDataModelBuilder() {
    }

    @Nullable
    public static VertexAIDeployedModel buildDeployedModel(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, @Nonnull VertexAIDeploymentInfo deploymentInfo) {
        String deployedModelId = deploymentInfo.vertexAIDeployedModelId;
        if (StringUtils.isBlank((CharSequence)deployedModelId)) {
            return null;
        }
        VertexAIDeployedModelConfig config = VertexAIDataModelBuilder.buildDeployedModelConfig(deployment, infra);
        return new VertexAIDeployedModel(deployedModelId, config);
    }

    @Nonnull
    public static VertexAIDeployedModelConfig buildDeployedModelConfig(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra) {
        return new VertexAIDeployedModelConfig(deployment.getMachineConfig(infra));
    }

    @Nullable
    public static VertexAIEndpoint buildEndpoint(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, VariablesContext vc, @Nonnull VertexAIDeploymentInfo deploymentInfo) {
        String endpointId = deploymentInfo.vertexAIEndpointId;
        if (StringUtils.isBlank((CharSequence)endpointId)) {
            return null;
        }
        EndpointName name = VertexAIUtils.computeEndpointName(deploymentInfo.gcpProjectId, deploymentInfo.gcpRegion, endpointId);
        VertexAIEndpointConfig config = VertexAIDataModelBuilder.buildEndpointConfig(deployment, infra, vc);
        return new VertexAIEndpoint(name, config);
    }

    @Nonnull
    public static VertexAIEndpointConfig buildEndpointConfig(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, VariablesContext vc) {
        VertexAIDeploymentConfigManager configManager = new VertexAIDeploymentConfigManager(deployment, infra, vc);
        Map<String, String> tags = configManager.prepareTags();
        return new VertexAIEndpointConfig(tags, infra.networkFullName);
    }

    @Nullable
    public static VertexAIModel buildModel(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, VariablesContext vc, @Nonnull VertexAIDeploymentInfo deploymentInfo) {
        String modelId = deploymentInfo.vertexAIModelId;
        if (StringUtils.isBlank((CharSequence)modelId)) {
            return null;
        }
        ModelName name = VertexAIUtils.computeModelName(deploymentInfo.gcpProjectId, deploymentInfo.gcpRegion, modelId);
        VertexAIModelConfig config = VertexAIDataModelBuilder.buildModelConfig(deployment, infra, vc, deploymentInfo.containerImageUri);
        return new VertexAIModel(name, config);
    }

    @Nonnull
    public static VertexAIModelConfig buildModelConfig(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra, VariablesContext vc, String containerImageUri) {
        VertexAIDeploymentConfigManager configManager = new VertexAIDeploymentConfigManager(deployment, infra, vc);
        Map<String, String> tags = configManager.prepareTags();
        List<SimpleKeyValue> environmentVariables = configManager.getEnvironmentVariablesList();
        return new VertexAIModelConfig(tags, environmentVariables, containerImageUri);
    }

    @Nonnull
    public static VertexAIModelInternalConfig buildModelInternalConfig(VertexAIAPIDeployment deployment, VertexAIAPIDeploymentInfra infra) {
        String serviceId = deployment.basicInfoUnsafe().getDeployedItemId();
        String predictRoute = String.format("/public/api/v1/vertex-ai/%s/%s/predict", serviceId, deployment.endpointId);
        String isAliveRoute = "/isAlive";
        if (Objects.nonNull(serviceId)) {
            isAliveRoute = String.format("/monitoring/api/%s/isAliveSimple", serviceId);
        }
        return new VertexAIModelInternalConfig(isAliveRoute, 8080, predictRoute);
    }
}

