/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deploymentinfo;

import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.VertexAIAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deploymentinfo.AbstractDeploymentInfo;
import com.dataiku.dip.externalinfras.vertexai.VertexAIUtils;
import com.dataiku.dip.savedmodels.externalmodelidentifier.VertexAIEndpointIdentifier;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DeployedModel;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Endpoint;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Model;
import javax.annotation.Nullable;

public class VertexAIDeploymentInfo
extends AbstractDeploymentInfo {
    public String gcpRegion;
    public String gcpProjectId;
    @Nullable
    public String vertexAIModelId;
    @Nullable
    public String vertexAIEndpointId;
    @Nullable
    public String vertexAIDeployedModelId;

    public VertexAIDeploymentInfo() {
    }

    public VertexAIDeploymentInfo(VertexAIAPIDeploymentInfra infra, VertexAIAPIDeployment deployment) {
        super(infra.id, deployment.id, null);
        this.gcpProjectId = infra.gcpProjectId;
        this.gcpRegion = infra.gcpRegion;
    }

    public VertexAIDeploymentInfo(VertexAIAPIDeploymentInfra infra, VertexAIAPIDeployment deployment, Model model, Endpoint endpoint, DeployedModel deployedModel) {
        super(infra.id, deployment.id, model.getContainerSpec().getImageUri());
        this.gcpProjectId = infra.gcpProjectId;
        this.gcpRegion = infra.gcpRegion;
        this.vertexAIModelId = VertexAIUtils.extractModelId(model.getName());
        this.vertexAIEndpointId = VertexAIUtils.extractEndpointId(endpoint.getName());
        this.vertexAIDeployedModelId = deployedModel.getId();
    }

    @Override
    public VertexAIEndpointIdentifier getExternalEndpointIdentifier() {
        return new VertexAIEndpointIdentifier(this.gcpProjectId, this.gcpRegion, this.vertexAIEndpointId);
    }
}

