/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli;

import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.plugin.tools.RunBase;
import com.dataiku.dip.plugin.tools.RunInput;
import com.dataiku.dip.plugin.tools.SchemaFromCli;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class TestFormatInputCommand
extends CLICommand {
    private static Logger logger = Logger.getLogger((String)"dku.test.input");

    @Override
    public String usageString() {
        return "dku test-format-input [-classesDir <arg>] [-columns <arg>] [-config <arg>] [-jarFile <arg>] [-lib <arg>] [-pluginConfig <arg>] className";
    }

    @Override
    public String description() {
        return "Test a format input on the standard input and writes the result to the standard output";
    }

    @Override
    public Options opts() {
        Options opts = new Options();
        DKU.addGlobalOptions(opts);
        RunBase.fillOptions(opts);
        SchemaFromCli.fillOptions(opts);
        return opts;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdline = this.parseAndMiniSetup(args, "test-format-input");
        if (cmdline.getArgs().length == 0) {
            return this.usage(1, null);
        }
        try {
            new RunInput(cmdline, 1).run();
            return 0;
        }
        catch (Throwable e) {
            logger.error((Object)"Failed to test input", e);
            return this.usage(1, null);
        }
    }
}

