/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.CredentialsRemoteFetchConfigurationProvider;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GoogleCredentialCache;
import com.dataiku.dip.connections.GoogleCredentialsBuilder;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.javanet.NetHttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public interface ConnectionWithGoogleAuthCredentials
extends ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials {
    public static final String DEFAULT_GOOGLE_GCS_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    public static final String DEFAULT_GOOGLE_AUTHORIZATION_ENDPOINT = "https://accounts.google.com/o/oauth2/v2/auth";
    public static final String DEFAULT_GOOGLE_TOKEN_ENDPOINT = "https://oauth2.googleapis.com/token";
    public static final String DEFAULT_GOOGLE_TOKEN_ENDPOINT_WITH_PSC_FORMAT = "https://oauth2-%s.p.googleapis.com/token";
    public static final Pattern JSON_PRIVATE_KEY_FILE_PATTERN = Pattern.compile(".*\\.json", 2);
    public static final Pattern P12_PRIVATE_KEY_FILE_PATTERN = Pattern.compile(".*\\.p12", 2);
    public static final DKULogger logger = DKULogger.getLogger((String)"dku.google");

    @Nonnull
    public IGoogleAuth2Params getGoogleAuth2NonResolvedParams();

    public ProxySettings getProxySettingsFromConnection();

    default public String getPrivateKeyPathOrNull() throws IOException {
        IGoogleAuth2Params params = this.getGoogleAuth2NonResolvedParams();
        switch (params.getAuthType()) {
            case OAUTH: {
                return null;
            }
            case KEYPAIR: {
                String secretPathOrContent = StringUtils.defaultIfEmpty((String)params.getAppSecretContent(), (String)"").trim();
                if (GoogleCredentialsBuilder.isJson(secretPathOrContent)) {
                    return null;
                }
                return secretPathOrContent;
            }
            case ENVIRONMENT: {
                String filePath = System.getenv("GOOGLE_APPLICATION_CREDENTIALS");
                if (StringUtils.isBlank((String)filePath) || !new File(filePath).exists()) {
                    filePath = new File(new File(System.getProperty("user.home", ""), ".config"), "gcloud/application_default_credentials.json").getAbsolutePath();
                }
                if (new File(filePath).exists()) {
                    return filePath;
                }
                return null;
            }
        }
        throw new IOException("Unknown authentication type " + String.valueOf((Object)params.getAuthType()));
    }

    @Nonnull
    default public IGoogleAuth2Params getGoogleAuth2ResolvedPrivateKeyParams() {
        IGoogleAuth2Params params = this.getGoogleAuth2NonResolvedParams();
        switch (params.getAuthType()) {
            case KEYPAIR: {
                String secretPathOrContent = StringUtils.defaultIfEmpty((String)params.getAppSecretContent(), (String)"").trim();
                if (JSON_PRIVATE_KEY_FILE_PATTERN.matcher(secretPathOrContent).matches()) {
                    try {
                        File secretFile = DKUFileUtils.build((String[])new String[]{secretPathOrContent});
                        String secretContent = DKUFileUtils.fileToString((File)secretFile);
                        SimpleGoogleAuth2Params paramsCopy = new SimpleGoogleAuth2Params(params);
                        paramsCopy.appSecretContent = secretContent;
                        return paramsCopy;
                    }
                    catch (Exception e) {
                        throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Error while getting the connection secret from json file.", (Throwable)e);
                    }
                }
                return params;
            }
        }
        return params;
    }

    default public boolean mustResolveGoogleAuthOnDSSHost() {
        IGoogleAuth2Params params = this.getGoogleAuth2NonResolvedParams();
        switch (params.getAuthType()) {
            case OAUTH: {
                return false;
            }
            case ENVIRONMENT: {
                return true;
            }
            case KEYPAIR: {
                return !GoogleCredentialsBuilder.isJson(StringUtils.defaultIfBlank((String)params.getAppSecretContent(), (String)""));
            }
        }
        throw new IllegalArgumentException("Unkown authentication type " + String.valueOf((Object)params.getAuthType()));
    }

    default public SerializableGoogleAuthCredentials getResolvedCredential(AuthCtx authCtx) throws IOException, DKUSecurityException {
        JsonObject parsed;
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        IGoogleAuth2Params params = this.getGoogleAuth2NonResolvedParams();
        SerializableGoogleAuthCredentials creds = new SerializableGoogleAuthCredentials();
        creds.authType = params.getAuthType();
        switch (params.getAuthType()) {
            case OAUTH: {
                creds.oauthAppId = params.getOauth2ClientId();
                creds.oauthAppSecret = params.getOauth2ClientSecret();
                creds.oauthAuthorizationEndpoint = params.getOauth2AuthorizationEndpoint();
                creds.oauthTokenEndpoint = params.getOauth2TokenEndpoint();
                OAuth2Client.AccessTokenResult tokens = this.getAccessToken(authCtx, this.getProxySettingsFromConnection(), false);
                creds.oauthRefreshToken = tokens.getRefreshToken();
                creds.oauthAccessToken = tokens.getAccessToken();
                creds.oauthAccessTokenExpiresOn = tokens.getExpiresOn() == null ? -1L : tokens.getExpiresOn().getTime();
                break;
            }
            case KEYPAIR: {
                String secretPathOrContent = StringUtils.defaultIfEmpty((String)params.getAppSecretContent(), (String)"").trim();
                creds.keyEmail = params.getServiceAccountEmail();
                if (GoogleCredentialsBuilder.isJson(secretPathOrContent)) {
                    creds.keyJsonData = secretPathOrContent;
                    break;
                }
                File keyFile = new File(secretPathOrContent);
                if (!keyFile.exists() || !keyFile.canRead()) {
                    throw new FileNotFoundException("Cannot read private key file, make sure you defined either the full path on the DSS server to the key file (.json or .p12) - Recommended, or the key as a JSON formatted string ");
                }
                creds.keyPath = secretPathOrContent;
                creds.keyLastModified = keyFile.lastModified();
                if (JSON_PRIVATE_KEY_FILE_PATTERN.matcher(secretPathOrContent).matches()) {
                    creds.keyJsonData = FileUtils.readFileToString((File)keyFile, (Charset)StandardCharsets.UTF_8);
                    break;
                }
                if (!P12_PRIVATE_KEY_FILE_PATTERN.matcher(secretPathOrContent).matches()) break;
                creds.keyBase64Data = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)keyFile));
                break;
            }
            case ENVIRONMENT: {
                creds.keyPath = StringUtils.defaultIfBlank((String)this.getPrivateKeyPathOrNull(), null);
                if (creds.keyPath == null) break;
                File keyFile = new File(creds.keyPath);
                creds.keyLastModified = keyFile.lastModified();
                if (JSON_PRIVATE_KEY_FILE_PATTERN.matcher(creds.keyPath).matches()) {
                    creds.keyJsonData = FileUtils.readFileToString((File)keyFile, (Charset)StandardCharsets.UTF_8);
                    break;
                }
                if (!P12_PRIVATE_KEY_FILE_PATTERN.matcher(creds.keyPath).matches()) break;
                creds.keyBase64Data = Base64.getEncoder().encodeToString(FileUtils.readFileToByteArray((File)keyFile));
            }
        }
        if (StringUtils.isNotBlank((String)creds.keyJsonData) && StringUtils.isBlank((String)creds.keyEmail) && (parsed = (JsonObject)JSON.parse((String)creds.keyJsonData, JsonObject.class)).has("client_email")) {
            creds.keyEmail = parsed.getAsJsonPrimitive("client_email").getAsString();
        }
        return creds;
    }

    @Override
    default public boolean hasRefreshTokenRotation() {
        IGoogleAuth2Params params = this.getGoogleAuth2NonResolvedParams();
        return params.getRefreshTokenRotation();
    }

    @Override
    default public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettingsFromConnection(), false).getAccessToken());
    }

    default public OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings, boolean useOIDCIdToken) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, useOIDCIdToken);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    @Override
    default public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        return ConnectionWithGoogleAuthCredentials.buildOAuth2Client(this.getGoogleAuth2NonResolvedParams(), proxySettings, ((DSSConnection)((Object)this)).getDkuProperties());
    }

    public static OAuth2Client buildOAuth2Client(IGoogleAuth2Params oAuth2Params, ProxySettings proxySettings, List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) throws DKUSecurityException {
        String authorizationEndpoint = StringUtils.defaultIfBlank((String)oAuth2Params.getOauth2AuthorizationEndpoint(), (String)DEFAULT_GOOGLE_AUTHORIZATION_ENDPOINT);
        String tokenEndpoint = StringUtils.defaultIfBlank((String)oAuth2Params.getOauth2TokenEndpoint(), (String)DEFAULT_GOOGLE_TOKEN_ENDPOINT);
        logger.infoV("Using OAuth2 authorize endpoint '%s' and token endpoint '%s'", new Object[]{authorizationEndpoint, tokenEndpoint});
        Params dkuPropertiesAsParams = ConnectionWithGoogleAuthCredentials.getDkuPropertiesAsParams(dkuProperties);
        boolean useCache = dkuPropertiesAsParams.getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(authorizationEndpoint).tokenEndpoint(tokenEndpoint).clientId(oAuth2Params.getOauth2ClientId()).clientSecret(oAuth2Params.getOauth2ClientSecret()).scope(StringUtils.defaultIfBlank((String)oAuth2Params.getOauth2Scope(), (String)oAuth2Params.getDefaultOauth2Scope())).accessType(OAuth2Client.AccessType.OFFLINE).prompt(OAuth2Client.PromptType.CONSENT).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    public static Params getDkuPropertiesAsParams(List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties) {
        return AbstractSQLConnection.CustomDatabaseProperty.toParams(dkuProperties);
    }

    public static boolean isJson(String str) {
        String trimmed = str.trim();
        return trimmed.startsWith("{") && trimmed.endsWith("}");
    }

    public static interface IGoogleAuth2Params {
        public AuthType getAuthType();

        public String getOauth2ClientId();

        public String getOauth2ClientSecret();

        public String getOauth2Scope();

        public String getOauth2AuthorizationEndpoint();

        public String getOauth2TokenEndpoint();

        public String getAppSecretContent();

        public String getServiceAccountEmail();

        public String getDefaultOauth2Scope();

        public boolean getRefreshTokenRotation();

        public String getUniverseDomain();

        public boolean isImpersonateServiceAccountAfterInitialAuth();

        public String getServiceAccountToImpersonateAfterInitialAuth();

        public boolean isPerformWIFTokenExchange();

        public String getWIFPoolProviderIncomingAudience();

        public String getWIFTokenAudience();

        public String getWIFTokenEndpoint();
    }

    public static enum AuthType {
        KEYPAIR,
        ENVIRONMENT,
        OAUTH;

    }

    public static class SimpleGoogleAuth2Params
    extends GoogleAuth2Params {
        private String defaultOauth2Scope;

        SimpleGoogleAuth2Params(IGoogleAuth2Params other) {
            super(other);
            this.defaultOauth2Scope = other.getDefaultOauth2Scope();
        }

        @Override
        public String getDefaultOauth2Scope() {
            return this.defaultOauth2Scope;
        }
    }

    public static abstract class GoogleAuth2Params
    extends DSSConnection.DkuConnectionParams
    implements IGoogleAuth2Params {
        public AuthType authType = AuthType.KEYPAIR;
        public String oauth2ClientId;
        public String oauth2ClientSecret;
        public String oauth2Scope;
        public String oauth2AuthorizationEndpoint;
        public String oauth2tokenEndpoint;
        public boolean refreshTokenRotation;
        public String appSecretContent;
        public String serviceAccountEmail;
        public String universeDomain;
        public boolean impersonateServiceAccountAfterInitialAuth = false;
        public String serviceAccountToImpersonateAfterInitialAuth;
        public boolean performWIFTokenExchange = false;
        public String wifPoolProviderIncomingAudience;
        public String wifTokenAudience;
        public String wifTokenEndpoint;

        public GoogleAuth2Params() {
        }

        public GoogleAuth2Params(IGoogleAuth2Params other) {
            this.authType = other.getAuthType();
            this.oauth2ClientId = other.getOauth2ClientId();
            this.oauth2ClientSecret = other.getOauth2ClientSecret();
            this.oauth2Scope = other.getOauth2Scope();
            this.oauth2AuthorizationEndpoint = other.getOauth2AuthorizationEndpoint();
            this.oauth2tokenEndpoint = other.getOauth2TokenEndpoint();
            this.appSecretContent = other.getAppSecretContent();
            this.serviceAccountEmail = other.getServiceAccountEmail();
            this.refreshTokenRotation = other.getRefreshTokenRotation();
            this.universeDomain = other.getUniverseDomain();
            this.impersonateServiceAccountAfterInitialAuth = other.isImpersonateServiceAccountAfterInitialAuth();
            this.serviceAccountToImpersonateAfterInitialAuth = other.getServiceAccountToImpersonateAfterInitialAuth();
            this.performWIFTokenExchange = other.isPerformWIFTokenExchange();
            this.wifPoolProviderIncomingAudience = other.getWIFPoolProviderIncomingAudience();
            this.wifTokenAudience = other.getWIFTokenAudience();
            this.wifTokenEndpoint = other.getWIFTokenEndpoint();
        }

        @Override
        public AuthType getAuthType() {
            return this.authType;
        }

        @Override
        public String getOauth2ClientId() {
            return this.oauth2ClientId;
        }

        @Override
        public String getOauth2ClientSecret() {
            return this.oauth2ClientSecret;
        }

        @Override
        public String getOauth2Scope() {
            return this.oauth2Scope;
        }

        @Override
        public String getOauth2AuthorizationEndpoint() {
            return this.oauth2AuthorizationEndpoint;
        }

        @Override
        public String getOauth2TokenEndpoint() {
            return this.oauth2tokenEndpoint;
        }

        @Override
        public String getAppSecretContent() {
            return this.appSecretContent;
        }

        @Override
        public String getServiceAccountEmail() {
            return this.serviceAccountEmail;
        }

        @Override
        public boolean getRefreshTokenRotation() {
            return this.refreshTokenRotation;
        }

        @Override
        public String getUniverseDomain() {
            return this.universeDomain;
        }

        @Override
        public boolean isImpersonateServiceAccountAfterInitialAuth() {
            return this.impersonateServiceAccountAfterInitialAuth;
        }

        @Override
        public String getServiceAccountToImpersonateAfterInitialAuth() {
            return this.serviceAccountToImpersonateAfterInitialAuth;
        }

        @Override
        public boolean isPerformWIFTokenExchange() {
            return this.performWIFTokenExchange;
        }

        @Override
        public String getWIFPoolProviderIncomingAudience() {
            return this.wifPoolProviderIncomingAudience;
        }

        @Override
        public String getWIFTokenAudience() {
            return this.wifTokenAudience;
        }

        @Override
        public String getWIFTokenEndpoint() {
            return this.wifTokenEndpoint;
        }
    }

    public static class SerializableGoogleAuthCredentials {
        public AuthType authType;
        public String keyPath;
        public String keyJsonData;
        public String keyBase64Data;
        public String keyEmail;
        public long keyLastModified;
        public String oauthAppId;
        public String oauthAppSecret;
        public String oauthRefreshToken;
        public String oauthAccessToken;
        public String oauthAuthorizationEndpoint;
        public String oauthTokenEndpoint;
        public long oauthAccessTokenExpiresOn;

        public String getLocalKeyPath(DSSConnection conn) {
            MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(conn);
            if (rmiTo == null) {
                return this.keyPath;
            }
            try {
                byte[] data;
                AutoDelete folder = FlowJobUtils.getTmpFolder("google-creds", "key");
                if (StringUtils.isNotBlank((String)this.keyJsonData)) {
                    data = this.keyJsonData.getBytes(StandardCharsets.UTF_8);
                } else if (StringUtils.isNotBlank((String)this.keyBase64Data)) {
                    data = Base64.getDecoder().decode(this.keyBase64Data);
                } else {
                    throw new IllegalArgumentException("No key data available");
                }
                File file = new File((File)folder, "creds.key");
                FileUtils.writeByteArrayToFile((File)file, (byte[])data);
                return file.getAbsolutePath();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to set key locally", e);
            }
        }

        public GoogleCredential toGoogleCredential(ConnectionWithBasicCredential.CredentialResolutionContext ctx, DSSConnection conn) throws IOException, DKUSecurityException {
            NetHttpTransport transport = ProxyUtils.getNetHttpTransport((ProxySettings)conn.getProxySettings());
            return this.toTypedGoogleCredential(new GoogleCredentialsBuilder.OldGoogleCredentialsBuilder((HttpTransport)transport, ctx, (ConnectionWithGoogleAuthCredentials)((Object)conn)), ctx, conn);
        }

        public GoogleCredentials toGoogleCredentials(ConnectionWithBasicCredential.CredentialResolutionContext ctx, DSSConnection conn) throws IOException, DKUSecurityException {
            NetHttpTransport transport = ProxyUtils.getNetHttpTransport((ProxySettings)conn.getProxySettings());
            return this.toTypedGoogleCredential(new GoogleCredentialsBuilder.NewGoogleCredentialsBuilder((HttpTransport)transport, ctx, (ConnectionWithGoogleAuthCredentials)((Object)conn)), ctx, conn);
        }

        private <T> T toTypedGoogleCredential(GoogleCredentialsBuilder.AbstractGoogleCredentialsBuilder<T> builder, ConnectionWithBasicCredential.CredentialResolutionContext ctx, DSSConnection conn) throws IOException, DKUSecurityException {
            switch (this.authType) {
                case OAUTH: {
                    return builder.buildFromOauth2(this.oauthAppId, this.oauthAppSecret, this.oauthRefreshToken, this.oauthAccessToken, StringUtils.defaultIfBlank((String)this.oauthTokenEndpoint, (String)ConnectionWithGoogleAuthCredentials.DEFAULT_GOOGLE_TOKEN_ENDPOINT));
                }
                case KEYPAIR: 
                case ENVIRONMENT: {
                    if (StringUtils.isNotBlank((String)this.keyPath)) {
                        boolean refreshMe;
                        MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(conn);
                        if (rmiTo == null) {
                            File keyFile = new File(this.keyPath);
                            refreshMe = !keyFile.exists() || this.keyLastModified != keyFile.lastModified();
                        } else {
                            boolean bl = refreshMe = this.keyLastModified != GoogleCredentialsBuilder.getLastModified(this.keyPath, rmiTo, conn);
                        }
                        if (refreshMe) {
                            SerializableGoogleAuthCredentials refreshed = conn.getFullyResolvedCredentials_fsLike(ctx, SerializableGoogleAuthCredentials.class);
                            this.keyPath = refreshed.keyPath;
                            this.keyLastModified = refreshed.keyLastModified;
                            this.keyJsonData = refreshed.keyJsonData;
                            this.keyBase64Data = refreshed.keyBase64Data;
                            this.keyEmail = refreshed.keyEmail;
                        }
                    }
                    if (StringUtils.isNotBlank((String)this.keyJsonData)) {
                        return builder.buildFromJson(this.keyJsonData);
                    }
                    if (StringUtils.isNotBlank((String)this.keyBase64Data)) {
                        try {
                            return builder.buildFromP12(this.keyBase64Data, this.keyEmail);
                        }
                        catch (GeneralSecurityException e) {
                            throw new DKUSecurityException("Unable to create google credentials", (Throwable)e);
                        }
                    }
                    if (this.authType == AuthType.KEYPAIR) {
                        throw new DKUSecurityException("Unable to find private key");
                    }
                    MainLoggingConfigurator.ProcessType rmiTo = CredentialsRemoteFetchConfigurationProvider.getCredentialsRemoteProvider(conn);
                    if (rmiTo != null) {
                        CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo fetchInfo = new CredentialsRemoteFetchConfigurationProvider.CredentialsRemoteFetchInfo(rmiTo);
                        return builder.buildFromRemoteEnvironment(() -> CredentialsRemoteFetchConfigurationProvider.getFromRemote(fetchInfo, "/connections/refresh-google-default-credential-access-token", GoogleCredentialCache.RawTokenResponse.class, "name", conn.name));
                    }
                    return builder.buildFromLocalEnvironment();
                }
            }
            throw new DKUSecurityException("Unknown authentication type " + String.valueOf((Object)this.authType));
        }

        public ICredentialsService.OAuth2CredentialWithExpiry toOAuth2Credential() {
            return new ICredentialsService.OAuth2CredentialWithExpiry(this.oauthAccessToken, this.oauthAccessTokenExpiresOn);
        }
    }
}

