/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCustomMetadata;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.datalineage.RecipeManualLineageConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.OverrideTable;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@UIModel
public class SerializedRecipe
extends TaggableObjectsService.TaggableObject {
    public static final String ROLE_MAIN = "main";
    @JSON.FileTransient
    public String name;
    @JSON.FileTransient
    public String projectKey;
    public String type;
    public boolean neverRecomputeExistingPartitions;
    public RecipeParams params;
    public String doc;
    public OverrideTable overrideTable;
    public ObjectCustomMetadata customMeta = new ObjectCustomMetadata();
    public boolean redispatchPartitioning;
    public int maxRunningActivities;
    public RecipeManualLineageConfig manualLineageConfig;
    public RecipeHashPropagationBehavior hashPropagationBehavior = RecipeHashPropagationBehavior.INHERIT;
    public JsonObject variables = new JsonObject();
    public List<AbstractSQLConnection.CustomDatabaseProperty> dkuProperties = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
    private Map<String, InputRole> inputs = new HashMap<String, InputRole>();
    private Map<String, OutputRole> outputs = new HashMap<String, OutputRole>();
    public List<SimpleKeyValue> labels = new ArrayList<SimpleKeyValue>();

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.RECIPE;
    }

    @Override
    public String getSubtype() {
        return this.type;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public void setId(String id) {
        this.name = id;
    }

    public String getType() {
        return this.type;
    }

    public void setInputs_INT(Map<String, InputRole> inputs) {
        this.inputs = inputs;
    }

    public void setOutputs_INT(Map<String, OutputRole> outputs) {
        this.outputs = outputs;
    }

    public List<RecipeInput> getInputsForRole(String role) {
        if (this.inputs.get(role) == null) {
            return new ArrayList<RecipeInput>();
        }
        return this.inputs.get((Object)role).items;
    }

    public RecipeInput getInput(String role, String ref) {
        if (this.inputs.get(role) == null) {
            return null;
        }
        for (RecipeInput ri : this.inputs.get((Object)role).items) {
            if (!ri.ref.equals(ref)) continue;
            return ri;
        }
        return null;
    }

    public Map<String, InputRole> getInputsUnsafe() {
        return this.inputs;
    }

    public Map<String, OutputRole> getOutputsUnsafe() {
        return this.outputs;
    }

    public List<RecipeInput> getFlatInputs() {
        ArrayList<RecipeInput> ret = new ArrayList<RecipeInput>();
        for (InputRole role : this.inputs.values()) {
            ret.addAll(role.items);
        }
        return ret;
    }

    public List<RecipeOutput> getFlatOutputs() {
        ArrayList<RecipeOutput> ret = new ArrayList<RecipeOutput>();
        for (OutputRole role : this.outputs.values()) {
            ret.addAll(role.items);
        }
        return ret;
    }

    public RecipeInput addInput(String role, String name) {
        if (!this.inputs.containsKey(role)) {
            this.inputs.put(role, new InputRole());
        }
        RecipeInput ri = new RecipeInput(name);
        this.inputs.get((Object)role).items.add(ri);
        return ri;
    }

    public RecipeInput getSingleInput(String role) {
        if (!this.inputs.containsKey(role)) {
            throw ErrorContext.iaef((String)"Recipe has no input for role '%s'", (Object)role, (Object[])new Object[0]);
        }
        if (this.inputs.get((Object)role).items.size() == 0) {
            throw ErrorContext.iaef((String)"Recipe has no input for role '%s'", (Object)role, (Object[])new Object[0]);
        }
        if (this.inputs.get((Object)role).items.size() > 1) {
            throw ErrorContext.iaef((String)"Recipe has multiple inputs for role '%s', expected just 1", (Object)role, (Object[])new Object[0]);
        }
        return this.inputs.get((Object)role).items.get(0);
    }

    public RecipeOutput addOutput(String role, String name, boolean appendMode) {
        if (!this.outputs.containsKey(role)) {
            this.outputs.put(role, new OutputRole());
        }
        RecipeOutput output = new RecipeOutput(name);
        this.outputs.get((Object)role).items.add(output);
        output.appendMode = appendMode;
        return output;
    }

    public List<RecipeOutput> getOutputsForRole(String role) {
        if (this.outputs.get(role) == null) {
            return new ArrayList<RecipeOutput>();
        }
        return this.outputs.get((Object)role).items;
    }

    public RecipeOutput getOutput(String role, String ref) {
        if (this.outputs.get(role) == null) {
            return null;
        }
        for (RecipeOutput ro : this.outputs.get((Object)role).items) {
            if (!ro.ref.equals(ref)) continue;
            return ro;
        }
        return null;
    }

    public RecipeOutput getOutputAnyRole(String ref) {
        for (OutputRole orole : this.outputs.values()) {
            for (RecipeOutput ro : orole.items) {
                if (!ro.ref.equals(ref)) continue;
                return ro;
            }
        }
        return null;
    }

    public RecipeOutput getSingleOutput(String role) {
        if (!this.outputs.containsKey(role)) {
            throw ErrorContext.iaef((String)"Recipe has no output for role '%s'", (Object)role, (Object[])new Object[0]);
        }
        if (this.outputs.get((Object)role).items.size() == 0) {
            throw ErrorContext.iaef((String)"Recipe has no output for role '%s'", (Object)role, (Object[])new Object[0]);
        }
        if (this.outputs.get((Object)role).items.size() > 1) {
            throw ErrorContext.iaef((String)"Recipe has multiple outputs for role '%s', expected just 1", (Object)role, (Object[])new Object[0]);
        }
        return this.outputs.get((Object)role).items.get(0);
    }

    @Nullable
    public RecipeOutput getSingleOutputOrNull(String role) {
        if (!this.outputs.containsKey(role) || this.outputs.get((Object)role).items.isEmpty()) {
            return null;
        }
        if (this.outputs.get((Object)role).items.size() > 1) {
            throw ErrorContext.iaef((String)"Recipe has multiple outputs for role '%s', expected just 1", (Object)role, (Object[])new Object[0]);
        }
        return this.outputs.get((Object)role).items.get(0);
    }

    public void clearInputs() {
        this.inputs.clear();
    }

    public void clearInputsForRole(String role) {
        if (this.inputs.containsKey(role)) {
            this.inputs.get((Object)role).items.clear();
        }
    }

    public void clearOutputs() {
        this.outputs.clear();
    }

    public void clearOutputsForRole(String role) {
        if (this.outputs.containsKey(role)) {
            this.outputs.get((Object)role).items.clear();
        }
    }

    public <T extends RecipeParams> T getParamsAs(Class<T> clazz) {
        return (T)((RecipeParams)clazz.cast(this.params));
    }

    public static enum RecipeHashPropagationBehavior {
        INHERIT,
        DISABLED,
        ENABLED_BUT_IGNORE_NON_READY_SOURCES,
        ENABLED;


        public static RecipeHashPropagationBehavior getEffectivePropagationBehavior(SerializedProject project, JobActivity activity) {
            RecipeHashPropagationBehavior hashPropagationBehavior = activity.getSubgraph() instanceof RecipeRunnableSubgraph ? ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel().hashPropagationBehavior : INHERIT;
            if (hashPropagationBehavior == INHERIT && (hashPropagationBehavior = project.settings.flowBuildSettings.defaultRecipeHashPropagationBehavior) == INHERIT) {
                throw new IllegalArgumentException("Project-level default for hash propagation mode cannot be INHERIT");
            }
            return hashPropagationBehavior;
        }
    }

    public static class InputRole {
        public List<RecipeInput> items = new ArrayList<RecipeInput>();
    }

    public static class RecipeInput {
        public String ref;
        public List<SDep> deps = new ArrayList<SDep>();

        public RecipeInput() {
        }

        public RecipeInput(String ref) {
            this.ref = ref;
        }

        public AnyLoc getLoc(String contextProjectKey) {
            return AnyLoc.resolveSmart(contextProjectKey, this.ref);
        }
    }

    public static class OutputRole {
        public List<RecipeOutput> items = new ArrayList<RecipeOutput>();
    }

    public static class RecipeOutput {
        public String ref;
        public boolean appendMode;

        public RecipeOutput() {
        }

        public RecipeOutput(String ref) {
            this.ref = ref;
        }

        public AnyLoc getLoc(String contextProjectKey) {
            return AnyLoc.resolveSmart(contextProjectKey, this.ref);
        }

        public Output.WriteMode getWriteMode() {
            return this.appendMode ? Output.WriteMode.APPEND : Output.WriteMode.OVERWRITE;
        }
    }

    public static class RecipeListItem
    extends TaggableObjectsService.TaggableListItem {
        public final String type;

        public RecipeListItem(SerializedRecipe sr) {
            super(sr);
            this.type = sr.type;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.RECIPE;
        }
    }

    public static class SDep {
        public String out;
        public String idim;
        public String odim;
        public String func;
        public Map<String, String> params = new HashMap<String, String>();
        public List<String> values;
        public boolean expandVariables;

        public SDep() {
        }

        public static SDep allAvailable(String out, String idim) {
            SDep dep = new SDep();
            dep.out = out;
            dep.idim = idim;
            dep.func = "all_available";
            return dep;
        }

        public SDep(String out, String idim, String odim, String func) {
            this.out = out;
            this.idim = idim;
            this.odim = odim;
            this.func = func;
        }

        public boolean expectsSinglePartition() {
            DimensionDependencyType ddt = DimensionDependencyType.forType(this.func);
            return ddt.expectsSinglePartition;
        }
    }

    public static enum DimensionDependencyType {
        SLIDING_DAYS("sliding_days", "Sliding days", false),
        TIME_RANGE("time_range", "Time range", false),
        CURRENT_MONTH("current_month", "Since beginning of month", false),
        CURRENT_WEEK("current_week", "Since beginning of week", false),
        EQUALS("equals", "Equals", true),
        WHOLE_MONTH("whole_month", "Whole month", false),
        VALUES("values", "Explicit values", false),
        LATEST_AVAILABLE("latest_available", "Latest available", true),
        ALL_AVAILABLE("all_available", "All available", false),
        CUSTOM_PYTHON("custom_python", "Custom Python code", false);

        final String type;
        final String description;
        final boolean expectsSinglePartition;

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        private DimensionDependencyType(String type, String description, boolean expectsSinglePartition) {
            this.type = type;
            this.description = description;
            this.expectsSinglePartition = expectsSinglePartition;
        }

        public static DimensionDependencyType forType(String type) {
            for (DimensionDependencyType t : DimensionDependencyType.values()) {
                if (!t.type.equals(type)) continue;
                return t;
            }
            throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_PDEP_UPDATE_REQUIRED, "Unknown dependency type " + type);
        }
    }

    public static class SerializedRecipeAndPayload {
        public SerializedRecipe recipe;
        public String payload;

        public SerializedRecipeAndPayload() {
        }

        public SerializedRecipeAndPayload(SerializedRecipe recipe, String payload) {
            this.recipe = recipe;
            this.payload = payload;
        }
    }
}

