/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.custom;

import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;

public class UnavailablePluginItemInfo {
    public String objectType;
    public String pluginId;
    public String elementId;
    private static final List<String> PREINSTALLED_SAMPLE_TYPES = List.of("Sample_default-samples_flight_data", "Sample_default-samples_real_estate_sales", "Sample_default-samples_retail_store_inventory");
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.plugin.unavailableinfo");

    public UnavailablePluginItemInfo(String pluginId, String objectType, String elementId) {
        this.pluginId = pluginId;
        this.objectType = objectType;
        this.elementId = elementId;
    }

    public UnavailablePluginItemInfo(String type, String objectTypeParam) {
        this.pluginId = "unknown-plugin-id";
        this.elementId = "unknown-element-id";
        this.objectType = "unknown-object-type";
        String[] splitType = null;
        if (type != null) {
            splitType = PREINSTALLED_SAMPLE_TYPES.contains(type) ? type.split("_", 3) : type.split("_");
        }
        if (splitType == null) {
            logger.warnV("Could not parse type %s of object type %s", new Object[]{type, objectTypeParam});
            return;
        }
        if (splitType.length > 2) {
            this.pluginId = splitType[splitType.length - 2];
            this.elementId = splitType[splitType.length - 1];
            this.objectType = null == objectTypeParam ? Joiner.on((String)"_").join((Object[])Arrays.copyOfRange(splitType, 0, splitType.length - 2)) : objectTypeParam;
        } else if (splitType.length == 2 && ("CustomPython".equals(objectTypeParam) || "CustomJava".equals(objectTypeParam) || "Sample".equals(objectTypeParam))) {
            this.elementId = splitType[1];
            this.objectType = objectTypeParam;
        } else {
            logger.warnV("Could not parse type %s of object type %s", new Object[]{type, objectTypeParam});
        }
    }

    public static UnavailablePluginItemInfo fromObjectTypeAndType(String objectType, String type) {
        return new UnavailablePluginItemInfo(type, objectType);
    }
}

