/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dao;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.dao.AbstractStandardDAO;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.sqlnotebooks.SQLNotebookResultExploreParams;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.DirectoryFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SQLNotebooksDAO
extends AbstractStandardDAO<SQLNotebook> {
    private static final String PARAMS_JSON = "params.json";
    private static final String EXPLORE_PARAMS_FILE_NAME = "explore_params.json";
    private final File rootFolder = ApplicationConfigurator.getBaseFolderF();

    @Override
    public List<SQLNotebook> list(String projectKey) throws IOException {
        return this.list(projectKey, false);
    }

    @Override
    public List<SQLNotebook> listUnsafe(String projectKey) throws IOException {
        return this.list(projectKey, true);
    }

    @Override
    protected String getHumanReadableType() {
        return ITaggingService.TaggableType.SQL_NOTEBOOK.toHumanReadableString();
    }

    @Override
    protected List<SQLNotebook> list_noTag(String projectKey, boolean unsafe) throws IOException {
        TransactionRef t = TransactionContext.retrieveRead();
        ArrayList<SQLNotebook> ret = new ArrayList<SQLNotebook>();
        RelFile notebooksFolder = this.notebooksFolder(projectKey);
        if (!t.isDirectory(notebooksFolder)) {
            return ret;
        }
        for (RelFile f : t.listFiles(notebooksFolder, (RelFileFilter)DirectoryFilter.containingFile((String)PARAMS_JSON))) {
            try {
                String id = f.getLeafName();
                SQLNotebook sn = (SQLNotebook)this.getMandatory(projectKey, id, unsafe);
                ret.add(sn);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Error in sql notebook file: " + String.valueOf(f)), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public int approximateCount(String projectKey) throws IOException {
        RelFile notebooksFolder;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.isDirectory(notebooksFolder = this.notebooksFolder(projectKey))) {
            return 0;
        }
        return t.listFiles(notebooksFolder, (RelFileFilter)DirectoryFilter.containingFile((String)PARAMS_JSON)).size();
    }

    @Override
    protected SQLNotebook getOrNull_noTag(String projectKey, String id, boolean unsafe) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"SQLNotebook id is not specified");
        TransactionRef t = TransactionContext.retrieveRead();
        RelFile file = this.getDAOFile(projectKey, id);
        if (!t.isFile(file)) {
            return null;
        }
        SQLNotebook qh = unsafe ? (SQLNotebook)t.readObjectUnsafe(file, SQLNotebook.class) : (SQLNotebook)t.readObject(file, SQLNotebook.class);
        qh.projectKey = projectKey;
        qh.id = id;
        qh.language = this.getType(qh.connection);
        return qh;
    }

    private SQLNotebook.SQLNotebookType getType(String connection) {
        ConnectionsDAO.VirtualConnectionId virtualConnection = ConnectionsDAO.parseVirtualConnection(connection);
        if (virtualConnection == null) {
            return SQLNotebook.SQLNotebookType.SQL;
        }
        if (virtualConnection.type.contains("impala")) {
            return SQLNotebook.SQLNotebookType.IMPALA;
        }
        if (virtualConnection.type.contains("hive")) {
            return SQLNotebook.SQLNotebookType.HIVE;
        }
        return SQLNotebook.SQLNotebookType.SPARKSQL;
    }

    @Override
    public void delete(String projectKey, String id) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile folder = this.notebookFolder(projectKey, id);
        t.deleteDirectory(folder);
        File resultFolderFile = this.resultFolder(projectKey, id);
        if (resultFolderFile.isDirectory()) {
            DKUFileUtils.deleteDirectory((File)resultFolderFile);
        }
    }

    public void copy(SQLNotebook nbk, SQLNotebook newNbk) throws Exception {
        this.save(newNbk);
        QueriesFile qf = this.readQueriesUnsafe(nbk.projectKey, nbk.id);
        this.writeQueries(newNbk.projectKey, newNbk.id, qf);
        File oldResultFolder = this.resultFolder(nbk.projectKey, nbk.id);
        File newResultFolder = this.resultFolder(newNbk.projectKey, newNbk.id);
        if (oldResultFolder.isDirectory() && !newResultFolder.exists()) {
            DKUFileUtils.copyDirectory((File)oldResultFolder, (File)newResultFolder);
        }
    }

    public void writeQueries(String projectKey, String notebookId, QueriesFile data) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.writeObject(this.getDAOFile(projectKey, notebookId, "queries.json"), (Object)data);
    }

    public QueriesFile getQueries(String projectKey, String notebookId) throws IOException {
        return this.getQueries(projectKey, notebookId, false);
    }

    public QueriesFile readQueriesUnsafe(String projectKey, String notebookId) throws IOException {
        return this.getQueries(projectKey, notebookId, true);
    }

    private QueriesFile getQueries(String projectKey, String notebookId, boolean unsafe) throws IOException {
        RelFile f;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(f = this.getDAOFile(projectKey, notebookId, "queries.json"))) {
            return new QueriesFile();
        }
        if (unsafe) {
            return (QueriesFile)t.readObjectUnsafe(f, QueriesFile.class);
        }
        return (QueriesFile)t.readObject(f, QueriesFile.class);
    }

    public void writeResult(String projectKey, String notebookId, String qid, QueryRunResult result) throws IOException {
        JSON.prettyToFile((Object)result, (File)this.resultFile(projectKey, notebookId, qid));
    }

    public QueryRunResult readResult(String projectKey, String notebookId, String qid) throws IOException {
        File f = this.resultFile(projectKey, notebookId, qid);
        if (f.exists()) {
            return (QueryRunResult)JSON.parseFile((File)f, QueryRunResult.class);
        }
        return null;
    }

    @Deprecated
    public Collection<String> gatherTagsForProject(String projectKey) throws IOException {
        RelFile notebooksFolder;
        HashSet<String> tags = new HashSet<String>();
        TransactionRef t = TransactionContext.retrieveRead();
        if (t.isDirectory(notebooksFolder = this.notebooksFolder(projectKey))) {
            for (RelFile f : t.listFiles(notebooksFolder, (RelFileFilter)DirectoryFilter.containingFile((String)PARAMS_JSON))) {
                String notebookId = f.getLeafName();
                SQLNotebook nbk = (SQLNotebook)t.readObjectUnsafe(this.getDAOFile(projectKey, notebookId, PARAMS_JSON), SQLNotebook.class);
                if (nbk == null) continue;
                tags.addAll(nbk.tags);
            }
        }
        return tags;
    }

    public void writeQueryToHistory(String projectKey, String notebookId, String cellId, SQLNotebookQuery q) throws Exception {
        Preconditions.checkArgument((cellId != null ? 1 : 0) != 0, (Object)"Notebook cell id is not specified");
        SQLNotebook notebook = (SQLNotebook)this.getMandatory(projectKey, notebookId);
        this.save(notebook);
        QueriesFile qf = this.getQueries(projectKey, notebookId);
        boolean updated = false;
        List<SQLNotebookQuery> cellQueries = qf.queries.get(cellId);
        if (cellQueries == null) {
            cellQueries = new ArrayList<SQLNotebookQuery>();
            qf.queries.put(cellId, cellQueries);
        }
        for (int i = 0; i < cellQueries.size(); ++i) {
            SQLNotebookQuery cq = cellQueries.get(i);
            if (!StringUtils.equals((String)cq.id, (String)q.id)) continue;
            cellQueries.set(i, q);
            updated = true;
            break;
        }
        if (!updated) {
            cellQueries.add(q);
        }
        int limit = ApplicationConfigurator.getParams().getIntParam("dku.notebooks.sql.cellHistoryLimit", Integer.valueOf(250));
        if (cellQueries.size() > limit) {
            cellQueries.sort(Comparator.comparing(c2 -> c2.runOn).reversed());
            cellQueries.subList(limit, cellQueries.size()).clear();
        }
        this.writeQueries(projectKey, notebookId, qf);
    }

    public Map<String, List<SQLNotebookQuery>> readHistory(String projectKey, String notebookId) throws IOException {
        QueriesFile qf = this.getQueries(projectKey, notebookId);
        for (String cellId : qf.queries.keySet()) {
            DKUtils.listSort(qf.queries.get(cellId), (String)"runOn", (boolean)true);
        }
        return qf.queries;
    }

    public Optional<SQLNotebookResultExploreParams> readResultExploreParams(String projectKey, String notebookId, boolean unsafe) throws IOException {
        RelFile exploreParamsFile;
        TransactionRef t = TransactionContext.retrieveRead();
        if (!t.exists(exploreParamsFile = this.getDAOFile(projectKey, notebookId, EXPLORE_PARAMS_FILE_NAME))) {
            return Optional.empty();
        }
        if (unsafe) {
            return Optional.of((SQLNotebookResultExploreParams)t.readObjectUnsafe(exploreParamsFile, SQLNotebookResultExploreParams.class));
        }
        return Optional.of((SQLNotebookResultExploreParams)t.readObject(exploreParamsFile, SQLNotebookResultExploreParams.class));
    }

    public void writeResultExploreParams(String projectKey, String notebookId, SQLNotebookResultExploreParams exploreParams) throws IOException {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        RelFile exploreParamsFile = this.getDAOFile(projectKey, notebookId, EXPLORE_PARAMS_FILE_NAME);
        t.writeObject(exploreParamsFile, (Object)exploreParams);
    }

    public void removeQuery(String projectKey, String notebookId, String cellId, String qid) throws Exception {
        SQLNotebook notebook = (SQLNotebook)this.getMandatory(projectKey, notebookId);
        this.save(notebook);
        QueriesFile qf = this.getQueries(projectKey, notebookId);
        if (!qf.queries.containsKey(cellId)) {
            throw ErrorContext.iaef((String)"Cell id %s not found", (Object)cellId, (Object[])new Object[0]);
        }
        DKUtils.listRemove(qf.queries.get(cellId), (String)"id", (String)qid);
        this.writeQueries(projectKey, notebookId, qf);
        this.removeResultFiles(projectKey, notebookId, qid);
    }

    private void removeResultFiles(String projectKey, String notebookId, String qid) throws IOException {
        File chartCacheFolder;
        File sampleResultFile;
        File rf = this.resultFile(projectKey, notebookId, qid);
        if (rf.exists()) {
            DKUFileUtils.forceDelete((File)rf);
        }
        if ((sampleResultFile = this.resultSampleFile(projectKey, notebookId, qid)).exists()) {
            DKUFileUtils.forceDelete((File)sampleResultFile);
        }
        if ((chartCacheFolder = this.resultChartsCacheFolder(projectKey, notebookId, qid)).exists()) {
            DKUFileUtils.forceDelete((File)chartCacheFolder);
        }
    }

    public SQLNotebookQuery readQueryFromHistory(String projectKey, String notebookId, String cellId, String queryId) throws IOException {
        QueriesFile qf = this.getQueries(projectKey, notebookId);
        if (!qf.queries.containsKey(cellId)) {
            throw ErrorContext.iaef((String)"Cell id %s not found", (Object)cellId, (Object[])new Object[0]);
        }
        return (SQLNotebookQuery)DKUtils.listFind(qf.queries.get(cellId), (String)"id", (String)queryId);
    }

    private RelFile notebooksFolder(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey, "notebooks", "sql"});
    }

    private RelFile notebookFolder(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Notebook id is not specified");
        return this.notebooksFolder(projectKey).append(new String[]{id});
    }

    private File resultFolder(String projectKey, String id) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id), (Object)"Notebook id is not specified");
        return DKUFileUtils.getWithin((File)this.rootFolder, (String[])new String[]{"notebook_results", "sql", projectKey, id});
    }

    private File resultFile(String projectKey, String notebookId, String qid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)qid), (Object)"Query id is not specified");
        return DKUFileUtils.getWithin((File)this.resultFolder(projectKey, notebookId), (String[])new String[]{qid + ".json"});
    }

    public File resultSampleFile(String projectKey, String notebookId, String qid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)qid), (Object)"Query id is not specified");
        String sampleFileName = SampleBuilder.sampleFilename(qid, ".dss1");
        return DKUFileUtils.getWithin((File)this.resultFolder(projectKey, notebookId), (String[])new String[]{sampleFileName});
    }

    public File resultChartsCacheFolder(String projectKey, String notebookId, String qid) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)qid), (Object)"Query id is not specified");
        return DKUFileUtils.getWithin((File)this.resultFolder(projectKey, notebookId), (String[])new String[]{qid});
    }

    @Override
    protected RelFile getDAOFile(String projectKey, String id) throws IOException {
        return this.getDAOFile(projectKey, id, PARAMS_JSON);
    }

    protected RelFile getDAOFile(String projectKey, String id, String name) throws IOException {
        return this.notebookFolder(projectKey, id).append(new String[]{name});
    }

    public static class QueriesFile {
        public Map<String, List<SQLNotebookQuery>> queries = new HashMap<String, List<SQLNotebookQuery>>();
    }

    public static class ProgressStatus {
        public boolean running;
        public String logTail;
        public SQLNotebookQuery query;
    }

    public static class StartedQuery {
        public SQLNotebookQuery toAddtoHistory;
    }
}

