/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datacollections;

import com.dataiku.dip.datacollections.AbstractDataCollectionItem;
import com.dataiku.dip.datacollections.DataCollectionDataset;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.Objects;

@PolyJSON(value={@Mapping(value=DatasetRef.class, type="DATASET")})
@UIModel
public abstract class AbstractDataCollectionItemRef {
    public abstract boolean refersTo(AbstractDataCollectionItem var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static class DatasetRef
    extends AbstractDataCollectionItemRef {
        public String projectKey;
        public String id;

        public DatasetRef(String projectKey, String id) {
            this.projectKey = projectKey;
            this.id = id;
        }

        public DatasetRef(AnyLoc loc) {
            this.projectKey = loc.getProjectKey();
            this.id = loc.getId();
        }

        private DatasetRef() {
        }

        @Override
        public boolean refersTo(AbstractDataCollectionItem item) {
            return item instanceof DataCollectionDataset && ((DataCollectionDataset)item).reference.equals(new AnyLoc(this.projectKey, this.id));
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof DatasetRef)) {
                return false;
            }
            DatasetRef datasetRef = (DatasetRef)obj;
            return Objects.equals(this.projectKey, datasetRef.projectKey) && Objects.equals(this.id, datasetRef.id);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.projectKey, this.id);
        }

        @Override
        public String toString() {
            return "DATASET " + this.projectKey + "." + this.id;
        }
    }
}

