/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Record;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.Matcher;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.verifier.MatcherFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Verifier {
    public final List<Matcher> matchers = new ArrayList<Matcher>();
    public final List<Integer> orderMatchers = new ArrayList<Integer>();
    private final boolean debugMode = false;

    public Verifier(FuzzyJoinRecipePayloadParams.JoinDesc joinDesc) {
        for (int i = 0; i < joinDesc.on.size(); ++i) {
            FuzzyJoinRecipePayloadParams.MatchingCondition condition = (FuzzyJoinRecipePayloadParams.MatchingCondition)joinDesc.on.get(i);
            FuzzyJoinRecipePayloadParams.DistanceType distanceType = condition.fuzzyMatchDesc.distanceType;
            double threshold = condition.fuzzyMatchDesc.threshold;
            Integer relativeTo = condition.fuzzyMatchDesc.relativeTo;
            this.matchers.add(MatcherFactory.getMatcher(distanceType, threshold, relativeTo, false));
            this.orderMatchers.add(i);
        }
        this.orderMatchers.sort(Comparator.comparing(this.matchers::get));
    }

    public VerifierResult computeMatch(Record query, Record candidate) {
        VerifierResult verifierResult = new VerifierResult(query, candidate);
        verifierResult.isMatch = true;
        for (int i = 0; i < this.matchers.size(); ++i) {
            verifierResult.matchResults.add(new Matcher.MatchResult());
        }
        for (int order : this.orderMatchers) {
            Matcher matcher = this.matchers.get(order);
            Matcher.MatchResult matchResult = matcher.computeMatch(query.getJoinValue(order), candidate.getJoinValue(order));
            verifierResult.isMatch &= matchResult.isMatch;
            verifierResult.matchResults.set(order, matchResult);
            if (verifierResult.isMatch) continue;
            return verifierResult;
        }
        return verifierResult;
    }

    public static class VerifierResult {
        public final Record query;
        public final Record candidate;
        public final List<Matcher.MatchResult> matchResults;
        public boolean isMatch;

        public VerifierResult(Record query, Record candidate) {
            this.query = query;
            this.candidate = candidate;
            this.matchResults = new ArrayList<Matcher.MatchResult>();
        }
    }
}

