/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.join;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.dataflow.exec.WithComputedColumns;
import com.dataiku.dip.dataflow.exec.WithPostFilter;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.ConditionsMode;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.j2ts.annotations.UIData;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@UIModel
public class JoinRecipePayloadParams
extends JoinLikeRecipePayloadParams<InputDesc, MatchingCondition, JoinDesc>
implements WithPostFilter,
WithComputedColumns,
ParamsWithContainerizable {
    public FilterDesc postFilter;
    public List<ComputedColumn> computedColumns;
    public boolean enableAutoCastInJoinConditions = false;

    public static boolean incompatibleTypesForJoinCondition(Type type1, Type type2) {
        return type1 != type2 && (!type1.isNumeric() || !type2.isNumeric());
    }

    @Override
    public void initializeJoinDesc() {
        super.initializeJoinDesc();
        ((JoinDesc)this.joins.get((int)0)).outerJoinOnTheLeft = true;
    }

    @Override
    public void validateJoinCondition(MatchingCondition cond) {
        if (cond.type == null) {
            throw ErrorContext.iae((String)"Invalid matching condition.");
        }
        if (!this.isValidColumnDesc(cond.column1) || !this.isValidColumnDesc(cond.column2)) {
            throw ErrorContext.iae((String)"Invalid column in matching conditions.");
        }
        if ((cond.type == MatchingType.K_NEAREST || cond.type == MatchingType.K_NEAREST_INFERIOR) && cond.maxDistance <= 0) {
            throw ErrorContext.iae((String)"Maximum distance parameter cannot be <= 0 for nearest matching mode.");
        }
    }

    @Override
    protected JoinDesc newJoinDesc() {
        return new JoinDesc();
    }

    @Override
    public InputDesc newInputDesc() {
        return new InputDesc();
    }

    @Override
    public List<ComputedColumn> getComputedColumns() {
        return this.computedColumns;
    }

    @Override
    public FilterDesc getPostFilter() {
        return this.postFilter;
    }

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    @UIModel
    public static class JoinDesc
    extends JoinDescBase<MatchingCondition> {
        public boolean outerJoinOnTheLeft;
        public String customSQLCondition;
        public RightLimitDesc rightLimit;

        public static JoinDesc of(int table1, JoinType type, int table2, ConditionsMode conditionsMode) {
            JoinDesc join = new JoinDesc();
            join.table1 = table1;
            join.type = type;
            join.table2 = table2;
            join.conditionsMode = conditionsMode;
            return join;
        }

        @Override
        public QueryAst.JoinType sqlType(JoinOutputRole role) {
            if (this.type == JoinType.ADVANCED) {
                if (this.conditionsMode != ConditionsMode.NATURAL) {
                    return this.outerJoinOnTheLeft ? QueryAst.JoinType.LEFT : QueryAst.JoinType.INNER;
                }
                return this.outerJoinOnTheLeft ? QueryAst.JoinType.NATURAL_LEFT : QueryAst.JoinType.NATURAL_INNER;
            }
            return super.sqlType(role);
        }

        public List<MatchingCondition> getIndexableConditions() {
            if (!this.requiresJoinConditions()) {
                return new ArrayList<MatchingCondition>();
            }
            if (this.conditionsMode == ConditionsMode.OR && this.on.size() == 1 && ((MatchingCondition)this.on.get((int)0)).type == MatchingType.EQ) {
                return this.on;
            }
            if (this.conditionsMode == ConditionsMode.AND) {
                return this.on.stream().filter(m -> m.type == MatchingType.EQ).collect(Collectors.toList());
            }
            return Lists.newArrayList();
        }

        @Override
        public RightLimitDesc getRightLimit() {
            if (this.type == JoinType.ADVANCED && this.rightLimit != null && this.rightLimit.enabled) {
                return this.rightLimit;
            }
            return null;
        }

        @Override
        public boolean hasImplicitOrExplicitRightLimit() {
            if (this.getRightLimit() != null) {
                return true;
            }
            for (MatchingCondition cond : this.getJoinConditions()) {
                if (cond.type != MatchingType.K_NEAREST && cond.type != MatchingType.K_NEAREST_INFERIOR) continue;
                return true;
            }
            return false;
        }

        public JoinDesc with(String column1, MatchingType type, String column2, boolean caseInsensitive, boolean normalizeText) {
            MatchingCondition cond = new MatchingCondition();
            cond.column1 = new ColumnDesc(this.table1, column1);
            cond.type = type;
            cond.column2 = new ColumnDesc(this.table2, column2);
            cond.normalizeText = normalizeText;
            cond.caseInsensitive = caseInsensitive;
            this.on.add(cond);
            return this;
        }

        public JoinDesc with(String column1, MatchingType type, String column2) {
            return this.with(column1, type, column2, false, false);
        }
    }

    public static class MatchingCondition
    extends MatchingConditionBase {
        public MatchingType type;
        public boolean caseInsensitive;
        public boolean normalizeText;
        public int maxDistance;
        public int maxMatches = 1;
        public boolean strict;
        public String dateDiffUnit = "DAY";
        public long windowFrom;
        public long windowTo;

        @Override
        public boolean isEqualityCondition() {
            return this.type == MatchingType.EQ;
        }
    }

    public static enum MatchingType {
        EQ("="),
        LTE("<="),
        LT("<"),
        GTE(">="),
        GT(">"),
        NE("!="),
        WITHIN_RANGE("Within range"),
        K_NEAREST("Nearest match"),
        K_NEAREST_INFERIOR("Nearest match before"),
        CONTAINS("Contains"),
        STARTS_WITH("Starts with"),
        WITHIN_WINDOW_OF("Within window of");

        private final String displayName;
        @UIData
        public static final Map<MatchingType, String> displayNames;

        private MatchingType(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        static {
            displayNames = Arrays.stream(MatchingType.values()).collect(Collectors.toMap(x -> x, MatchingType::getDisplayName));
        }
    }

    public static class InputDesc
    extends JoinInputDescBase {
        public static InputDesc ofTable(int index) {
            InputDesc inputDesc = new InputDesc();
            inputDesc.index = index;
            inputDesc.computedColumns = Lists.newArrayList();
            return inputDesc;
        }
    }

    public static class Builder {
        private final List<JoinDesc> joins = new ArrayList<JoinDesc>();
        private final Set<Integer> tables = new HashSet<Integer>();
        private final List<ColumnDesc> selectedColumns = new ArrayList<ColumnDesc>();

        public Builder join(JoinDesc joinDesc) {
            this.tables.add(joinDesc.table1);
            this.tables.add(joinDesc.table2);
            this.joins.add(joinDesc);
            return this;
        }

        public Builder select(ColumnDesc columnDesc) {
            this.selectedColumns.add(columnDesc);
            return this;
        }

        public JoinRecipePayloadParams build() {
            JoinRecipePayloadParams joinRecipePayloadParams = new JoinRecipePayloadParams();
            joinRecipePayloadParams.joins = this.joins;
            joinRecipePayloadParams.selectedColumns = this.selectedColumns;
            joinRecipePayloadParams.virtualInputs = this.tables.stream().map(InputDesc::ofTable).collect(Collectors.toList());
            return joinRecipePayloadParams;
        }
    }

    public static class RightLimitDesc {
        public boolean enabled;
        public int maxMatches = 1;
        public boolean strict;
        public SelectionType type;
        public ColumnDesc decisionColumn;
    }

    public static enum SelectionType {
        KEEP_ALL,
        KEEP_LARGEST,
        KEEP_SMALLEST;

    }
}

