/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.lsfolder;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeParams;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ListFolderContentsRecipeParams
extends RecipeParams
implements ParamsWithContainerizable {
    private List<LevelMappingDesc> levelMapping = new ArrayList<LevelMappingDesc>();
    public boolean path = true;
    public boolean basename = true;
    public boolean extension = true;
    public boolean lastModified = true;
    public boolean size = true;
    public ListFolderContentsRecipeEngineParams engineParams = new ListFolderContentsRecipeEngineParams();

    @Override
    public ContainerExecSelection getContainerSelection() {
        return this.engineParams.containerSelection;
    }

    @Override
    public void setContainerSelection(ContainerExecSelection selection) {
        this.engineParams.containerSelection = selection;
    }

    public void setLevelMapping(List<LevelMappingDesc> levelMapping) {
        this.levelMapping = levelMapping;
    }

    public List<LevelMappingDesc> getLevelMapping() {
        return this.levelMapping;
    }

    public void checkLevelMapping() {
        for (LevelMappingDesc m : this.getLevelMapping()) {
            int level;
            try {
                level = Integer.parseInt(m.from);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Levels must be integers different than 0");
            }
            if (level == 0) {
                throw new IllegalArgumentException("Levels must be different than 0");
            }
            String columnName = m.to;
            if (!StringUtils.isBlank((String)columnName)) continue;
            throw new IllegalArgumentException("Level mapping folder names must not be empty");
        }
    }

    public static class ListFolderContentsRecipeEngineParams {
        public ContainerExecSelection containerSelection = new ContainerExecSelection();
    }

    public static class LevelMappingDesc {
        public String from;
        public String to;

        public LevelMappingDesc(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }
}

