/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sampling;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.sampling.SQLBasedSamplingExecutor;
import com.dataiku.dip.dataflow.exec.sql.SQLGenerator;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.recipes.code.hive.HiveConfHelper;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.code.hive.HiveRecipeRunner;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.List;

public class HiveSamplingExecutor
extends SQLBasedSamplingExecutor {
    private HiveRecipeMeta.HiveRecipeParams params;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sampling.hive");

    public HiveSamplingExecutor(SQLGenerator sqlGenerator, HiveRecipeMeta.HiveRecipeParams params) {
        super(sqlGenerator);
        this.params = params;
    }

    @Override
    public void init(final JobActivity activity, Output.WriteMode writeMode) throws Exception {
        super.init(activity, writeMode);
        HiveRecipeRunner hiveRunner = new HiveRecipeRunner(activity){

            @Override
            protected String getSql() throws Exception {
                return HiveSamplingExecutor.this.sqlGenerator.generateSQL(new HiveSQLDialect());
            }

            @Override
            protected String getPreQueries() throws Exception {
                return HiveSamplingExecutor.this.params.preQueries;
            }

            @Override
            protected HiveRecipeMeta.HiveExecutionEngine getExecutionEngine() throws Exception {
                return HiveSamplingExecutor.this.params.executionEngine;
            }

            @Override
            protected boolean addDkuUdf() throws Exception {
                return HiveSamplingExecutor.this.params.addDkuUdf;
            }

            @Override
            protected List<SimpleKeyValue> getExtraConf() throws IOException, DKUSecurityException {
                logger.info((Object)"Resolving sampling extra conf");
                SerializedRecipe sr = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
                return new HiveConfHelper().getResolvedConf(HiveSamplingExecutor.this.authCtx, sr.projectKey, HiveSamplingExecutor.this.params);
            }

            @Override
            protected boolean canOverrideDatabase() {
                return false;
            }
        };
        this.runner = hiveRunner;
        SpringUtils.getInstance().autowire((Object)this.runner);
        hiveRunner.init();
    }
}

