/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.split;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.MultiEngineRecipeRunner;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.exec.split.SplitRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.recipes.code.hive.HiveQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.SplitRecipeService;
import com.dataiku.dip.shaker.types.Boolean;
import com.dataiku.dip.sql.MySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SplitRecipeHelper {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected SplitRecipeService splitService;
    protected static final String SPLIT_INNER_QUERY_WITH_ROW_NUMBER_ALIAS = "__dku_with_row_number";
    protected static final String SPLIT_INNER_QUERY_WITH_COMPUTED_COLUMNS_ALIAS = "__dku_computed_columns";
    protected static final String SPLIT_INNER_QUERY_WITH_PREFILTERS_AND_PARTITIONS_ALIAS = "__dku_prefilters_and_part";
    protected static final String SPLIT_ENRICHED_INPUT_ALIAS = "__dku_enriched_input";
    protected static final String ROW_NUMBER_ALIAS = "__dku_row_number";
    protected static final String COLUMNS_HASH_LAST_HEX = "__dku_sel_cols_h_last_hex";
    protected static final String SPLIT_QUERY_WITH_HASH_LAST_HEX = "__dku_q_sel_cols_h_last_hex";
    protected static final ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
    protected static final String SPLIT_ROW_TABLE_ALIAS = "__dku_row_table";
    protected static final String MAIN_QUERY_HIVE_ALIAS = "__dku_main_query";
    protected static final String RAND_VAR_ALIAS = "__dku_rand_var";
    private static final String CENTILE_QUERY_COMMENT = "Query requires number of rows in table to compute ranges of row numbers. Here, Value arbitrarily set to 100 and actual value computed at runtime.";
    private Boolean booleanMeaning = new Boolean();
    Map<String, ExpressionBuilder> effectiveConditions = new HashMap<String, ExpressionBuilder>();
    Map<String, Float> randomOutputs = new HashMap<String, Float>();
    Map<String, SizeAndOffset> centileOutputs = new HashMap<String, SizeAndOffset>();
    private List<ExpressionBuilder> centileOrderExpressions = new ArrayList<ExpressionBuilder>();
    private List<QueryAst.OrderType> centileOrderTypes = new ArrayList<QueryAst.OrderType>();
    SplitRecipePayloadParams params;
    String projectKey;
    JobActivity activity;
    private Dataset inputDS;
    private Dataset inputDSWithComputedColumnsSchema = null;
    private Schema inputAndComputedColumnsSchema;
    private Schema baseOutputSchema;
    List<Partition> sourcePartitions = null;
    PartitioningScheme sourcePartitionScheme = null;
    boolean lowerCaseColumns;
    long totalRecordsWithFilters = 100L;
    boolean shouldCommentCentileQuery = true;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.split");

    void setTotalRecordsWithFilters(long totalRecordsWithFilters) {
        this.totalRecordsWithFilters = totalRecordsWithFilters;
    }

    void setShouldCommentCentileQuery(boolean shouldCommentCentileQuery) {
        this.shouldCommentCentileQuery = shouldCommentCentileQuery;
    }

    void setLowerCaseColumns(boolean lowerCaseColumns) {
        this.lowerCaseColumns = lowerCaseColumns;
    }

    void setBaseOutputSchema(Schema baseOutputSchema) {
        this.baseOutputSchema = baseOutputSchema;
    }

    Schema getBaseOutputSchema() {
        return this.baseOutputSchema;
    }

    Dataset getInputDSWithComputedColumnsSchema(SQLDialect dialect) {
        if (this.inputDSWithComputedColumnsSchema == null) {
            if (dialect != null) {
                for (SchemaColumn sc : this.inputAndComputedColumnsSchema.getColumns()) {
                    if (!dialect.needCast(sc, this.inputDS.isManaged())) continue;
                    sc.originalSQLType = null;
                }
            }
            this.inputDSWithComputedColumnsSchema = ((Dataset)JSON.deepCopy((Object)this.inputDS)).withSchema(this.inputAndComputedColumnsSchema);
        }
        return this.inputDSWithComputedColumnsSchema;
    }

    public SplitRecipeHelper(JobActivity activity, Dataset inputDS, SplitRecipePayloadParams params, String projectKey) throws IOException {
        this.activity = activity;
        this.inputDS = inputDS;
        this.params = params;
        this.projectKey = projectKey;
        SpringUtils.getInstance().autowire((Object)this);
        this.inputAndComputedColumnsSchema = this.splitService.getInputAndComputedColumnsBaseSchema(inputDS, params, true);
    }

    protected void computeEffectiveConditions(SQLDialect dialect) {
        switch (this.params.mode) {
            case FILTERS: {
                this.computeEffectiveConditionsFromFilterSplits(this.params.filterSplits, dialect);
                break;
            }
            case VALUES: {
                this.computeEffectiveConditionsFromValueSplits(this.params.valueSplits);
                break;
            }
            case RANGE: {
                this.params.preprocessDateRanges();
                this.computeEffectiveConditionsFromFilterSplits(this.params.rangeSplits, dialect);
                break;
            }
            case RANDOM_COLUMNS: {
                this.computeEffectiveConditionsFromRandomColumnsSplits(this.params.randomColumnsSplits);
                break;
            }
            case CENTILE: {
                this.computeEffectiveConditionsFromCentileSplits(this.params.centileSplits);
                break;
            }
            case RANDOM: {
                this.computeRandomOutputs(this.params.randomSplits);
                break;
            }
            default: {
                throw ErrorContext.iae((String)"Split mode is not specified");
            }
        }
    }

    private void computeEffectiveConditionsFromCentileSplits(List<SplitRecipePayloadParams.ShareSplitDesc> splits) {
        ExpressionBuilder condition;
        String id;
        this.setCentileOrders(this.params.centileOrders);
        long totalRecords = this.totalRecordsWithFilters;
        long offset = 0L;
        ExpressionBuilder sortingCol = ef.col(ROW_NUMBER_ALIAS);
        for (SplitRecipePayloadParams.ShareSplitDesc split : splits) {
            long targetRecords = (long)Math.ceil(split.share.floatValue() * (float)totalRecords / 100.0f);
            if (split.outputDatasetFullName != null) {
                id = DatasetLocUtils.resolveSmart(this.projectKey, split.outputDatasetFullName).getFullName();
                condition = ef.and(sortingCol.gt(offset), sortingCol.lte(offset + targetRecords));
                this.addCondition(id, condition);
                this.centileOutputs.put(id, new SizeAndOffset(targetRecords, offset));
            }
            offset += targetRecords;
        }
        long remainingRecords = totalRecords - offset;
        if (StringUtils.isNotBlank((String)this.params.defaultOutputDataset) && remainingRecords > 0L) {
            id = DatasetLocUtils.resolveSmart(this.projectKey, this.params.defaultOutputDataset).getFullName();
            condition = sortingCol.gt(offset);
            this.addCondition(id, condition);
            this.centileOutputs.put(id, new SizeAndOffset(remainingRecords, offset));
        }
    }

    private void computeEffectiveConditionsFromFilterSplits(List<SplitRecipePayloadParams.FilterSplitDesc> filterSplits, SQLDialect dialect) {
        ExpressionBuilder previousCases = null;
        for (SplitRecipePayloadParams.FilterSplitDesc split : filterSplits) {
            ExpressionBuilder baseCondition = FilterDescUtils.getSQLExpressionBuilder(split.filter, dialect, this.getInputDSWithComputedColumnsSchema(dialect), true);
            ExpressionBuilder condition = previousCases == null ? baseCondition : baseCondition.and(previousCases.not());
            if (StringUtils.isNotBlank((String)split.outputDatasetFullName)) {
                String id = DatasetLocUtils.resolveSmart(this.projectKey, split.outputDatasetFullName).getFullName();
                this.addCondition(id, condition);
            }
            previousCases = this.nullProofOr(previousCases, baseCondition);
        }
        this.computeDefaultConditionByNegatingAllPreviousCases(previousCases);
    }

    private void computeEffectiveConditionsFromValueSplits(List<SplitRecipePayloadParams.ValueSplitDesc> valueSplits) {
        ExpressionBuilder previousCases = null;
        String splitColumn = this.params.column;
        if (splitColumn == null) {
            throw ErrorContext.iae((String)"No column selected.");
        }
        SchemaColumn splitSchemaColumn = this.inputAndComputedColumnsSchema.getColumn(splitColumn);
        for (SplitRecipePayloadParams.ValueSplitDesc split : valueSplits) {
            ExpressionBuilder condition;
            if (splitSchemaColumn != null && splitSchemaColumn.getType() == Type.BOOLEAN) {
                ExpressionBuilder boolCol = ef.col(splitColumn).castToBoolean();
                condition = this.booleanMeaning.parse(split.value) ? boolCol.isTrue() : boolCol.isFalse();
            } else {
                condition = splitSchemaColumn != null && splitSchemaColumn.getType().isInteger() ? (StringUtils.isBlank((String)split.value) ? ef.col(splitColumn).isnull() : ef.col(splitColumn).eq(Long.parseLong(split.value))) : (splitSchemaColumn != null && splitSchemaColumn.getType().isFloatingPoint() ? (StringUtils.isBlank((String)split.value) ? ef.col(splitColumn).isnull() : ef.col(splitColumn).eq(Double.parseDouble(split.value))) : (StringUtils.isBlank((String)split.value) ? ef.col(splitColumn).eq("").or(ef.col(splitColumn).isnull()) : ef.col(splitColumn).eq(split.value)));
            }
            if (StringUtils.isNotBlank((String)split.outputDatasetFullName)) {
                String id = DatasetLocUtils.resolveSmart(this.projectKey, split.outputDatasetFullName).getFullName();
                this.addCondition(id, condition);
            }
            previousCases = this.nullProofOr(previousCases, condition);
        }
        this.computeDefaultConditionByNegatingAllPreviousCases(previousCases);
    }

    private void computeEffectiveConditionsFromRandomColumnsSplits(List<SplitRecipePayloadParams.ShareSplitDesc> randomColumnsSplits) {
        ExpressionBuilder previousCases = null;
        ExpressionBuilder lastNHex = ef.col(COLUMNS_HASH_LAST_HEX);
        float cumulatedShare = 0.0f;
        for (SplitRecipePayloadParams.ShareSplitDesc split : randomColumnsSplits) {
            assert ((double)cumulatedShare <= 100.0);
            String cumulatedShareInfHex = SplitRecipeService.shareToHexString(cumulatedShare);
            String cumulatedShareSupHex = SplitRecipeService.shareToHexString(cumulatedShare + split.share.floatValue());
            ExpressionBuilder condition = ef.and(lastNHex.lt(cumulatedShareSupHex), lastNHex.gte(cumulatedShareInfHex));
            if (StringUtils.isNotBlank((String)split.outputDatasetFullName)) {
                String id = DatasetLocUtils.resolveSmart(this.projectKey, split.outputDatasetFullName).getFullName();
                this.addCondition(id, condition);
            }
            previousCases = this.nullProofOr(previousCases, condition);
            cumulatedShare += split.share.floatValue();
        }
        this.computeDefaultConditionByNegatingAllPreviousCases(previousCases);
    }

    private void computeRandomOutputs(List<SplitRecipePayloadParams.ShareSplitDesc> randomSplits) {
        float cumulatedShare = 0.0f;
        for (SplitRecipePayloadParams.ShareSplitDesc split : randomSplits) {
            assert (cumulatedShare <= 100.0f);
            cumulatedShare += split.share.floatValue();
            if (!StringUtils.isNotBlank((String)split.outputDatasetFullName)) continue;
            String id = DatasetLocUtils.resolveSmart(this.projectKey, split.outputDatasetFullName).getFullName();
            this.addRandomOutput(id, split.share);
        }
        if (StringUtils.isNotBlank((String)this.params.defaultOutputDataset) && cumulatedShare < 100.0f) {
            String id = DatasetLocUtils.resolveSmart(this.projectKey, this.params.defaultOutputDataset).getFullName();
            this.addRandomOutput(id, Float.valueOf(100.0f - cumulatedShare));
        }
    }

    private void addRandomOutput(String id, Float share) {
        Float currentShare = this.randomOutputs.get(id);
        this.randomOutputs.put(id, Float.valueOf(currentShare == null ? share.floatValue() : currentShare.floatValue() + share.floatValue()));
    }

    private void computeDefaultConditionByNegatingAllPreviousCases(ExpressionBuilder previousCases) {
        if (previousCases == null) {
            throw ErrorContext.iae((String)"'default' cannot be the only output for Split recipe");
        }
        if (StringUtils.isNotBlank((String)this.params.defaultOutputDataset)) {
            String id = DatasetLocUtils.resolveSmart(this.projectKey, this.params.defaultOutputDataset).getFullName();
            this.addCondition(id, previousCases.not());
        }
    }

    private int getMaxLength(String column) {
        SchemaColumn columnSchema = this.inputAndComputedColumnsSchema.getColumn(column);
        int maxLength = columnSchema == null ? 255 : columnSchema.maxLength;
        return maxLength == -1 ? 255 : maxLength;
    }

    private ExpressionBuilder nullProofOr(ExpressionBuilder a, ExpressionBuilder b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.or(b);
    }

    private void addCondition(String id, ExpressionBuilder condition) {
        ExpressionBuilder ec = this.nullProofOr(this.effectiveConditions.get(id), condition);
        this.effectiveConditions.put(id, ec);
    }

    public Map<String, String> generateSqlForAllSplits(SQLDialect dialect) throws Exception {
        HashMap<String, String> sqlQueries = new HashMap<String, String>();
        for (String outputDatasetFullId : this.effectiveConditions.keySet()) {
            sqlQueries.put(outputDatasetFullId, this.generateSql(dialect, outputDatasetFullId));
        }
        return sqlQueries;
    }

    protected String generateSql(SQLDialect dialect, String outputFullName) throws Exception {
        return this.generateSql(dialect, outputFullName, true);
    }

    protected String generateSql(SQLDialect dialect, String outputFullName, boolean withPartitioning) throws Exception {
        SelectQueryBuilder query = this.prepareQuery(dialect, withPartitioning, outputFullName);
        ExpressionBuilder whereClause = this.effectiveConditions.get(outputFullName);
        query.where(whereClause);
        FlowDataset outputFDS = this.activity.getSubgraph().getTargetDataset(outputFullName);
        Dataset outputDS = outputFDS.getMandatoryUnsafe(this.datasetsDAO);
        query = QueryGenerationUtils.applyInsertIntoCasts(query, dialect, outputDS);
        return query.toSQL(dialect);
    }

    protected String generateSqlForHive(SQLDialect dialect) throws Exception {
        return this.generateSqlForHive(dialect, true);
    }

    protected String generateSqlForHive(SQLDialect dialect, boolean withPartitioning) throws Exception {
        ExpressionBuilder randCol = ef.col(RAND_VAR_ALIAS);
        Float cumulatedShare = Float.valueOf(0.0f);
        HashMap partitionColumns = Maps.newHashMap();
        HashSet columnsToRemove = Sets.newHashSet();
        String mainQuery = this.generateMainQueryForHive(dialect, withPartitioning);
        StringBuilder fullQueryBuilder = new StringBuilder();
        fullQueryBuilder.append("FROM (" + mainQuery + ") `__dku_main_query` \n");
        if (this.params.mode != SplitRecipePayloadParams.Mode.RANDOM) {
            for (Map.Entry<String, ExpressionBuilder> effectiveCondition : this.effectiveConditions.entrySet()) {
                String outputFullName = effectiveCondition.getKey();
                if (withPartitioning) {
                    this.setPartitioning(partitionColumns, columnsToRemove, outputFullName);
                }
                String insertOverwriteStatement = this.getInsertOverwriteStatement(withPartitioning, outputFullName);
                fullQueryBuilder.append("\n" + insertOverwriteStatement + " ");
                SelectQueryBuilder splitQuery = new SelectQueryBuilder();
                this.selectOutputSchemaWithLowerCase(splitQuery, partitionColumns, columnsToRemove, dialect);
                splitQuery.where(effectiveCondition.getValue());
                fullQueryBuilder.append(splitQuery.toSQL(dialect));
            }
        } else {
            for (Map.Entry<String, Float> randomOutput : this.randomOutputs.entrySet()) {
                String outputFullName = randomOutput.getKey();
                if (withPartitioning) {
                    this.setPartitioning(partitionColumns, columnsToRemove, outputFullName);
                }
                String insertOverwriteStatement = this.getInsertOverwriteStatement(withPartitioning, outputFullName);
                fullQueryBuilder.append("\n" + insertOverwriteStatement + " ");
                SelectQueryBuilder splitQuery = new SelectQueryBuilder();
                this.selectOutputSchemaWithLowerCase(splitQuery, partitionColumns, columnsToRemove, dialect);
                Float currentShare = randomOutput.getValue();
                ExpressionBuilder condition = ef.and(randCol.gt(Float.valueOf(cumulatedShare.floatValue() / 100.0f)), randCol.lte(Float.valueOf((cumulatedShare.floatValue() + currentShare.floatValue()) / 100.0f)));
                cumulatedShare = Float.valueOf(cumulatedShare.floatValue() + currentShare.floatValue());
                splitQuery.where(condition);
                fullQueryBuilder.append(splitQuery.toSQL(dialect));
            }
        }
        return fullQueryBuilder.toString();
    }

    private String getInsertOverwriteStatement(boolean withPartitioning, String outputFullName) throws IOException {
        Partition outputPartition;
        AnyLoc loc = AnyLoc.resolveFull(outputFullName);
        Dataset outputDS = Dataset.fromSerialized((SerializedDataset)this.datasetsDAO.getMandatory(loc));
        PartitioningScheme outputPartitionScheme = null;
        if (withPartitioning && (outputPartition = this.activity.getSubgraph().getTargetPartitions().get(outputFullName)) != null && !outputPartition.isNP() && !outputPartition.isAll() && outputDS.getPartitioningSchema().isPartitioned()) {
            outputPartitionScheme = outputDS.getPartitioningSchema();
        }
        boolean prefixWithDb = !this.params.engineParams.hive.executionEngine.equals((Object)HiveRecipeMeta.HiveExecutionEngine.HIVECLI_LOCAL);
        return HiveQLQueryRecipeUtils.insertOverwriteFragment(outputDS, outputPartitionScheme, Output.WriteMode.OVERWRITE, prefixWithDb);
    }

    protected String generateMainQueryForHive(SQLDialect dialect, boolean withPartitioning) throws Exception {
        SelectQueryBuilder enrichInputDataset = this.enrichInputDatasetOrTable(dialect, withPartitioning);
        if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM) {
            enrichInputDataset.select(ef.op(QueryUtils.OperatorType.RAND, this.params.seed), RAND_VAR_ALIAS);
        }
        return enrichInputDataset.toSQL(dialect);
    }

    protected String generateSqlForCentileForMysql(SQLDialect dialect, String outputFullName) throws Exception {
        return this.generateSqlForCentileForMysql(dialect, outputFullName, true);
    }

    protected String generateSqlForCentileForMysql(SQLDialect dialect, String outputFullName, boolean withPartitioning) throws Exception {
        SelectQueryBuilder query = this.prepareQuery(dialect, withPartitioning, outputFullName);
        for (int i = 0; i < this.centileOrderExpressions.size(); ++i) {
            ExpressionBuilder oe = this.centileOrderExpressions.get(i);
            QueryAst.OrderType ot = this.centileOrderTypes.get(i);
            query.order(oe, ot);
        }
        SizeAndOffset sizeAndOffset = this.centileOutputs.get(outputFullName);
        String sqlQuery = dialect.getLimitedQuery(query.toSQL(dialect), sizeAndOffset.size, sizeAndOffset.offset);
        return sqlQuery;
    }

    protected SelectQueryBuilder prepareQuery(SQLDialect dialect, boolean withPartitioning, String outputFullName) throws IOException {
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDS, dialect, this.params.engineParams);
        SelectQueryBuilder query = new SelectQueryBuilder();
        HashMap partitionColumns = Maps.newHashMap();
        HashSet columnsToRemove = Sets.newHashSet();
        if (withPartitioning) {
            this.setPartitioning(dialect);
            this.setPartitioning(partitionColumns, columnsToRemove, outputFullName);
        }
        this.selectOutputSchemaWithLowerCase(query, partitionColumns, columnsToRemove, dialect);
        SelectQueryBuilder enrichedInputDS = this.enrichInputDataset(dialect, table, withPartitioning);
        this.fromSubqueryOrTable(query, enrichedInputDS, table, SPLIT_ENRICHED_INPUT_ALIAS);
        for (Map.Entry partitionColumn : partitionColumns.entrySet()) {
            query.select(ef.dstPartitionId(new SchemaColumn((String)partitionColumn.getKey(), Type.STRING), (Dimension)partitionColumn.getValue()), (String)partitionColumn.getKey());
        }
        if (this.params.mode == SplitRecipePayloadParams.Mode.CENTILE && this.shouldCommentCentileQuery) {
            query.comment(CENTILE_QUERY_COMMENT);
        }
        return query;
    }

    private void selectOutputSchemaWithLowerCase(SelectQueryBuilder query, Map<String, Dimension> partitionColumns, Set<String> columnsToRemove, SQLDialect dialect) {
        for (SchemaColumn sc : this.baseOutputSchema.columns) {
            String name = sc.getName();
            if (columnsToRemove.contains(name)) continue;
            if (partitionColumns.containsKey(name)) {
                query.select(ef.dstPartitionId(sc, partitionColumns.get(name)), name);
                partitionColumns.remove(name);
                continue;
            }
            if (this.lowerCaseColumns && !name.equals(name.toLowerCase())) {
                query.select(ef.col(name), name.toLowerCase());
                continue;
            }
            query.select(ef.col(name), name);
        }
    }

    protected SelectQueryBuilder enrichInputDatasetOrTable(SQLDialect dialect, boolean withPartitioning) throws IOException {
        SelectQueryBuilder enrichedInputDS;
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(this.inputDS, dialect, this.params.engineParams);
        if (withPartitioning) {
            this.setPartitioning(dialect);
        }
        if ((enrichedInputDS = this.enrichInputDataset(dialect, table, withPartitioning)) != null) {
            return enrichedInputDS;
        }
        SelectQueryBuilder query = new SelectQueryBuilder();
        for (SchemaColumn sc : this.baseOutputSchema.columns) {
            query.select(ExpressionUtils.getAdjustedColumn(ef.col(sc.getName()), sc, this.inputDS, dialect), sc.getName());
        }
        query.from(table, SPLIT_ROW_TABLE_ALIAS);
        return query;
    }

    protected SelectQueryBuilder enrichInputDataset(SQLDialect dialect, SQLUtils.SQLTable table, boolean withPartitioning) {
        SelectQueryBuilder subquery = null;
        boolean needCast = this.baseOutputSchema.columns.stream().anyMatch(col -> ExpressionUtils.columnNeedsAdjustment(col, this.inputDS.getParams(), this.inputDS.isManaged(), dialect));
        if (this.params.hasPrefilter() || this.sourcePartitionScheme != null || needCast) {
            subquery = this.buildPreFiltersAndPartitionQuery(table, this.params.preFilter, dialect, withPartitioning);
        }
        if (this.params.hasComputedColumns()) {
            boolean caseInsensitive = dialect.hasCaseInsensitiveColumns();
            subquery = this.buildComputedColumnsQuery(subquery, table, this.params.computedColumns, dialect, this.inputDS.getSchema(), caseInsensitive);
        }
        if (this.params.mode == SplitRecipePayloadParams.Mode.RANDOM_COLUMNS) {
            subquery = this.buildQueryWithLastNHex(subquery, table, this.baseOutputSchema, dialect);
        }
        if (this.params.mode == SplitRecipePayloadParams.Mode.CENTILE) {
            if (dialect.canSQL99()) {
                subquery = this.buildQueryWithRowNumber(subquery, table, this.baseOutputSchema, dialect);
            } else if (!(dialect instanceof MySQLDialect)) {
                throw ErrorContext.iae((String)"Centile split recipe has not been implemented yet for this engine");
            }
        }
        return subquery;
    }

    protected SelectQueryBuilder buildComputedColumnsQuery(SelectQueryBuilder subquery, SQLUtils.SQLTable table, List<ComputedColumn> computedColumns, SQLDialect dialect, Schema inputSchema, boolean caseInsensitive) {
        String name;
        SelectQueryBuilder query = new SelectQueryBuilder();
        HashSet<String> usedNames = new HashSet<String>();
        if (this.params.hasComputedColumns()) {
            for (ComputedColumn computedColumn : computedColumns) {
                name = computedColumn.name;
                if (this.containsCaseInsensitive(usedNames, name, caseInsensitive)) {
                    throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INVALID_COMPUTED_COLUMNS, "Conflict in computed columns. The computed column named \"" + name + "\" already exists.");
                }
                ExpressionBuilder expr = QueryGenerationUtils.getComputedColumnExpr(computedColumn, dialect, this.inputAndComputedColumnsSchema);
                query.select(expr, name);
                usedNames.add(name);
            }
        }
        for (SchemaColumn sc : inputSchema.columns) {
            name = sc.getName();
            if (this.containsCaseInsensitive(usedNames, name, caseInsensitive)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INVALID_COMPUTED_COLUMNS, "Conflict between columns and computed columns. The column named \"" + name + "\" already exists.");
            }
            query.select(ef.col(name), sc.getName());
            usedNames.add(name);
        }
        this.fromSubqueryOrTable(query, subquery, table, SPLIT_INNER_QUERY_WITH_COMPUTED_COLUMNS_ALIAS);
        return query;
    }

    private boolean containsCaseInsensitive(Set<String> list, String string, boolean caseInsensitive) {
        if (list == null || list.isEmpty() || string == null) {
            return false;
        }
        if (!caseInsensitive) {
            return list.contains(string);
        }
        for (String element : list) {
            if (!string.equalsIgnoreCase(element)) continue;
            return true;
        }
        return false;
    }

    protected SelectQueryBuilder buildQueryWithLastNHex(SelectQueryBuilder subquery, SQLUtils.SQLTable table, Schema baseOutputSchema, SQLDialect dialect) {
        SelectQueryBuilder query = new SelectQueryBuilder();
        ExpressionBuilder concatColumns = null;
        ArrayList<ExpressionBuilder> concatColumnsList = new ArrayList<ExpressionBuilder>();
        Iterator<String> colIterator = this.params.randomColumns.iterator();
        if (colIterator.hasNext()) {
            String currentColumn = colIterator.next();
            ExpressionBuilder nullCoalesce = ef.cst("__dku_null__").castToString("__dku_null__".length());
            concatColumns = ef.col(currentColumn).castToString(this.getMaxLength(currentColumn)).coalesce(nullCoalesce);
            while (colIterator.hasNext()) {
                currentColumn = colIterator.next();
                concatColumnsList.add(ef.col(currentColumn).castToString(this.getMaxLength(currentColumn)).coalesce(nullCoalesce));
            }
            if (StringUtils.isNotEmpty((String)this.params.randomColumnsSalt)) {
                concatColumnsList.add(ef.cst(this.params.randomColumnsSalt));
            }
            if (!concatColumnsList.isEmpty()) {
                concatColumns = concatColumns.concat(concatColumnsList.toArray());
            }
        }
        ExpressionBuilder hashColumns = ef.op(QueryUtils.OperatorType.MD5, concatColumns);
        ExpressionBuilder lastNHex = ef.op(QueryUtils.OperatorType.SUBSTR, hashColumns, hashColumns.length().minus(3), 4);
        query.select(lastNHex, COLUMNS_HASH_LAST_HEX);
        for (SchemaColumn sc : baseOutputSchema.columns) {
            query.select(ef.col(sc.getName()), sc.getName());
        }
        this.fromSubqueryOrTable(query, subquery, table, SPLIT_QUERY_WITH_HASH_LAST_HEX);
        return query;
    }

    private SelectQueryBuilder buildQueryWithRowNumber(SelectQueryBuilder subquery, SQLUtils.SQLTable table, Schema baseOutputSchema, SQLDialect dialect) {
        SelectQueryBuilder query = new SelectQueryBuilder();
        QueryAst.Window window = SelectQueryBuilder.window(null, this.centileOrderExpressions, this.centileOrderTypes);
        ExpressionBuilder rowNumber = ef.rowNumber().over(window);
        query.select(rowNumber, ROW_NUMBER_ALIAS);
        for (SchemaColumn sc : baseOutputSchema.columns) {
            query.select(ef.col(sc.getName()), sc.getName());
        }
        this.fromSubqueryOrTable(query, subquery, table, SPLIT_INNER_QUERY_WITH_ROW_NUMBER_ALIAS);
        return query;
    }

    private void setCentileOrders(List<SplitRecipePayloadParams.Order> centileOrders) {
        for (SplitRecipePayloadParams.Order order : centileOrders) {
            ExpressionBuilder col = ef.col(order.column);
            this.centileOrderExpressions.add(col);
            this.centileOrderTypes.add(order.desc ? QueryAst.OrderType.DESC : QueryAst.OrderType.ASC);
        }
    }

    protected SelectQueryBuilder buildPreFiltersAndPartitionQuery(SQLUtils.SQLTable table, FilterDesc preFilter, SQLDialect dialect, boolean withPartitioning) {
        SelectQueryBuilder query = new SelectQueryBuilder();
        for (SchemaColumn sc : this.inputDS.getSchema().columns) {
            query.select(ExpressionUtils.getAdjustedColumn(ef.col(sc.getName()), sc, this.inputDS, dialect), sc.getName());
        }
        if (this.params.hasPrefilter()) {
            QueryGenerationUtils.preFilter(query, preFilter, dialect, this.inputDS, false);
        }
        if (this.sourcePartitionScheme != null && withPartitioning && table.isTrueTable()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.inputDS, this.sourcePartitions, dialect);
            query.where(partitionFilterExpression);
        }
        query.from(table, SPLIT_INNER_QUERY_WITH_PREFILTERS_AND_PARTITIONS_ALIAS);
        return query;
    }

    protected void fromSubqueryOrTable(SelectQueryBuilder query, SelectQueryBuilder subquery, SQLUtils.SQLTable table, String alias) {
        if (subquery == null) {
            query.from(table, alias);
        } else {
            query.from(subquery, alias);
        }
    }

    private void setPartitioning(SQLDialect dialect) {
        List<Partition> parts;
        if (MultiEngineRecipeRunner.shouldSpecifySourcePartitionInWhereClause(dialect, this.params.engineParams) && (parts = this.activity.getSubgraph().getSourcePartitions(this.activity.getSubgraph().getSingleSourceDataset())) != null && parts.size() > 0 && !parts.get(0).isAll() && !parts.get(0).isNP() && this.inputDS.getPartitioningSchema().isPartitioned()) {
            this.sourcePartitions = parts;
            this.sourcePartitionScheme = this.inputDS.getPartitioningSchema();
        }
    }

    private void setPartitioning(Map<String, Dimension> partitionColumns, Set<String> columnsToRemove, String outputFullName) throws IOException {
        FlowDataset outputFDS = this.activity.getSubgraph().getTargetDataset(outputFullName);
        Dataset outputDS = outputFDS.getMandatoryUnsafe(this.datasetsDAO);
        PartitioningScheme partitioningScheme = outputDS.getPartitioningSchema();
        if (partitioningScheme != null && partitioningScheme.isPartitioned()) {
            if (DatasetInspector.arePartitioningColumnsMandatoryInSchema(outputDS)) {
                for (String dim : partitioningScheme.getDimensionNames()) {
                    partitionColumns.put(dim, partitioningScheme.getDimension(dim));
                }
            } else {
                columnsToRemove.addAll(partitioningScheme.getDimensionNames());
            }
        }
    }

    static class SizeAndOffset {
        Long size;
        Long offset;

        SizeAndOffset(Long size, Long offset) {
            this.size = size;
            this.offset = offset;
        }
    }
}

