/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.window;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.RecipeEnginesPreferenceConfig;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.VisualSQLRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.computedcolumn.ComputedColumn;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetUtils;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.queries.ExecutionPlanService;
import com.dataiku.dip.recipes.common.RecipeConfigUtils;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.VisualSQLRecipeStatusComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipeStatus;
import com.dataiku.dip.recipes.visualsql.VisualSQLRecipesBaseService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.WindowRecipeService;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class WindowRecipeStatusComputer
extends VisualSQLRecipeStatusComputer {
    @Autowired
    private WindowRecipeService service;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.window.status");

    public WindowRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public WindowRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws Exception {
        return this.fastStatusIgnorePartitions(new StatusInitializer(), true, authCtx);
    }

    private WindowRecipeStatus getEngineIndependentBaseStatus(AuthCtx authCtx, StatusInitializer init) {
        WindowRecipePayloadParams params;
        WindowRecipeStatus status = new WindowRecipeStatus();
        try {
            init.activity = new JobActivity(this.recipesValidationService.getSampleSubgraph(new FlowRecipe(this.recipe)));
            params = this.service.loadParams(this.payload, this.recipe);
            assert (params != null);
            status.params = params;
            status.engineParams = params.engineParams;
            init.inputDS = init.activity.getSubgraph().getSingleSourceDataset().getMandatoryUnsafe(this.datasetsDAO);
            init.outputDS = init.activity.getSubgraph().getSingleTargetDataset().getMandatoryUnsafe(this.datasetsDAO);
            this.recipesValidationService.checkComplianceWithRecipeDesc(authCtx, this.recipe);
            this.recipesValidationService.checkTargetsAreWritable(init.activity);
        }
        catch (Exception e) {
            logger.error((Object)"Invalid recipe", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        this.checkWindowsAndAggregations(status, params, init.inputDS.getSchema());
        this.checkOutputSchema(status, params, false);
        return status;
    }

    public WindowRecipeStatus fastStatusIgnorePartitions(StatusInitializer init, boolean reportUnknownErrorsToStatus, AuthCtx authCtx) {
        WindowRecipePayloadParams params;
        WindowRecipeStatus status;
        block13: {
            RecipeEnginesPreferenceConfig repc;
            block12: {
                status = this.getEngineIndependentBaseStatus(authCtx, init);
                params = status.params;
                repc = new RecipeConfigUtils().getResolvedPreferenceConfig(this.recipe.projectKey, this.recipe.type, params.enginesPreferences);
                try {
                    this.performBasicStructureChecks(status, authCtx);
                    this.visualRecipesService.initEngines(authCtx, init.activity, status, this.recipe.projectKey);
                    this.performBasicCDEChecks(status, authCtx);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Compute windows in-database, then streaming of rows");
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    if (status.isInvalid()) break block12;
                    status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                }
            }
            if (!status.isInvalid()) {
                try {
                    this.makeRecipeSpecificEnginesStatus(authCtx, init, status, params);
                    this.visualRecipesService.selectEngine(authCtx, init.activity, params.engineType, status, this.recipe.type, repc);
                    this.visualRecipesService.adjustEngineStatus(authCtx, init.activity, status, "Compute windows in-database, then streaming of rows");
                    if (status.selectedEngine == null && !status.isInvalid()) {
                        status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No engine selected");
                        return status;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to init engine", (Throwable)e);
                    status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    return status;
                }
                if (status.getSelectedSQLBasedEngine().queryBased) {
                    try {
                        init.dialect = this.visualRecipesService.getDialect(authCtx, init.activity, status.getSelectedSQLBasedEngine());
                        status.sql = this.service.generateSQLIgnorePartitions(init.dialect, params, init.inputDS, init.outputDS, true);
                    }
                    catch (Exception e) {
                        logger.info((Object)"Failed to generate SQL", (Throwable)e);
                        init.error = e.getMessage();
                        if (!reportUnknownErrorsToStatus) break block13;
                        status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
                    }
                }
            }
        }
        if (!status.isInvalid() && params.preFilter != null && params.preFilter.enabled) {
            status.preFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.preFilter, init.inputDS, init.dialect, status.preFilter, false);
        }
        if (!status.isInvalid() && params.computedColumns != null && !params.computedColumns.isEmpty()) {
            status.computedColumns = new RecipeStatus.StepStatus();
            boolean mustLowercaseColumns = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, status.getSelectedSQLBasedEngine());
            this.visualRecipesService.checkComputedColumns(params.computedColumns, init.inputDS.getSchema(), status.getSelectedSQLBasedEngine(), init.dialect, mustLowercaseColumns, status.computedColumns);
        }
        if (params.postFilter != null && params.postFilter.enabled) {
            status.postFilter = new RecipeStatus.StepStatus();
            this.visualRecipesService.checkFilter(params.postFilter, null, init.dialect, status.postFilter, false);
        }
        return status;
    }

    private void fixupStatusOutputInvalid(VisualSQLRecipeStatus status) {
        if (status.isInvalid() && !status.output.anyFatal()) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, "Failed to validate all recipe steps");
        }
    }

    @Override
    public WindowRecipeStatus getStatusForConversion_NT(AuthCtx authCtx) throws Exception {
        WindowRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, true, authCtx);
            if (status.isInvalid()) {
                logger.warn((Object)"Recipe status is invalid. Try to generate query anyway:");
            }
            status.sql = this.service.generateSQL(init.activity, init.dialect, status.params, true);
        }
        return status;
    }

    @Override
    public WindowRecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) {
        boolean lowerCaseColumnsNames;
        WindowRecipeStatus status;
        StatusInitializer init = new StatusInitializer();
        try (Transaction t = this.transactionService.beginRead();){
            status = this.fastStatusIgnorePartitions(init, false, authCtx);
            this.fixupStatusOutputInvalid(status);
        }
        if (status.isInvalid()) {
            return status;
        }
        WindowRecipePayloadParams params = status.params;
        VisualSQLRecipesBaseService.SQLBasedEngineStatus selectedEngine = status.getSelectedSQLBasedEngine();
        if (selectedEngine == null) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "No available engine can run this recipe");
            return status;
        }
        VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest request = (VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest)JSON.parse((String)requestData, VisualSQLRecipeStatus.VisualSQLRecipeStatusRequest.class);
        if (request != null && !request.exactPlan) {
            this.visualRecipesService.enableSimplifiedExplainPlan(status.getSelectedSQLBasedEngine(), params);
        }
        Dataset inputDS = init.inputDS;
        SQLDialect dialect = init.dialect;
        String preFilterSQLExpression = null;
        if (params.preFilter != null && (params.preFilter.enabled || params.preFilter.distinct)) {
            status.preFilter = new RecipeStatus.StepStatus();
            preFilterSQLExpression = this.visualRecipesService.checkFilter(params.preFilter, inputDS, dialect, status.preFilter, selectedEngine.queryBased);
        }
        try {
            lowerCaseColumnsNames = this.visualRecipesService.mustLowerCaseColumnsNames((VisualSQLRecipePayloadParams)params, selectedEngine);
            status.outputSchemaBeforeOverride = this.service.getOutputSchemaBeforeOverride(inputDS, params, lowerCaseColumnsNames, dialect);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to compute output schema", (Throwable)e);
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to compute output schema: " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            return status;
        }
        String postFilterSQLExpression = null;
        if (status.outputSchemaBeforeOverride != null && params.postFilter != null && (params.postFilter.enabled || params.postFilter.distinct)) {
            status.postFilter = new RecipeStatus.StepStatus();
            postFilterSQLExpression = this.visualRecipesService.checkFilter(params.postFilter, new Dataset().withSchema(status.outputSchemaBeforeOverride), dialect, status.postFilter, selectedEngine.queryBased);
        }
        this.checkOutputSchema(status, params, lowerCaseColumnsNames);
        if (this.needToComputeExecutionPlan(selectedEngine, status, request)) {
            boolean executionPlanFailed = false;
            String executionPlanErrMsg = null;
            try {
                status.executionPlan = this.getExecutionPlan(authCtx, inputDS, selectedEngine, status.sql, params.engineParams);
            }
            catch (ExecutionPlanService.HiveTableNotFound e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, "Table not found in Hive global metastore. " + ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            catch (Exception e) {
                logger.error((Object)"Failed to compute execution plan", (Throwable)e);
                logger.info((Object)("Query:\n" + status.sql));
                executionPlanFailed = true;
                executionPlanErrMsg = e.getMessage();
                status.output.withWarning(RecipeCodes.ERR_RECIPE_EXECUTION_PLAN_COMPUTATION_FAILED, ExceptionUtils.getMessageWithCauses((Throwable)e));
            }
            if (executionPlanFailed) {
                try {
                    this.investigateExecutionPlanFailure(status, init, executionPlanErrMsg, authCtx, preFilterSQLExpression, postFilterSQLExpression);
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to determe error cause", (Throwable)e);
                }
            }
        }
        if (!selectedEngine.queryBased && params.values != null && params.values.size() > 0 && status.customValues != null) {
            status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_CUSTOM_AGGR, (String)"The selected engine cannot handle custom aggregations").withPos(0, 0));
        }
        if (init.error != null && !status.isInvalid()) {
            status.output = new RecipeStatus.StepStatus();
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, init.error);
        }
        this.fixupStatusOutputInvalid(status);
        return status;
    }

    private void makeRecipeSpecificEnginesStatus(AuthCtx authCtx, StatusInitializer init, WindowRecipeStatus status, WindowRecipePayloadParams params) throws Exception {
        for (VisualSQLRecipesBaseService.SQLBasedEngineStatus engine : status.getEngines()) {
            if (!engine.isSelectable) continue;
            if (!engine.canDistinctSelect) {
                if (params.preFilter != null && params.preFilter.distinct) {
                    RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in pre-filter", engine);
                    continue;
                }
                if (params.postFilter != null && params.postFilter.distinct) {
                    RecipeEngineStatus.setErrorStatus("Cannot use DISTINCT in post-filter", engine);
                    continue;
                }
            }
            if (!engine.queryBased) continue;
            if (!engine.canAnalyticalFunctions) {
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: window functions not available", engine);
                continue;
            }
            try {
                SQLDialect dialect = this.visualRecipesService.getDialect(authCtx, init.activity, engine);
                this.service.generateSQLIgnorePartitions(dialect, status.params, init.inputDS, init.outputDS, false);
            }
            catch (Exception e) {
                if (engine.type.equals("DSS")) {
                    RecipeEngineStatus.setErrorStatus("Recipe configuration is not supported: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
                    continue;
                }
                RecipeEngineStatus.setErrorStatus("Recipe cannot be translated to SQL: " + ExceptionUtils.getMessageWithCauses((Throwable)e), engine);
            }
        }
    }

    private void checkOutputSchema(WindowRecipeStatus status, WindowRecipePayloadParams params, boolean lowerCaseColumnsNames) {
        if (status.outputSchemaBeforeOverride != null) {
            status.outputSchema = new Schema(status.outputSchemaBeforeOverride);
            if (params.outputColumnNameOverrides != null) {
                HashSet<String> usedNames = new HashSet<String>();
                for (SchemaColumn sc : status.outputSchema.columns) {
                    String colName = sc.getName();
                    String overrideName = params.outputColumnNameOverrides.get(sc.getName());
                    if (StringUtils.isNotBlank((String)overrideName)) {
                        colName = overrideName;
                        if (lowerCaseColumnsNames) {
                            overrideName = overrideName.toLowerCase();
                        }
                        sc.setName(overrideName);
                    }
                    if (StringUtils.isNotBlank((String)(colName = colName.toLowerCase())) && usedNames.contains(colName)) {
                        status.output.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_DUPLICATE_OUTPUT, "Duplicate name: '" + colName + "'");
                    }
                    usedNames.add(colName);
                }
            }
            if (status.outputSchema.columns.size() == 0) {
                status.output.withFatal(RecipeCodes.ERR_RECIPE_EMPTY_OUTPUT_SCHEMA, "Empty output schema");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkWindowsAndAggregations(WindowRecipeStatus status, WindowRecipePayloadParams params, Schema inputSchema) {
        status.windows = new RecipeStatus.StepStatus();
        status.values = new RecipeStatus.StepStatus();
        Schema inputSchemaWithComputed = (Schema)JSON.deepCopy((Object)inputSchema);
        for (ComputedColumn computedColumn : params.computedColumns) {
            inputSchemaWithComputed.addColumn(computedColumn.name, Type.forName((String)computedColumn.type));
        }
        if (params.windows == null || params.windows.size() == 0) {
            status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "No window defined.");
        } else {
            for (WindowRecipePayloadParams.WindowDesc windowDesc : params.windows) {
                if (!windowDesc.enableLimits) continue;
                if (windowDesc.orders == null || windowDesc.orders.size() == 0) {
                    status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "Window frame requires the window to be ordered");
                } else if (windowDesc.windowLimitMode == WindowRecipePayloadParams.WindowLimitMode.RANGE) {
                    if (windowDesc.orders.size() != 1) {
                        status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "Value range mode requires the windows to be ordered by exactly one column");
                    } else {
                        String orderColumnName = windowDesc.orders.get((int)0).column;
                        if (StringUtils.isBlank((String)orderColumnName)) {
                            status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "Empty order columns");
                        } else {
                            SchemaColumn orderColumn = inputSchemaWithComputed.getColumn(orderColumnName);
                            if (orderColumn == null) {
                                status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "Column '" + orderColumnName + "' is not in input dataset schema.");
                            } else if (!orderColumn.getType().isNumeric() && !orderColumn.getType().isTemporal()) {
                                status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "In value range mode, order column should be a number or a date. \nColumn '" + orderColumnName + "' is of type " + String.valueOf(orderColumn.getType()));
                            }
                        }
                    }
                }
                if (windowDesc.windowLimitMode != WindowRecipePayloadParams.WindowLimitMode.ROWS || !windowDesc.limitPreceding || !windowDesc.limitFollowing || windowDesc.precedingRows + windowDesc.followingRows >= 0) continue;
                status.windows.withFatal(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_WINDOWS, "When limiting the window frame on both preceding rows and following rows, the limits must allow at least one row to be in the window");
            }
        }
        if (params.hasOrderedAggregations()) {
            status.aggregationsRequireOrder = true;
            if (params.hasUnorderedWindow()) {
                status.windows.withWarning(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_AGGR, "Selected aggregations require ordering but some windows are not ordered.");
            }
        }
        if (params.hasNonTrivialAggregation()) {
            try {
                params.getNtileValues();
            }
            catch (Exception e) {
                logger.error((Object)"Failed to parse Ntile values", (Throwable)e);
                status.values.withFatalV(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_AGGR, "Ntile values must be comma-separated positive integers: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            }
            if (params.values != null && params.values.size() > 0) {
                boolean bl;
                void var6_12;
                HashSet<String> usedNames = new HashSet<String>();
                for (WindowRecipePayloadParams.WindowValue val : params.values) {
                    if (val.column == null || !val.hasAnyAggr(false)) continue;
                    usedNames.add(val.column);
                }
                boolean bl2 = false;
                while (var6_12 < params.values.size()) {
                    WindowRecipePayloadParams.WindowValue val;
                    val = params.values.get((int)var6_12);
                    if (val.column == null) {
                        if (status.customValues == null) {
                            status.customValues = new RecipeStatus.StepStatus();
                        }
                        if (StringUtils.isBlank((String)val.customName)) {
                            status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_CUSTOM_AGGR, (String)"Empty name").withPos((int)var6_12, 0));
                        } else if (usedNames.contains(val.customName)) {
                            status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_CUSTOM_AGGR, (String)"Duplicate name").withPos((int)var6_12, 0));
                        }
                        usedNames.add(val.customName);
                    }
                    ++var6_12;
                }
                for (WindowRecipePayloadParams.WindowValue val : params.values) {
                    try {
                        if (val.lead) {
                            val.getLeadValues();
                        }
                        if (!val.lag) continue;
                        val.getLagValues();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to parse Lead/lad values", (Throwable)e);
                        status.values.withFatalV(RecipeCodes.ERR_RECIPE_WINDOW_INVALID_AGGR, "Lead/Lag values must be comma-separated positive integers: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
                boolean bl3 = false;
                for (WindowRecipePayloadParams.WindowValue val : params.values) {
                    if (!val.min && !val.max || !StringUtils.isNotBlank((String)val.column) || inputSchemaWithComputed.getColumn(val.column) == null || inputSchemaWithComputed.getColumn(val.column).getType() != Type.STRING) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    status.values.withWarning(RecipeCodes.WARN_RECIPE_WINDOW_MIN_MAX, "Min/Max value on 'String' type uses alphabetical order");
                }
            }
        } else {
            status.values.withWarning(RecipeCodes.WARN_RECIPE_WINDOW_NO_AGGREGATION, "You specified no aggregation.");
        }
    }

    private void investigateExecutionPlanFailure(WindowRecipeStatus status, StatusInitializer init, String executionPlanErrMsg, AuthCtx authCtx, String preFilterSQLExpression, String postFilterSQLExpression) throws Exception {
        Schema inputSchema;
        if (status.selectedEngine.type.equals("HIVE")) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
            return;
        }
        boolean errorOriginFound = false;
        ExpressionBuilder.ExpressionBuilderFactory ef = new ExpressionBuilder.ExpressionBuilderFactory();
        SQLUtils.SQLTable table = DatasetUtils.getResolvedTableWithSparkSQLFallback(init.inputDS, init.dialect, status.params.engineParams);
        WindowRecipePayloadParams params = status.params;
        SQLDialect dialect = init.dialect;
        Dataset inputDS = init.inputDS;
        Dataset outputDS = init.outputDS;
        if (params.values != null && params.values.size() > 0 && (inputSchema = init.inputDS.getSchema()) != null && inputSchema.columns.size() > 0) {
            for (int i = 0; i < params.values.size(); ++i) {
                WindowRecipePayloadParams.WindowValue value = params.values.get(i);
                if (value.column != null) continue;
                if (StringUtils.isBlank((String)value.customName)) {
                    status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_CUSTOM_AGGR, (String)"Empty name").withPos(i, 0));
                    continue;
                }
                if (StringUtils.isBlank((String)value.customExpr)) {
                    status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_CUSTOM_AGGR, (String)"Empty expression").withPos(i, 0));
                    continue;
                }
                String sql = null;
                try {
                    SelectQueryBuilder qb = new SelectQueryBuilder();
                    qb.select(ef.expr(value.customExpr, "$window", new QueryAst.Window()));
                    qb.from(table, null);
                    sql = qb.toSQL(init.dialect);
                    logger.info((Object)("Check custom aggregation " + value.customName));
                    logger.info((Object)sql);
                    this.getExecutionPlan(authCtx, init.inputDS, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                    continue;
                }
                catch (Exception e) {
                    logger.info((Object)"window value test failed:");
                    logger.info(sql);
                    status.customValues.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_CUSTOM_AGGR, (String)this.formatDatabaseErrorMsg(e.getMessage(), dialect)).withPos(i, 0));
                    errorOriginFound = true;
                }
            }
        }
        if (preFilterSQLExpression != null) {
            SelectQueryBuilder qb = new SelectQueryBuilder();
            qb.from(table, null);
            qb.where(ef.expr(preFilterSQLExpression));
            String sql = qb.toSQL(dialect);
            try {
                this.getExecutionPlan(authCtx, inputDS, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
            }
            catch (Exception e) {
                logger.error((Object)"Prefilter execution failed", (Throwable)e);
                logger.error((Object)sql);
                status.preFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(e.getMessage(), dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
        }
        if (postFilterSQLExpression != null) {
            try {
                WindowRecipePayloadParams params2 = (WindowRecipePayloadParams)JSON.deepCopy((Object)params);
                params2.postFilter = null;
                String sql = this.service.generateSQLIgnorePartitions(dialect, params2, inputDS, outputDS, false);
                this.getExecutionPlan(authCtx, inputDS, status.getSelectedSQLBasedEngine(), sql, params.engineParams);
                status.postFilter.addMessage(InfoMessage.fatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_WINDOW_INVALID_FILTER, (String)this.formatDatabaseErrorMsg(executionPlanErrMsg, dialect)).withPos(1, 0));
                errorOriginFound = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!errorOriginFound) {
            status.output.withFatal(RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, executionPlanErrMsg);
        }
    }

    private static class StatusInitializer {
        public Dataset inputDS;
        public Dataset outputDS;
        public SQLDialect dialect;
        public JobActivity activity;
        public String error;

        private StatusInitializer() {
        }
    }

    public static class WindowRecipeStatus
    extends VisualSQLRecipeStatus {
        RecipeStatus.StepStatus inputs;
        RecipeStatus.StepStatus preFilter;
        RecipeStatus.StepStatus computedColumns;
        RecipeStatus.StepStatus windows;
        RecipeStatus.StepStatus values;
        RecipeStatus.StepStatus customValues;
        RecipeStatus.StepStatus postFilter;
        boolean aggregationsRequireOrder;
        WindowRecipePayloadParams params;

        @Override
        public InfoMessage.InfoMessages gatherAllMessages() {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            ret.mergeFrom(this.topLevelMessages);
            if (this.output != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.output);
            }
            if (this.inputs != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.inputs);
            }
            if (this.preFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.preFilter);
            }
            if (this.computedColumns != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.computedColumns);
            }
            if (this.windows != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.windows);
            }
            if (this.values != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.values);
            }
            if (this.customValues != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.customValues);
            }
            if (this.postFilter != null) {
                ret.mergeFrom((InfoMessage.InfoMessages)this.postFilter);
            }
            return ret;
        }

        @Override
        public boolean isInvalid() {
            return this.gatherAllMessages().anyFatal();
        }
    }
}

