/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.graph.utils.GraphIds;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SparkConfigView
extends AbstractFlowTool.FlowView {
    private SparkConfigViewState state;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.spark");

    public SparkConfigView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    public AbstractFlowTool.FlowState getFlowState(JsonObject options) throws Exception {
        return this.computeState();
    }

    @Override
    public synchronized SparkConfigViewState computeState() throws Exception {
        this.state = new SparkConfigViewState();
        try (Transaction tr = this.transactionService.beginRead();){
            for (SerializedRecipe sr : this.recipesDAO.listUnsafe(this.projectKey)) {
                FutureProgressState.checkInterrupt();
                String nodeId = GraphIds.forRecipe(sr.name);
                try {
                    String payload = this.recipesDAO.getPayloadOrNull(sr.projectKey, sr.name);
                    if (!this.hasActiveSparkEngine(sr, payload)) continue;
                    RecipeMeta meta = RecipeRegistry.getMeta(sr);
                    SparkOverrideConfig sparkConf = meta.getSparkConf(sr, payload);
                    this.add(nodeId, sparkConf);
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to get recipe settings", (Throwable)e);
                }
            }
        }
        return this.state;
    }

    @Override
    public void setFocus(Collection<String> focused) throws Exception {
        if (this.state == null) {
            this.computeState();
        }
        this.state.focused = focused == null ? new HashSet<String>() : focused;
    }

    protected void add(String nodeId, SparkOverrideConfig sparkConf) {
        this.state.valueByNode.put(nodeId, sparkConf);
    }

    private boolean hasActiveSparkEngine(SerializedRecipe sr, String payload) throws Exception {
        RecipeMeta meta = RecipeRegistry.getMeta(sr);
        if (meta.getCategoryFlags().isSpark) {
            return true;
        }
        RecipeStatusComputer cs2 = meta.buildStatusComputer(sr, payload);
        if (cs2 == null) {
            return false;
        }
        RecipeStatus status = cs2.fastStatusIgnorePartitions(this.authCtx);
        if (status == null) {
            return false;
        }
        return status.selectedEngine.type.equals("SPARK");
    }

    public static class SparkConfigViewState
    implements AbstractFlowTool.FlowState {
        Map<String, SparkOverrideConfig> valueByNode = new HashMap<String, SparkOverrideConfig>();
        public Collection<String> focused = new HashSet<String>();
    }
}

