/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.MainUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class PerJobLoggingAppender
extends AppenderSkeleton {
    private boolean dryRun;

    public PerJobLoggingAppender(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        String helloData;
        String[] s;
        JobContext context = JobContext.getCurrentJobContext();
        if (context == null) {
            return;
        }
        String data = this.layout.format(event);
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            StringBuilder dataBuilder = new StringBuilder(data);
            for (int i = 0; i < s.length; ++i) {
                dataBuilder.append(s[i]);
                dataBuilder.append(Layout.LINE_SEP);
            }
            data = dataBuilder.toString();
        }
        if (DKUApp.getParams().getBoolParam("dku.jobs.produceJobDotLogFile", false)) {
            try {
                File jobFile = FlowJobUtils.jobLogFile(this.dryRun, context.projectKey, context.jobId);
                if (!jobFile.exists()) {
                    for (LoggingEvent helloEvent : MainUtils.getHello((String)"jek")) {
                        helloData = this.layout.format(helloEvent);
                        FileUtils.writeStringToFile((File)jobFile, (String)helloData, (String)"utf8", (boolean)true);
                    }
                }
                FileUtils.writeStringToFile((File)jobFile, (String)data, (String)"utf8", (boolean)true);
            }
            catch (IOException e) {
                System.out.println("Failed to log per-job line: " + e.getMessage());
                e.printStackTrace();
            }
        }
        if (context.activity != null) {
            try {
                File activityFile = DKUFileUtils.getWithin((File)FlowJobUtils.jobFolder(this.dryRun, context.projectKey, context.jobId), (String[])new String[]{context.activity + ".log"});
                if (!activityFile.exists()) {
                    for (LoggingEvent helloEvent : MainUtils.getHello((String)"jek")) {
                        helloData = this.layout.format(helloEvent);
                        FileUtils.writeStringToFile((File)activityFile, (String)helloData, (String)"utf8", (boolean)true);
                    }
                }
                FileUtils.writeStringToFile((File)activityFile, (String)data, (String)"utf8", (boolean)true);
            }
            catch (IOException e) {
                System.out.println("Failed to log per-activity line: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

