/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.jobrunner.status;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.ActivityState;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.SerializedJobActivity;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.warnings.WarningsContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SerializedJobActivityStatus {
    public ActivityType activityType;
    public List<ActivityStatusOutput> statusOutputs = new ArrayList<ActivityStatusOutput>();
    public boolean hasManagedSparkEventLog;
    public List<PipelineRecipe> pipelineRecipes = new ArrayList<PipelineRecipe>();
    public String recipeName;
    public String recipeType;
    public String activityId;
    public SerializedError firstFailure;
    public DetailedActivityState detailedState;
    public String messageCode;
    public String message;
    public long preparingTime = 0L;
    public long waitingTime = 0L;
    public long runningTime = 0L;
    public List<SerializedSourceDS> sources = new ArrayList<SerializedSourceDS>();
    public List<SerializedTargetDS> targets = new ArrayList<SerializedTargetDS>();
    public ActivityState state;
    public int runningManagedThreads;
    public long startTime;
    public long endTime;
    public Long totalTime;
    public int partialExecutionOrder;
    public WarningsContext.SerializedWarnings warnings;
    public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    public SerializedJobActivity def;
    public JobActivity.RecipeRunningThings runningThings;
    public Map<String, String> counters = new HashMap<String, String>();
    public boolean skipExplicitOrWriteProtected = false;

    public void addStatusOutput(String label, String path, String mimeType) {
        ActivityStatusOutput aso = new ActivityStatusOutput();
        aso.label = label;
        aso.path = path;
        aso.mimeType = mimeType;
        this.statusOutputs.add(aso);
    }

    public void addStatutOutput(String label, File f, String mimeType) throws IOException {
        ActivityStatusOutput aso = new ActivityStatusOutput();
        aso.label = label;
        aso.path = FlowJobUtils.pathRelativeToActivity(f);
        aso.mimeType = mimeType;
        this.statusOutputs.add(aso);
    }

    public int getWarningsTotalCount() {
        return this.warnings != null ? this.warnings.totalCount : 0;
    }

    public static class ActivityStatusOutput {
        public String label;
        public String path;
        public String mimeType;
    }

    public static enum DetailedActivityState {
        PREPARING,
        ACTIVE,
        WAITING_RESOURCES;

    }

    public static class PipelineRecipe {
        public String activityId;
        public String recipeName;
        public String outputPartition;
        public String recipeType;
    }

    public static enum ActivityType {
        RECIPE,
        SPARK_PIPELINE,
        SQL_PIPELINE;

    }

    public static class SerializedTargetDS {
        public FlowComputable.FCType type;
        public String id;
        public TargetPartitionStats partition;
        public String modelVersionId;
        public String evaluationId;
        public String label;
    }

    public static class TargetPartitionStats {
        public String id;
        public long writtenBytes = -1L;
        public long writtenRecords = -1L;
        public int writtenFiles = -1;
    }

    public static class SerializedSourceDS {
        public FlowComputable.FCType type;
        public String id;
        public SourceStatsType statsType = SourceStatsType.NONE;
        public long totalReadBytes = -1L;
        public long totalReadRecords = -1L;
        public List<SourcePartitionStats> partitions = new ArrayList<SourcePartitionStats>();
    }

    public static class SourcePartitionStats {
        public String id;
        public long totalSize = -1L;
        public int totalFiles = -1;
        public long totalRecords = -1L;
        public long readBytes = -1L;
        public long readRecords = -1L;
    }

    public static enum SourceStatsType {
        FILES_WITH_PROGRESS,
        FILES_WITHOUT_PROGRESS,
        FILES_WITH_GLOBAL_PROGRESS,
        NONE;

    }
}

