/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class JobTaskQueue<T> {
    private final Deque<FutureTask<T>> taskQueue = new ArrayDeque<FutureTask<T>>();
    private final List<FutureTask<T>> runningTasks = new ArrayList<FutureTask<T>>();
    private int maxThreads;
    private boolean shuttingDown;
    private final int maxCapacity;
    public String threadPrefix;
    private long threadCount;
    private static final Logger logger = Logger.getLogger((String)"dku.jobs.taskqueue");

    public JobTaskQueue(String threadPrefix, int maxThreads, int capacity) {
        if (maxThreads < 0) {
            throw new IllegalArgumentException("Try setting a negative maxThread value: " + maxThreads);
        }
        this.maxThreads = maxThreads;
        this.maxCapacity = capacity;
        this.threadPrefix = threadPrefix;
    }

    private synchronized void tryStartJobs() {
        while (!this.taskQueue.isEmpty()) {
            if (this.shuttingDown) {
                logger.info((Object)"Shutting down, skip running new tasks");
                break;
            }
            if (this.runningTasks.size() >= this.maxThreads && this.maxThreads > 0) {
                logger.info((Object)("Maximum allowed running tasks reached: " + this.runningTasks.size()));
                break;
            }
            FutureTask<T> task = this.taskQueue.pop();
            if (task.isCancelled()) {
                logger.info((Object)String.format("FutureTask '%s' has been cancelled, skipping. Currently running: %d/%d", task, this.runningTasks.size(), this.maxThreads));
                continue;
            }
            Thread thread = new Thread(task);
            thread.setDaemon(true);
            if (StringUtils.isNotBlank((CharSequence)this.threadPrefix)) {
                thread.setName(this.threadPrefix + this.threadCount);
                ++this.threadCount;
            }
            logger.info((Object)("Will start FutureTask: " + task.toString()));
            this.runningTasks.add(task);
            thread.start();
        }
    }

    public FutureTask<T> submit(Callable<T> task) {
        return this.submit(task, null);
    }

    public synchronized FutureTask<T> submit(Callable<T> task, final @Nullable String taskName) {
        if (this.shuttingDown) {
            throw new RuntimeException("Cannot submit a task while shutting down");
        }
        if (this.taskQueue.size() >= this.maxCapacity) {
            throw new RuntimeException("Queue has reached max capacity");
        }
        FutureTask f = new FutureTask<T>(task){

            @Override
            public String toString() {
                if (taskName != null) {
                    return taskName;
                }
                return super.toString();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done() {
                JobTaskQueue jobTaskQueue = JobTaskQueue.this;
                synchronized (jobTaskQueue) {
                    JobTaskQueue.this.runningTasks.remove(this);
                    JobTaskQueue.this.taskQueue.remove(this);
                    String status = this.isCancelled() ? "cancelled" : "done";
                    logger.info((Object)String.format("FutureTask '%s' %s, removed from running tasks. Currently running: %d/%d", this.toString(), status, JobTaskQueue.this.runningTasks.size(), JobTaskQueue.this.maxThreads));
                    JobTaskQueue.this.tryStartJobs();
                }
            }
        };
        logger.info((Object)("Queuing new FutureTask: " + f.toString()));
        this.taskQueue.add(f);
        this.tryStartJobs();
        return f;
    }

    public synchronized void shutdown() {
        this.shuttingDown = true;
        for (FutureTask<T> task : new ArrayList<FutureTask<T>>(this.runningTasks)) {
            task.cancel(true);
        }
        for (FutureTask<T> task : this.taskQueue) {
            task.cancel(true);
        }
        this.runningTasks.clear();
        this.taskQueue.clear();
    }

    public synchronized int getRunningTasksCount() {
        return this.runningTasks.size();
    }

    public synchronized int getQueuedTasksCount() {
        return this.taskQueue.size();
    }

    public synchronized void setMaxThreads(int newMaxThreads) {
        if (newMaxThreads < 0) {
            throw new IllegalArgumentException("Try setting a negative maxThread value: " + newMaxThreads);
        }
        logger.info((Object)("Setting new max pool size for job queue: " + newMaxThreads + " (was " + this.maxThreads + ")"));
        this.maxThreads = newMaxThreads;
        this.tryStartJobs();
    }

    public synchronized boolean canHaveMoreTasks() {
        return this.runningTasks.size() < this.maxThreads;
    }
}

