/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.SparkPipelineDef;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeJobDefBuilder;
import com.dataiku.dip.recipes.code.scala.SparkScalaRecipeMeta;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.resources.ResourcesGatherer;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.SparkSQLDialect;

public class SparkScalaRecipePipelineHelper
extends RecipePipelineHelper {
    SparkScalaRecipeMeta.SparkScalaRecipeParams params;
    private boolean isValidConfiguration;

    public SparkScalaRecipePipelineHelper(AuthCtx authCtx, SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, JobActivity jobActivity) {
        super(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    protected void initializeForSpark() {
        this.isValidConfiguration = false;
        this.params = this.recipe.getParamsAs(SparkScalaRecipeMeta.SparkScalaRecipeParams.class);
        if (this.params != null) {
            this.isValidConfiguration = this.params.codeMode == CodeMode.FUNCTION;
            this.allowPipelineStart = this.params.pipelineAllowStart;
            this.allowPipelineMerge = this.params.pipelineAllowMerge;
        }
    }

    @Override
    protected void initializeForSql() {
        this.isValidConfiguration = false;
    }

    @Override
    boolean canSetSqlPipelineability() {
        return false;
    }

    @Override
    String setSparkPipelineability(boolean allowStart, boolean allowMerge) {
        throw new IllegalStateException("Should not come here");
    }

    @Override
    String setSqlPipelineability(boolean allowStart, boolean allowMerge) {
        throw new IllegalStateException("Should not come here");
    }

    @Override
    public String setPipelineability(boolean allowStart, boolean allowMerge) {
        this.params.pipelineAllowStart = allowStart;
        this.params.pipelineAllowMerge = allowMerge;
        return this.payload;
    }

    @Override
    protected String getEngineType() {
        return "SPARK";
    }

    @Override
    protected boolean isValidConfiguration() {
        return this.isValidConfiguration;
    }

    @Override
    protected boolean useGlobalMetastore() {
        return this.params.useGlobalMetastore;
    }

    @Override
    protected void finalizeElt(SparkPipelineDef.SparkPipelineElt elt, JobActivity activity, SparkSQLDialect dialect, ResourcesGatherer gatherer) throws Exception {
        elt.scala = new SparkScalaRecipeJobDefBuilder(activity).build();
    }

    @Override
    protected SparkOverrideConfig sparkConfig() {
        return this.params.sparkConfig;
    }

    @Override
    protected AbstractSparkRecipeParams.SparkExecutionEngine sparkExecutionEngine() {
        return this.params.executionEngine;
    }
}

