/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.streaming.DataframePreparationRequest;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.input.utils.ExternalInputStreamInput;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DataframePreparationExecutor {
    @Autowired
    private ShakerStreamService shakerStreamService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.data.prepare_dataframe");

    public DataframePreparationExecutor() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public LinkInfo initSession(AuthCtx authCtx, DataframePreparationRequest streamingRequest) throws Exception {
        String secret = SecretKeyGenerator.generate((int)16);
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        SingleCommandKernelLink link = new SingleCommandKernelLink(secret, dssPortRange, EncryptedRPC.getSSLContext());
        logger.info((Object)("Init write session: " + link.getSecret()));
        DataframePreparationThread preparationThread = new DataframePreparationThread(link, streamingRequest, authCtx);
        preparationThread.start();
        return new LinkInfo(link);
    }

    public void doPrepareData(AuthCtx authCtx, DataframePreparationRequest preparationRequest, InputStream is, OutputStream os) throws Exception {
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        StreamsInputSplit splitStream = new ExternalInputStreamInput(new BufferedInputStream(is)).getSingleSplit();
        OutputStreamOutputWriter outputWriter = this.getCSVOutputWriter(preparationRequest.requestedOutputSchema, os);
        outputWriter.init((ColumnFactory)scf);
        if (StringUtils.isNotBlank((String)preparationRequest.contextProjectKey)) {
            preparationRequest.script.contextProjectKey = preparationRequest.contextProjectKey;
        }
        ProcessorOutputToSIP shakerOutput = this.shakerStreamService.getProcessorOutput(authCtx, preparationRequest.contextProjectKey, preparationRequest.script, (ProcessorOutput)outputWriter, (ColumnFactory)scf, (RowFactory)srf);
        CSVFormatConfig csvConfig = CSVFormatConfig.getStandardTabExcelFormat();
        csvConfig.setSeparatorStr(",");
        CSVFormatExtractor csvFormatExtractor = new CSVFormatExtractor(csvConfig);
        csvFormatExtractor.setSchema(preparationRequest.requestedInputSchema, false);
        csvFormatExtractor.run(splitStream, (ProcessorOutput)shakerOutput, (ColumnFactory)scf, (RowFactory)srf);
        outputWriter.lastRowEmitted();
    }

    private OutputStreamOutputWriter getCSVOutputWriter(Schema requestedOutputSchema, OutputStream os) {
        CSVFormatConfig oFP = CSVFormatConfig.getStandardTabExcelFormat();
        CSVOutputFormatter of = new CSVOutputFormatter(oFP);
        of.setOutputSchema(requestedOutputSchema);
        return new OutputStreamOutputWriter(os, (OutputFormatter)of);
    }

    class DataframePreparationThread
    extends Thread {
        private final SingleCommandKernelLink link;
        private final DataframePreparationRequest preparationRequest;
        private final AuthCtx authCtx;

        DataframePreparationThread(SingleCommandKernelLink link, DataframePreparationRequest preparationRequest, AuthCtx authCtx) {
            this.link = link;
            this.preparationRequest = preparationRequest;
            this.authCtx = authCtx;
            this.setName("df-preparation-thread-" + link.getSecret());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info((Object)"Starting preparation thread");
            try {
                this.link.waitForProcess();
                MaybeFailRequest preparationResult = MaybeFailRequest.success();
                try (PipedOutputStream posReceivedFromLink = new PipedOutputStream();
                     PipedInputStream pisToSendToLink = new PipedInputStream();){
                    SingleCommandKernelLink.IOCallable commandResult = null;
                    try (PipedInputStream pisReceivedFromLink = new PipedInputStream(posReceivedFromLink);
                         PipedOutputStream posToSendToLink = new PipedOutputStream(pisToSendToLink);){
                        commandResult = this.link.executeStreamAsync(null, (InputStream)new BufferedInputStream(pisToSendToLink, 0x100000), (OutputStream)posReceivedFromLink);
                        DataframePreparationExecutor.this.doPrepareData(this.authCtx, this.preparationRequest, pisReceivedFromLink, posToSendToLink);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to properly handle preparation of dataframe", (Throwable)e);
                        preparationResult = MaybeFailRequest.failed(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
                    }
                    finally {
                        if (commandResult != null) {
                            commandResult.call();
                        }
                    }
                }
                finally {
                    this.link.executeAsync((Object)preparationResult, null, String.class, "Failed to send result").call();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to properly finish preparation of dataframe", (Throwable)e);
            }
            finally {
                try {
                    this.link.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Failed to properly close preparation link", (Throwable)e);
                }
            }
            logger.info((Object)"Done preparation thread");
        }
    }

    public static class LinkInfo {
        final String secret;
        final int port;
        final String serverCert;

        LinkInfo(SingleCommandKernelLink link) {
            this.secret = link.getSecret();
            this.port = link.getPort();
            this.serverCert = EncryptedRPC.getPEMCertificateTextB64orNA();
        }
    }

    static class MaybeFailRequest {
        final String error;
        final String stackTrace;

        MaybeFailRequest(String error, String stackTrace) {
            this.error = error;
            this.stackTrace = stackTrace;
        }

        static MaybeFailRequest failed(String error, String stackTrace) {
            return new MaybeFailRequest(error, stackTrace);
        }

        static MaybeFailRequest success() {
            return new MaybeFailRequest(null, null);
        }
    }
}

