/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.sort;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.datalayer.sort.BufferFiller;
import com.dataiku.dip.datalayer.sort.Sorter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class SimpleRowsFileReader
implements AutoCloseable,
RowInputStream {
    private final List<Column> columns;
    private final ByteBuffer lenghtBuffer;
    private final ByteBuffer readBuffer;
    private final BufferFiller bufferFiller;
    private final RowFactory rf;
    private long position;
    protected long positionCount = 0L;
    protected long repositionCount = 0L;
    protected long fillCount = 0L;
    private boolean closed = false;

    public SimpleRowsFileReader(BufferFiller bufferFiller, List<Column> spilledColumns, ColumnFactory cf, RowFactory rf, Sorter.MergeSortParams mergeSortParams) {
        this.bufferFiller = bufferFiller;
        this.rf = rf;
        this.columns = Lists.newArrayList();
        for (Column spilledColumn : spilledColumns) {
            this.columns.add(cf.column(spilledColumn.getName()));
        }
        this.lenghtBuffer = ByteBuffer.allocate(4 * (this.columns.size() + 1));
        this.readBuffer = ByteBuffer.allocateDirect(mergeSortParams.chunkReadBufferSize);
        this.readBuffer.position(this.readBuffer.limit());
        this.position = 0L;
    }

    public long position() throws IOException {
        return this.position;
    }

    public void position(long at) throws IOException {
        ++this.positionCount;
        if (this.position - (long)this.readBuffer.position() <= at && this.position + (long)this.readBuffer.remaining() > at) {
            this.readBuffer.position(this.readBuffer.position() + (int)(at - this.position));
            ++this.repositionCount;
        } else {
            this.readBuffer.position(this.readBuffer.limit());
        }
        this.position = at;
    }

    private void readToBuffer(ByteBuffer buffer) throws IOException {
        buffer.clear();
        while (buffer.hasRemaining()) {
            if (!this.readBuffer.hasRemaining()) {
                this.readBuffer.flip();
                this.bufferFiller.fill(this.readBuffer, this.position);
                ++this.fillCount;
                this.readBuffer.flip();
                if (!this.readBuffer.hasRemaining()) break;
            }
            int toRead = Math.min(this.readBuffer.remaining(), buffer.remaining());
            this.readBuffer.get(buffer.array(), buffer.position(), toRead);
            buffer.position(buffer.position() + toRead);
            this.position += (long)toRead;
        }
    }

    public Row next() throws IOException {
        this.readToBuffer(this.lenghtBuffer);
        this.lenghtBuffer.flip();
        if (!this.lenghtBuffer.hasRemaining()) {
            return null;
        }
        this.lenghtBuffer.getInt();
        ArrayList values = Lists.newArrayList();
        for (int i = 0; i < this.columns.size(); ++i) {
            values.add(ByteBuffer.allocate(this.lenghtBuffer.getInt()));
        }
        this.lenghtBuffer.flip();
        for (ByteBuffer value : values) {
            this.readToBuffer(value);
        }
        Row row = this.rf.row();
        for (int i = 0; i < this.columns.size(); ++i) {
            ByteBuffer value = (ByteBuffer)values.get(i);
            if (value.capacity() == 0) {
                row.put(this.columns.get(i), null);
                continue;
            }
            row.put(this.columns.get(i), new String(value.array(), StandardCharsets.UTF_8));
        }
        return row;
    }

    @Override
    public void close() throws Exception {
        if (!this.closed) {
            this.closed = true;
        }
    }
}

