/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.window.WindowAggregation;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.shaker.types.DateOnly;
import com.dataiku.dip.shaker.types.DatetimeNoTz;

public class StddevAggregation
extends WindowAggregation {
    private static final Date dateMeaning = new Date();
    private static final DateOnly dateOnlyMeaning = new DateOnly();
    private static final DatetimeNoTz datetimeNoTzMeaning = new DatetimeNoTz();
    private double meanHatD;
    private double varianceHatD;
    private long cnt;
    private final Type type;

    public static SchemaColumn buildOutputSchemaColumn(String name, SchemaColumn schemaColumn) {
        return new SchemaColumn(name, Type.DOUBLE);
    }

    public StddevAggregation(Column column, Column result, SchemaColumn schemaColumn) {
        super(column, result, schemaColumn, StddevAggregation.buildOutputSchemaColumn(result.getName(), schemaColumn));
        if (schemaColumn.getType().isNumeric()) {
            this.type = schemaColumn.getType().isFloatingPoint() ? Type.DOUBLE : Type.BIGINT;
        } else if (schemaColumn.getType() == Type.BOOLEAN) {
            this.type = Type.BOOLEAN;
        } else if (schemaColumn.getType() == Type.DATE || schemaColumn.getType() == Type.DATEONLY || schemaColumn.getType() == Type.DATETIMENOTZ) {
            this.type = schemaColumn.getType();
        } else {
            throw new RuntimeException("Cannot avg non-numeric column " + column.getName() + " of type " + String.valueOf(schemaColumn.getType()));
        }
    }

    @Override
    public boolean needsReset() {
        return false;
    }

    @Override
    public void reset() {
        this.meanHatD = 0.0;
        this.varianceHatD = 0.0;
        this.cnt = 0L;
    }

    @Override
    public void expandInternal(Object value) {
        if (value != null) {
            double x = this.type == Type.DOUBLE ? (Double)value : (this.type == Type.BIGINT ? (double)((Long)value).longValue() : (this.type == Type.BOOLEAN ? ((Boolean)value != false ? 1.0 : 0.0) : (this.type == Type.DATE ? (double)dateMeaning.msSinceEpoch((String)value) : (this.type == Type.DATEONLY ? (double)dateOnlyMeaning.msSinceEpoch((String)value) : (this.type == Type.DATETIMENOTZ ? (double)datetimeNoTzMeaning.msSinceEpoch((String)value) : 0.0)))));
            ++this.cnt;
            double oldMeanHat = this.meanHatD;
            this.meanHatD += (x - this.meanHatD) / (double)this.cnt;
            this.varianceHatD += (x - this.meanHatD) * (x - oldMeanHat);
        }
    }

    @Override
    public void shrinkInternal(Object value) {
        if (value != null) {
            double x = this.type == Type.DOUBLE ? (Double)value : (this.type == Type.BIGINT ? (double)((Long)value).longValue() : (this.type == Type.BOOLEAN ? ((Boolean)value != false ? 1.0 : 0.0) : (this.type == Type.DATE ? (double)dateMeaning.msSinceEpoch((String)value) : (this.type == Type.DATEONLY ? (double)dateOnlyMeaning.msSinceEpoch((String)value) : (this.type == Type.DATETIMENOTZ ? (double)datetimeNoTzMeaning.msSinceEpoch((String)value) : 0.0)))));
            if (this.cnt > 1L) {
                double oldMeanHat = this.meanHatD;
                this.meanHatD = ((double)this.cnt * this.meanHatD - x) / (double)(this.cnt - 1L);
                --this.cnt;
                this.varianceHatD -= (x - this.meanHatD) * (x - oldMeanHat);
            } else {
                this.meanHatD = 0.0;
                this.cnt = 0L;
                this.varianceHatD = 0.0;
            }
        }
    }

    @Override
    public Object produceValueInternal() {
        if (this.cnt <= 1L) {
            return null;
        }
        if (this.type == Type.DOUBLE) {
            return Math.sqrt(Math.max(0.0, this.varianceHatD) / (double)(this.cnt - 1L));
        }
        if (this.type == Type.BIGINT) {
            return Math.sqrt(Math.max(0.0, this.varianceHatD) / (double)(this.cnt - 1L));
        }
        if (this.type == Type.BOOLEAN) {
            return Math.sqrt(Math.max(0.0, this.varianceHatD) / (double)(this.cnt - 1L));
        }
        if (this.type == Type.DATE) {
            return Math.sqrt(Math.max(0.0, this.varianceHatD) / (double)(this.cnt - 1L));
        }
        if (this.type == Type.DATEONLY) {
            return Math.sqrt(Math.max(0.0, this.varianceHatD) / (double)(this.cnt - 1L));
        }
        if (this.type == Type.DATETIMENOTZ) {
            return Math.sqrt(Math.max(0.0, this.varianceHatD) / (double)(this.cnt - 1L));
        }
        throw new RuntimeException("unreachable");
    }
}

