/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.rules;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dataquality.RuleValidationError;
import com.dataiku.dip.dataquality.rules.AbstractNewDataQualityRule;
import com.dataiku.dip.dataquality.rules.MetricsBasedDataQualityRule;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.metrics.checks.Check;
import com.dataiku.dip.metrics.checks.MetricInNumericRangeCheck;
import com.dataiku.dip.security.AuthCtx;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractInRangeRule
extends AbstractNewDataQualityRule
implements MetricsBasedDataQualityRule {
    public double minimum;
    public boolean minimumEnabled;
    public double maximum;
    public boolean maximumEnabled;
    public double softMinimum;
    public boolean softMinimumEnabled;
    public double softMaximum;
    public boolean softMaximumEnabled;

    public abstract String getMetricId();

    @Override
    public List<Metric> getMetrics() {
        return Collections.singletonList(Metric.deserializeMetric(this.getMetricId()));
    }

    @Override
    public AbstractCheckContext.CheckResult run(AuthCtx authCtx, AbstractCheckContext context, MetricsComputationService.MetricsCheckRunReport runReport) throws Exception {
        return this.getCheck().run(authCtx, context, runReport);
    }

    private Check getCheck() {
        MetricInNumericRangeCheck check = new MetricInNumericRangeCheck();
        this.addCheckConstraints(check);
        check.displayName = this.displayName;
        check.metricId = this.getMetricId();
        check.computeOnBuildMode = this.computeOnBuildMode;
        check.autoRun = this.autoRun;
        check.enabled = this.enabled;
        return check;
    }

    private void addCheckConstraints(MetricInNumericRangeCheck check) {
        check.minimum = this.minimum;
        check.maximum = this.maximum;
        check.softMinimum = this.softMinimum;
        check.softMaximum = this.softMaximum;
        check.minimumEnabled = this.minimumEnabled;
        check.maximumEnabled = this.maximumEnabled;
        check.softMinimumEnabled = this.softMinimumEnabled;
        check.softMaximumEnabled = this.softMaximumEnabled;
    }

    @Override
    @Nullable
    public RuleValidationError verifyConfig(Dataset dataset) {
        return null;
    }

    @Override
    @Nullable
    public RuleValidationError verifyPreConditions(Dataset dataset, List<MetricsComputationService.ValuedMetric> computedMetrics) {
        return this.checkComputedMetricsPresent(computedMetrics);
    }
}

