/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.custompython;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.custompython.AbstractCustomDatasetHandler;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetDesc;
import com.dataiku.dip.datasets.custompython.CustomJavaDatasetMeta;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.plugin.CustomDataset;
import com.dataiku.dip.plugin.tools.PluginClazzLoader;
import com.dataiku.dip.plugins.CustomJavaDatasetsService;
import com.dataiku.dip.plugins.LoadedJavaDataset;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomJavaDatasetHandler
extends AbstractCustomDatasetHandler<CustomJavaDatasetDesc> {
    @Autowired
    private CustomJavaDatasetsService service;
    private CustomDataset remoteDataset;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.customjava");

    public CustomJavaDatasetHandler(AuthCtx authCtx, LoadedJavaDataset desc, Dataset dataset) {
        super(authCtx, desc, dataset);
    }

    private CustomDataset getRemoteDataset() throws IOException {
        if (this.remoteDataset == null) {
            try {
                SpringUtils.getInstance().autowire((Object)this);
                logger.info((Object)("Instantiate plugin dataset of type " + this.desc.getType()));
                ClassLoader classLoader = this.service.getClassloader(this.desc.getType());
                this.remoteDataset = (CustomDataset)new PluginClazzLoader(classLoader).loadClazz(((CustomJavaDatasetDesc)this.desc.getDesc()).datasetClass);
                PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.service.getExpandedPluginSettings(this.desc.getType(), this.authCtx, this.dataset.getProjectKey(), this.params.customConfig);
                JsonObject pluginConfig = expandedPluginSettings.pluginConfig;
                JsonObject config = expandedPluginSettings.config;
                this.remoteDataset.init(this.dataset.getProjectKey(), config, pluginConfig);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IOException("Failed to instantiate custom dataset", e);
            }
            catch (Exception e) {
                throw new IOException("Failed to init custom dataset", e);
            }
        }
        return this.remoteDataset;
    }

    @Override
    public void close() throws IOException {
        if (this.remoteDataset != null) {
            this.remoteDataset.close();
        }
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return new CustomJavaDatasetMeta((LoadedJavaDataset)this.desc);
    }

    @Override
    public boolean isParallelWritable() throws Exception {
        return ((CustomJavaDatasetDesc)this.desc.desc).isParallelWritable;
    }

    @Override
    public Output buildOutput(Partition targetPartition, int targetSplit, int resplitFactor, WarningsContext warningsContext) throws Exception {
        return new CustomJavaOutput(targetPartition, targetSplit);
    }

    @Override
    protected PartitioningScheme getRemotePartitioningScheme() throws Exception {
        return this.getRemoteDataset().getPartitioningScheme();
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.getRemoteDataset().getReadSchema();
    }

    @Override
    protected List<String> getRemoteListPartitions(PartitioningScheme scheme) throws Exception {
        return this.getRemoteDataset().listPartitions(scheme);
    }

    @Override
    protected long getRemoteCountRecords() throws Exception {
        return this.getRemoteDataset().getRecordsCount();
    }

    @Override
    protected long getRemotePartitionCountRecords(Partition p) throws Exception {
        return this.getRemoteDataset().getPartitionRecordsCount(this.dataset.getPartitioningSchema(), p);
    }

    @Override
    protected boolean getRemotePartitionExists(PartitioningScheme scheme, Partition p) throws Exception {
        return this.getRemoteDataset().getPartitionExists(this.dataset.getPartitioningSchema(), p);
    }

    @Override
    protected long remotePush(ProcessorOutput output, ColumnFactory cf, RowFactory rf, long maxRecords, Partition partition) throws Exception {
        return this.getRemoteDataset().generateRows(output, cf, rf, maxRecords, this.dataset.getPartitioningSchema(), partition);
    }

    class CustomJavaOutput
    implements Output {
        private Partition targetPartition;
        private int targetSplit;

        CustomJavaOutput(Partition targetPartition, int targetSplit) {
            this.targetPartition = targetPartition;
            this.targetSplit = targetSplit;
        }

        public OutputWriter getWriter(Output.WriteMode mode) throws IOException {
            if (mode == Output.WriteMode.APPEND) {
                throw new IllegalArgumentException("Unsupported APPEND mode for Custom java datasets");
            }
            return this.getWriter(this.targetPartition, this.targetSplit);
        }

        private OutputWriter getWriter(Partition targetPartition, int targetSplit) throws IOException {
            return CustomJavaDatasetHandler.this.getRemoteDataset().getWriter(CustomJavaDatasetHandler.this.dataset.getSchema(), CustomJavaDatasetHandler.this.dataset.getPartitioningSchema(), targetPartition, targetSplit);
        }
    }
}

