/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class FSProviderConnectionFactory {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    private static final Logger logger = Logger.getLogger((String)"dip.provider.connection.prepare");

    public FSProviderConnectionFactory() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public DSSConnection getConnectionForProvider(String providerType, AuthCtx authCtx, AbstractFSDatasetHandler.AbstractFSConfig params, String description) throws IOException, DKUSecurityException {
        return this.getConnectionForProvider(providerType, authCtx, params.connection, description);
    }

    public DSSConnection getConnectionForProvider(String providerType, AuthCtx authCtx, String connectionName, String description) throws IOException, DKUSecurityException {
        DSSConnection connection;
        if (providerType.startsWith("fsprovider_")) {
            connection = null;
        } else {
            if (StringUtils.isBlank((String)connectionName)) {
                throw new IllegalArgumentException("No connection set for " + description);
            }
            connection = this.connectionsDAO.getMandatoryConnection(authCtx, connectionName);
            this.prepareConnectionForProvider(providerType, authCtx, connection);
        }
        return connection;
    }

    public void prepareConnectionForProvider(String providerType, AuthCtx authCtx, DSSConnection connection) throws IOException {
        connection.prepareConnectionForProvider();
    }
}

