/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.GCSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.sync.FastpathUtils;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.MetastoreAwareDatasetHandler;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSProviderFactory;
import com.dataiku.dip.datasets.fs.GCSDatasetTestHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.DatasetTestHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.FSDatasetBrowseService;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.VariablesUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class GCSDatasetHandler
extends BlobLikeDatasetHandler<BuiltinFSDatasets.GCSDatasetConfig>
implements FSDatasetBrowseService.BrowsableHandler,
MetastoreAwareDatasetHandler {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.gcs");

    public GCSDatasetHandler(AuthCtx authCtx, Dataset dataset) {
        super(authCtx, dataset);
        ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).bucket = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).bucket);
        ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreDatabaseName = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreDatabaseName);
        ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreTableName = VariablesUtils.expand(dataset.getProjectKey(), ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreTableName);
        logger.info((Object)("Building GCS handler config: " + JSON.json((Object)this.resolvedConfig)));
    }

    @Override
    public String getDSSConnectionForHive() {
        throw new IllegalArgumentException("unreachable");
    }

    @Override
    public SQLUtils.SQLTable getResolvedHiveTableRef(boolean databaseIsMandatory) {
        String database = null;
        database = !StringUtils.isBlank((String)((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreDatabaseName) ? ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreDatabaseName : ((GCSConnection)this.getConnection()).params.defaultMetastoreDatabase;
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine metastore database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        String table = null;
        table = !StringUtils.isBlank((String)((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreTableName) ? ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).metastoreTableName : this.dataset.getName();
        String schema = database == null ? null : database.toLowerCase(Locale.ENGLISH);
        String table1 = table == null ? null : table.toLowerCase(Locale.ENGLISH);
        return new SQLUtils.SQLTable(null, schema, table1, true);
    }

    @Override
    public SQLUtils.SQLTable getUnresolvedHiveTableRef() {
        String database = null;
        BuiltinFSDatasets.GCSDatasetConfig rawConfig = (BuiltinFSDatasets.GCSDatasetConfig)this.config;
        database = !StringUtils.isBlank((String)rawConfig.metastoreDatabaseName) ? rawConfig.metastoreDatabaseName : ((GCSConnection)this.getConnection()).params.defaultMetastoreDatabase;
        String table = null;
        table = !StringUtils.isBlank((String)rawConfig.metastoreTableName) ? rawConfig.metastoreTableName : this.dataset.getName();
        return new SQLUtils.SQLTable(null, database, table, true);
    }

    @Override
    public AbstractFSDatasetHandler.FSProviderAndPath getProviderInternal(String path) throws IOException, DKUSecurityException, CodedException {
        String providerPath = path == null ? ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).path : path;
        FSProvider provider = FSProviderFactory.getProvider("GCS", this.authCtx, this.dataset.getProjectKey(), this.resolvedConfig, providerPath, this.getConnection());
        return new AbstractFSDatasetHandler.FSProviderAndPath(provider, providerPath);
    }

    @Override
    public DSSConnection getConnection() {
        try {
            return ConnectionsDAO.get().getMandatoryConnectionAs(this.authCtx, ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).connection, GCSConnection.class);
        }
        catch (DKUSecurityException | IOException e) {
            throw new RuntimeException("Failed to get connection", e);
        }
    }

    @Override
    public DSSConnection getHDFSAbleConnection() {
        return (GCSConnection)this.getConnection();
    }

    @Override
    public DatasetHandler.DatasetMeta<?, ?> getMeta() {
        return BuiltinFSDatasets.GCS_META;
    }

    @Override
    public void checkConfiguration() throws IOException, DKUSecurityException, CodedException {
        if (StringUtils.isBlank((String)this.getBucket())) {
            throw new CodedException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_CONFIG, "Invalid GCS dataset configuration: no bucket specified");
        }
        super.checkConfiguration();
    }

    @Override
    public DatasetTestHandler buildTestHandler() throws IOException {
        return new GCSDatasetTestHandler(this.authCtx, this, this, this.dataset);
    }

    @Override
    public String getInformationalRootPath() throws IOException, DKUSecurityException, CodedException {
        String providerRoot = this.getProviderRootPath();
        if (this.isSingleFile()) {
            if (providerRoot.endsWith("/")) {
                providerRoot = providerRoot.substring(0, providerRoot.length() - 1);
            }
            return providerRoot + PathUtils.makeLeadingNoTrailing((String)this.getSingleFile());
        }
        return providerRoot;
    }

    public String getProviderRootPath() throws IOException, DKUSecurityException, CodedException {
        return "gs://" + this.getBucket() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
    }

    public String getRootPathForSnowflakeFastPath() throws CodedException, IOException, DKUSecurityException {
        String rootPath = this.getInformationalRootPath().replaceFirst("gs://", "gcs://");
        GCSConnection connection = (GCSConnection)this.getConnection();
        GCSConnection.Params params = connection.params;
        if (StringUtils.isNotBlank((String)params.snowflakeExternalStageName) && StringUtils.isNotBlank((String)params.snowflakeExternalStagePath)) {
            String pathToReplace = PathUtils.makeNotLeadingNoTrailing((String)params.snowflakeExternalStagePath);
            if (!pathToReplace.startsWith("gcs://")) {
                pathToReplace = String.format("gcs://%s", pathToReplace);
            }
            rootPath = FastpathUtils.placeSnowflakeStageInRootPath(rootPath, pathToReplace, params.snowflakeExternalStageName, connection.name);
        }
        return rootPath;
    }

    private String getBucket() throws IOException, DKUSecurityException {
        if (StringUtils.isNotBlank((String)((GCSConnection)this.getConnection()).params.chbucket)) {
            return ((GCSConnection)this.getConnection()).params.chbucket;
        }
        return ((BuiltinFSDatasets.GCSDatasetConfig)this.resolvedConfig).bucket;
    }

    @Override
    public String getFullyQualifiedRootPath() throws IOException, DKUSecurityException, CodedException {
        GCSConnection conn = (GCSConnection)this.getConnection();
        if (conn.params.hdfsInterface == GCSConnection.HDFSInterface.NONE) {
            return null;
        }
        String providerRoot = "gs://" + this.getBucket() + PathUtils.makeLeadingNoTrailing((String)this.getTypedProvider().getRootWithinBucket());
        if (this.isSingleFile()) {
            return providerRoot + "/" + this.getSingleFile();
        }
        return providerRoot;
    }

    @Override
    protected List<AbstractSQLConnection.CustomDatabaseProperty> getHDFSExtraConf() throws IOException, DKUSecurityException {
        ProxySettings proxySettings;
        ArrayList ret = Lists.newArrayList();
        GCSConnection conn = (GCSConnection)this.getConnection();
        ret.addAll(conn.getHadoopConfigForGCSAccess(this.authCtx));
        if (!ApplicationConfigurator.isInSparkDriver() && (proxySettings = conn.getProxySettings()).hasProxy()) {
            ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.proxy.address", String.format("%s:%s", proxySettings.host, proxySettings.port), false));
            if (proxySettings.hasAuthentication()) {
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.proxy.username", proxySettings.username, false));
                ret.add(new AbstractSQLConnection.CustomDatabaseProperty("fs.gs.proxy.password", proxySettings.password, true));
            }
        }
        return ret;
    }
}

