/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.custom.PluginSettingsResolver;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.fs.AbstractFSEnumerationResult;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderPythonKernel;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderReadPythonKernel;
import com.dataiku.dip.datasets.fs.plugin.CustomFSProviderWritePythonKernel;
import com.dataiku.dip.datasets.fs.plugin.CustomLoadedFSProvider;
import com.dataiku.dip.datasets.fs.plugin.CustomPythonFSProvidersService;
import com.dataiku.dip.datasets.fs.plugin.LoadedPythonFSProvider;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.input.stream.AutoEnrichedInputStream;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.PythonSecretProtectedKernel;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkEarlyStopException;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.io.SocketBlockLinkKernelException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CustomPythonFSProvider
extends CustomLoadedFSProvider<LoadedPythonFSProvider>
implements FSProvider {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final String root;
    private final JsonObject config;
    private final CustomPythonFSProvidersService customPythonFSProvidersService;
    private ResponderKernelLink controlLink;
    private AutoDelete controlWorkDir;
    private CustomFSProviderPythonKernel controlKernel;
    private static Logger logger = Logger.getLogger((String)"dip.dataset.fsprovider.custom");

    public CustomPythonFSProvider(AuthCtx authCtx, String projectKey, LoadedPythonFSProvider loaded, JsonObject config, String root, CustomPythonFSProvidersService customPythonFSProvidersService) {
        super(loaded);
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.config = config;
        this.root = root;
        this.customPythonFSProvidersService = customPythonFSProvidersService;
    }

    private void initKernelIfNeeded() throws IOException {
        if (this.controlLink == null) {
            String ticketIdentifier = SecretKeyGenerator.generateSmall();
            APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
            APITicketService.Ticket ticket = apiTicketService.createTicket(this.authCtx, "custom-provider-ctrl-" + this.projectKey + "-" + ticketIdentifier, null);
            try {
                String secret = SecretKeyGenerator.generate((int)16);
                PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                this.controlLink = new ResponderKernelLink(secret, dssPortRange);
                String envName = new CodeEnvSelector().selectForCustomPythonRecipe(((LoadedPythonFSProvider)this.loaded).ownerPluginId);
                String resourceFolder = this.customPythonFSProvidersService.getResourceFolder(((LoadedPythonFSProvider)this.loaded).getType());
                String libFolder = this.customPythonFSProvidersService.getLibFolder(((LoadedPythonFSProvider)this.loaded).getType());
                this.controlWorkDir = FlowJobUtils.getTmpFolder("custom-fs-provider", "control");
                this.controlKernel = new CustomFSProviderPythonKernel(this.controlLink, this.authCtx, (File)this.controlWorkDir, resourceFolder, libFolder, this.projectKey, envName, ticket);
                this.controlKernel.start();
                PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customPythonFSProvidersService.getExpandedPluginSettings(((LoadedPythonFSProvider)this.loaded).getType(), this.authCtx, this.projectKey, this.config);
                String code = this.customPythonFSProvidersService.getCode(((LoadedPythonFSProvider)this.loaded).getType());
                CustomFSProviderPythonKernel.StartServerRequest command = new CustomFSProviderPythonKernel.StartServerRequest(code, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, this.root);
                CustomFSProviderPythonKernel.StartServerResponse commandResult = (CustomFSProviderPythonKernel.StartServerResponse)this.controlLink.execute((Object)command, CustomFSProviderPythonKernel.StartServerResponse.class, "Failed to init FS provider");
                if (!commandResult.ok) {
                    throw new IOException("Failed to start kernel : " + commandResult.reason);
                }
            }
            catch (SocketBlockLinkException e) {
                apiTicketService.expireTicket(ticket);
                e.withLogTail((IDSSKernelBase)this.controlKernel);
                throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
            catch (Exception e) {
                apiTicketService.expireTicket(ticket);
                throw new IOException("Failed to start kernel", e);
            }
        }
    }

    public void close() throws IOException {
        if (this.controlLink != null) {
            logger.info((Object)"Closing control connection");
            try {
                CustomFSProviderPythonKernel.CloseResponse commandResult = (CustomFSProviderPythonKernel.CloseResponse)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.CloseRequest(), CustomFSProviderPythonKernel.CloseResponse.class);
                logger.info((Object)("Provider closed with result " + JSON.pretty((Object)commandResult)));
            }
            catch (Exception e) {
                logger.warn((Object)"Failure during remote provider shutdown", (Throwable)e);
            }
            try {
                this.controlLink.sendNullCommand();
                this.controlLink.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure during link shutdown", (Throwable)e);
            }
            try {
                this.controlKernel.killWithoutMercy();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure during kernel shutdown", (Throwable)e);
            }
            if (this.controlWorkDir != null) {
                this.controlWorkDir.close();
            }
            this.controlKernel = null;
            this.controlLink = null;
            this.controlWorkDir = null;
        }
    }

    private FSBrowsePath prepare(FSBrowsePath rawPath) {
        if (rawPath.fullPath != null) {
            String[] elts = rawPath.fullPath.split("/+");
            rawPath.pathElts = Lists.newArrayList();
            for (String elt : elts) {
                if (!StringUtils.isNotBlank((String)elt)) continue;
                rawPath.pathElts.add(elt);
            }
            if (rawPath.fullPath.startsWith("/")) {
                rawPath.pathElts.add(0, "");
            }
            String string = rawPath.name = rawPath.pathElts.size() > 0 ? (String)rawPath.pathElts.get(rawPath.pathElts.size() - 1) : null;
            if (StringUtils.isEmpty((String)rawPath.name)) {
                rawPath.name = null;
            }
        }
        if (rawPath.children != null) {
            for (FSBrowsePath child : rawPath.children) {
                this.prepare(child);
            }
        }
        return rawPath;
    }

    public FSBrowsePath browse(String path, FSProvider.FSBrowseStrategy strategy) throws IOException {
        this.initKernelIfNeeded();
        try {
            FSBrowsePath rawPath = (FSBrowsePath)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.BrowseRequest(path), FSBrowsePath.class, "Failed to stat path '" + path + "'");
            FSBrowsePath ret = this.prepare(rawPath);
            if (ret.directory && strategy == FSProvider.FSBrowseStrategy.FILE || !ret.directory && strategy == FSProvider.FSBrowseStrategy.DIRECTORY) {
                return new FSBrowsePath();
            }
            return ret;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (Exception e) {
            throw new IOException("Failed to stat path '" + path + "'", e);
        }
    }

    public FSEnumerationResult enumerateRecursive(String prefix, FSEnumerationSettings enumerationSettings) {
        try {
            this.initKernelIfNeeded();
            CustomFSProviderPythonKernel.EnumerateResponse resp = (CustomFSProviderPythonKernel.EnumerateResponse)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.EnumerateRequest(prefix, enumerationSettings), CustomFSProviderPythonKernel.EnumerateResponse.class, "Failed to enumerate path '" + prefix + "'");
            if (StringUtils.isNotBlank((String)resp.errorMessage)) {
                return CustomPythonFSEnumerationResult.fromError(new Exception(resp.errorMessage));
            }
            if (!resp.enumerationPrefixExists) {
                return CustomPythonFSEnumerationResult.fromNonExistingPrefix();
            }
            if (resp.paths == null) {
                return CustomPythonFSEnumerationResult.fromPaths(new ArrayList<FSPath>());
            }
            return CustomPythonFSEnumerationResult.fromPaths(enumerationSettings.filter(resp.paths));
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            return CustomPythonFSEnumerationResult.fromError(new IOException("Failed to enumerate path '" + prefix + "'", e));
        }
        catch (Exception e) {
            return CustomPythonFSEnumerationResult.fromError(new IOException("Failed to enumerate path '" + prefix + "'", e));
        }
    }

    public FSPathOrDirectory stat(String path) throws IOException {
        this.initKernelIfNeeded();
        try {
            return ((CustomFSProviderPythonKernel.StatResponse)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.StatRequest((String)path), CustomFSProviderPythonKernel.StatResponse.class, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Failed to stat path '\u0001'"}, (String)path)))).fspath;
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (Exception e) {
            throw new IOException("Failed to stat path '" + path + "'", e);
        }
    }

    public void setLastModified(String path, long lastModified) throws IOException {
        this.initKernelIfNeeded();
        try {
            CustomFSProviderPythonKernel.SetLastModifiedResponse modified = (CustomFSProviderPythonKernel.SetLastModifiedResponse)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.SetLastModifiedRequest(path, lastModified), CustomFSProviderPythonKernel.SetLastModifiedResponse.class, "Failed to set modification time of path '" + path + "'");
            logger.info((Object)("Change of modification time : " + (modified.done ? "success" : "failed")));
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (Exception e) {
            throw new IOException("Failed to set modification time of path '" + path + "'", e);
        }
    }

    public void deleteRecursive(String path) throws IOException {
        this.initKernelIfNeeded();
        try {
            CustomFSProviderPythonKernel.DeleteResponse deleted = (CustomFSProviderPythonKernel.DeleteResponse)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.DeleteRequest(path), CustomFSProviderPythonKernel.DeleteResponse.class, "Failed to delete recursively from path '" + path + "'");
            logger.info((Object)("Deleted " + deleted.count + " files"));
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (Exception e) {
            throw new IOException("Failed to delete recursively from path '" + path + "'", e);
        }
    }

    public boolean deleteFile(String path) throws IOException {
        this.deleteRecursive(path);
        return true;
    }

    public boolean deleteDirectory(String path) throws IOException {
        this.deleteRecursive(path);
        return true;
    }

    private void move(String from, String to) throws IOException {
        this.initKernelIfNeeded();
        try {
            CustomFSProviderPythonKernel.MoveResponse moved = (CustomFSProviderPythonKernel.MoveResponse)this.controlLink.execute((Object)new CustomFSProviderPythonKernel.MoveRequest(from, to), CustomFSProviderPythonKernel.MoveResponse.class, "Failed to move from path '" + from + "' to '" + to + "'");
            if (!moved.done) {
                throw new Exception("Failed to move from path '" + from + " : no such file");
            }
        }
        catch (SocketBlockLinkException e) {
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (Exception e) {
            throw new IOException("Failed to move from path '" + from + "' to '" + to + "'", e);
        }
    }

    public void moveDirectory(String from, String to) throws IOException {
        this.move(from, to);
    }

    public void moveFile(String from, String to) throws IOException {
        this.move(from, to);
    }

    public Map<String, String> getAccessInfo(boolean withSensitiveInfo) throws IOException, DKUSecurityException {
        return Maps.newHashMap();
    }

    public EnrichedInputStream read(String pathWithinProvider) throws IOException {
        String filename = (String)PathUtils.splitBasename((String)pathWithinProvider).second;
        return new CustomProviderEnrichedInputStream(this.authCtx, this.projectKey, pathWithinProvider, filename, pathWithinProvider, (LoadedPythonFSProvider)this.loaded, this.config, this.root, this.customPythonFSProvidersService);
    }

    public OutputStream write(String path) throws IOException {
        String ticketIdentifier = SecretKeyGenerator.generateSmall();
        APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
        APITicketService.Ticket ticket = apiTicketService.createTicket(this.authCtx, "custom-provider-write-" + this.projectKey + "-" + ticketIdentifier, null);
        SingleCommandKernelLink link = null;
        CustomFSProviderWritePythonKernel kernel = null;
        try {
            String secret = SecretKeyGenerator.generate((int)16);
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            link = new SingleCommandKernelLink(secret, dssPortRange);
            String envName = new CodeEnvSelector().selectForCustomPythonRecipe(((LoadedPythonFSProvider)this.loaded).ownerPluginId);
            String resourceFolder = this.customPythonFSProvidersService.getResourceFolder(((LoadedPythonFSProvider)this.loaded).getType());
            String libFolder = this.customPythonFSProvidersService.getLibFolder(((LoadedPythonFSProvider)this.loaded).getType());
            AutoDelete workDir = FlowJobUtils.getTmpFolder("custom-fs-provider", "write");
            kernel = new CustomFSProviderWritePythonKernel(link, this.authCtx, (File)workDir, resourceFolder, libFolder, this.projectKey, envName, ticket);
            kernel.start();
            PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customPythonFSProvidersService.getExpandedPluginSettings(((LoadedPythonFSProvider)this.loaded).getType(), this.authCtx, this.projectKey, this.config);
            String code = this.customPythonFSProvidersService.getCode(((LoadedPythonFSProvider)this.loaded).getType());
            CustomFSProviderWritePythonKernel.StartServerRequest command = new CustomFSProviderWritePythonKernel.StartServerRequest(code, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, this.root, path);
            SingleCommandKernelLink.IOCallable commandResult = link.executeWithAsyncStreamAsync((Object)command, OutputStream.class);
            return new PipedStreamToKernel((OutputStream)commandResult.call(), link, kernel, workDir);
        }
        catch (SocketBlockLinkException e) {
            this.cleanupWriteResources(link, kernel, apiTicketService, ticket);
            e.withLogTail((IDSSKernelBase)this.controlKernel);
            throw this.controlKernel.maybeRethrowAsProcessDied((IOException)((Object)e));
        }
        catch (Exception e) {
            this.cleanupWriteResources(link, kernel, apiTicketService, ticket);
            throw new IOException("Failed to start kernel", e);
        }
    }

    private void cleanupWriteResources(SingleCommandKernelLink link, CustomFSProviderWritePythonKernel kernel, APITicketService apiTicketService, APITicketService.Ticket ticket) {
        if (link != null) {
            try {
                link.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Unable to close link to python kernel", (Throwable)e);
            }
        }
        if (kernel != null) {
            try {
                kernel.killWithoutMercy();
            }
            catch (IOException | InterruptedException e) {
                logger.warn((Object)"Unable to clean python kernel", (Throwable)e);
            }
        }
        apiTicketService.expireTicket(ticket);
    }

    static class CustomPythonFSEnumerationResult
    extends AbstractFSEnumerationResult {
        public CustomPythonFSEnumerationResult() {
        }

        public CustomPythonFSEnumerationResult(List<FSPath> paths) {
            super(paths);
        }

        public CustomPythonFSEnumerationResult(Throwable error) {
            super(error);
        }

        private static CustomPythonFSEnumerationResult fromError(Throwable error) {
            return new CustomPythonFSEnumerationResult(error);
        }

        private static CustomPythonFSEnumerationResult fromPaths(List<FSPath> paths) {
            return new CustomPythonFSEnumerationResult(paths);
        }

        private static CustomPythonFSEnumerationResult fromNonExistingPrefix() {
            return new CustomPythonFSEnumerationResult();
        }
    }

    public static class CustomProviderEnrichedInputStream
    extends AutoEnrichedInputStream {
        private final AuthCtx authCtx;
        private final String projectKey;
        public final String file;
        public final LoadedPythonFSProvider loaded;
        public final JsonObject config;
        public final CustomPythonFSProvidersService customPythonFSProvidersService;
        public final String root;

        public CustomProviderEnrichedInputStream(AuthCtx authCtx, String projectKey, String file, String filename, String desc, LoadedPythonFSProvider loaded, JsonObject config, String root, CustomPythonFSProvidersService customPythonFSProvidersService) {
            super(-1L, file, filename, desc, () -> CustomProviderEnrichedInputStream.getLastModifiedTime(authCtx, projectKey, file, loaded, config, root, customPythonFSProvidersService));
            this.authCtx = authCtx;
            this.projectKey = projectKey;
            this.file = file;
            this.loaded = loaded;
            this.config = config;
            this.root = root;
            this.customPythonFSProvidersService = customPythonFSProvidersService;
        }

        private InputStream openStream(long limit) throws IOException {
            SingleCommandKernelLink link = null;
            CustomFSProviderReadPythonKernel kernel = null;
            String ticketIdentifier = SecretKeyGenerator.generateSmall();
            APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
            APITicketService.Ticket ticket = apiTicketService.createTicket(this.authCtx, "custom-provider-read-" + this.projectKey + "-" + ticketIdentifier, null);
            try {
                String secret = SecretKeyGenerator.generate((int)16);
                PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
                link = new SingleCommandKernelLink(secret, dssPortRange);
                String resourceFolder = this.customPythonFSProvidersService.getResourceFolder(this.loaded.getType());
                String libFolder = this.customPythonFSProvidersService.getLibFolder(this.loaded.getType());
                String envName = new CodeEnvSelector().selectForCustomPythonRecipe(this.loaded.ownerPluginId);
                AutoDelete workDir = FlowJobUtils.getTmpFolder("custom-fs-provider", "read");
                kernel = new CustomFSProviderReadPythonKernel(link, this.authCtx, (File)workDir, resourceFolder, libFolder, this.projectKey, envName, ticket);
                kernel.start();
                PluginSettingsResolver.ResolvedSettings expandedPluginSettings = this.customPythonFSProvidersService.getExpandedPluginSettings(this.loaded.getType(), this.authCtx, this.projectKey, this.config);
                String code = this.customPythonFSProvidersService.getCode(this.loaded.getType());
                CustomFSProviderReadPythonKernel.StartServerRequest command = new CustomFSProviderReadPythonKernel.StartServerRequest(code, expandedPluginSettings.config, expandedPluginSettings.pluginConfig, this.root, this.file, limit);
                PipedInputStream pis = new PipedInputStream(0x100000);
                PipedOutputStream pos = new PipedOutputStream(pis);
                SingleCommandKernelLink.IOCallable commandResult = link.executeStreamAsync((Object)command, (OutputStream)pos);
                return new PipedStreamFromKernel(pis, (SingleCommandKernelLink.IOCallable<Void>)commandResult, kernel, link, workDir);
            }
            catch (SocketBlockLinkException e) {
                this.cleanupReadResources(link, kernel, apiTicketService, ticket);
                if (kernel != null) {
                    e.withLogTail(kernel);
                    throw kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
                }
                throw new IOException("Failed to start kernel", e);
            }
            catch (Exception e) {
                this.cleanupReadResources(link, kernel, apiTicketService, ticket);
                throw new IOException("Failed to start kernel", e);
            }
        }

        private void cleanupReadResources(SingleCommandKernelLink link, CustomFSProviderReadPythonKernel kernel, APITicketService apiTicketService, APITicketService.Ticket ticket) {
            if (link != null) {
                try {
                    link.close();
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to close link to python kernel", (Throwable)e);
                }
            }
            if (kernel != null) {
                try {
                    kernel.killWithoutMercy();
                }
                catch (IOException | InterruptedException e) {
                    logger.warn((Object)"Unable to clean python kernel", (Throwable)e);
                }
            }
            apiTicketService.expireTicket(ticket);
        }

        protected InputStream getBasicInputStream() throws IOException {
            return this.openStream(-1L);
        }

        protected InputStream getBasicHeadInputStream(long size) throws IOException {
            return this.openStream(size);
        }

        private static long getLastModifiedTime(AuthCtx authCtx, String projectKey, String file, LoadedPythonFSProvider loaded, JsonObject config, String root, CustomPythonFSProvidersService customPythonFSProvidersService) {
            long l;
            CustomPythonFSProvider provider = new CustomPythonFSProvider(authCtx, projectKey, loaded, config, root, customPythonFSProvidersService);
            try {
                FSPathOrDirectory stat = provider.stat(file);
                l = stat != null ? stat.getLastModified() : 0L;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        provider.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return 0L;
                }
            }
            provider.close();
            return l;
        }
    }

    private static class PipedStreamToKernel
    extends OutputStream {
        private SingleCommandKernelLink link;
        private PythonSecretProtectedKernel<SingleCommandKernelLink> kernel;
        private AutoDelete workDir;
        private OutputStream os;

        PipedStreamToKernel(OutputStream os, SingleCommandKernelLink link, PythonSecretProtectedKernel<SingleCommandKernelLink> kernel, AutoDelete workDir) {
            this.os = os;
            this.link = link;
            this.kernel = kernel;
            this.workDir = workDir;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)}, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.os.write(b, off, len);
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail(this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.os.flush();
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail(this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            try {
                this.os.close();
                return;
            }
            catch (SocketBlockLinkException e) {
                e.withLogTail(this.kernel);
                throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e));
            }
            finally {
                try {
                    if (this.link != null) {
                        this.link.close();
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failure during kernel shutdown", (Throwable)e);
                }
                finally {
                    this.link = null;
                }
                try {
                    if (this.kernel != null) {
                        this.kernel.killWithoutMercy();
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failure during kernel shutdown", (Throwable)e);
                }
                finally {
                    this.kernel = null;
                    if (this.workDir != null) {
                        this.workDir.close();
                        this.workDir = null;
                    }
                }
            }
        }
    }

    private static class PipedStreamFromKernel
    extends FilterInputStream {
        private PythonSecretProtectedKernel<SingleCommandKernelLink> kernel;
        private SingleCommandKernelLink link;
        private AutoDelete workDir;
        private SingleCommandKernelLink.IOCallable<Void> commandResult;

        PipedStreamFromKernel(InputStream is, SingleCommandKernelLink.IOCallable<Void> commandResult, PythonSecretProtectedKernel<SingleCommandKernelLink> kernel, SingleCommandKernelLink link, AutoDelete workDir) {
            super(is);
            this.commandResult = commandResult;
            this.kernel = kernel;
            this.link = link;
            this.workDir = workDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() throws IOException {
            super.close();
            try {
                if (this.commandResult != null) {
                    this.commandResult.call();
                }
                if (this.link == null) return;
                this.link.acknowledgeLastCall(this.kernel, null, "Failed to stream data");
                return;
            }
            catch (SocketBlockLinkEarlyStopException e) {
                return;
            }
            catch (SocketBlockLinkKernelException e) {
                throw e;
            }
            catch (IOException e) {
                logger.warn((Object)"Error while closing connection", (Throwable)e);
                return;
            }
            finally {
                if (this.link != null) {
                    try {
                        this.link.close();
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Unable to close link to kernel", (Throwable)e);
                    }
                    finally {
                        this.link = null;
                    }
                }
                this.commandResult = null;
                try {
                    if (this.kernel != null) {
                        this.kernel.killWithoutMercy();
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)"Failure during kernel shutdown", (Throwable)e);
                }
                finally {
                    this.kernel = null;
                }
                if (this.workDir != null) {
                    this.workDir.close();
                    this.workDir = null;
                }
            }
        }
    }
}

