/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.shaker.types.DatetimeNoTz;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.Decimal128;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MongoDBTypeConverter {
    AnyTemporal temporalMeaning = new AnyTemporal();
    private final StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();

    public Object toMongoValue(String v, SchemaColumn colDef, StorageTypeVerifier.DataTypeMismatchBehavior writeMismatchBehavior, WarningsContext wc) {
        Type t = colDef.getType();
        if ((v = this.storageTypeVerifier.verify(v, colDef, writeMismatchBehavior, wc, null)) == null || v.isEmpty()) {
            return null;
        }
        switch (t) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                try {
                    return Long.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return v;
                }
            }
            case BOOLEAN: {
                return Boolean.valueOf(v);
            }
            case DATE: 
            case DATEONLY: 
            case DATETIMENOTZ: {
                long timestamp = this.temporalMeaning.msSinceEpoch(v);
                return timestamp == Long.MAX_VALUE ? v : new Date(timestamp);
            }
            case FLOAT: 
            case DOUBLE: {
                try {
                    return Double.valueOf(v);
                }
                catch (NumberFormatException e) {
                    return v;
                }
            }
            case ARRAY: {
                try {
                    JSONArray array = new JSONArray(v);
                    return MongoDBTypeConverter.toMongoArrayValue(array);
                }
                catch (JSONException e) {
                    return v;
                }
            }
            case MAP: 
            case OBJECT: {
                try {
                    JSONObject obj = new JSONObject(v);
                    return MongoDBTypeConverter.toMongoObjectValue(obj);
                }
                catch (JSONException e) {
                    return v;
                }
            }
            case STRING: {
                return v;
            }
            case GEOMETRY: 
            case GEOPOINT: {
                throw new IllegalArgumentException("Geometry column are not supported for MongoDB mapping");
            }
        }
        throw new Error("unreachable");
    }

    public static Object toMongoArrayValue(JSONArray array) {
        return JSON.parse((String)array.toString(), Object.class);
    }

    public static Object toMongoObjectValue(JSONObject obj) {
        return JSON.parse((String)obj.toString(), Object.class);
    }

    public Object toMongoValue(String v) {
        try {
            return Long.valueOf(v);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(v);
            }
            catch (NumberFormatException numberFormatException2) {
                return v;
            }
        }
    }

    public String fromMongoValue(Object v, SchemaColumn schemaColumn, StorageTypeVerifier.DataTypeMismatchBehavior behav, WarningsContext wc) {
        String ret = null;
        if (v == null || v instanceof Binary || v instanceof Code || v instanceof CodeWScope) {
            ret = null;
        } else if (v instanceof Date) {
            Date d = (Date)v;
            Type readType = schemaColumn != null ? schemaColumn.getType() : Type.DATE;
            switch (readType) {
                case DATEONLY: {
                    ret = DKUtils.isoFormatReadableByDateFormat((long)d.getTime()).substring(0, 10);
                    break;
                }
                case DATETIMENOTZ: {
                    ret = DatetimeNoTz.CANONICAL_FORMATTER.print(d.getTime());
                    break;
                }
                default: {
                    ret = DKUtils.isoFormatReadableByDateFormat((long)d.getTime());
                    break;
                }
            }
        } else {
            ret = v instanceof Document ? ((Document)v).toJson() : (v instanceof Iterable ? JSON.json(this.iterableToString((Iterable)v)) : v.toString());
        }
        if (schemaColumn != null) {
            ret = this.storageTypeVerifier.verify(ret, schemaColumn, behav, wc, null);
        }
        return ret;
    }

    private Object parseItemFromIterable(Object v) {
        Decimal128 decimalValue;
        Object ret = v == null || v instanceof Binary || v instanceof Code || v instanceof CodeWScope ? null : (v instanceof Date ? DKUtils.isoFormatReadableByDateFormat((long)((Date)v).getTime()) : (v instanceof Iterable ? this.iterableToString((Iterable)v) : (v instanceof Decimal128 ? ((decimalValue = (Decimal128)v).isNaN() || decimalValue.isInfinite() ? decimalValue.toString() : decimalValue.bigDecimalValue()) : v)));
        return ret;
    }

    private Iterable<Object> iterableToString(Iterable<Object> v) {
        return StreamSupport.stream(v.spliterator(), false).map(this::parseItemFromIterable).collect(Collectors.toList());
    }
}

