/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql.treasuredata;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.TreasureDataConnection;
import com.dataiku.dip.connections.treasuredata.TreasureDataClientConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.StorageTypeVerifier;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.sql.CanShareSQLConnection;
import com.dataiku.dip.datasets.sql.treasuredata.RowData;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.base.Preconditions;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessagePack;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessagePacker;
import com.dataiku.dss.shadelibtd.org.msgpack.core.MessageUnpacker;
import com.google.common.base.Stopwatch;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.treasuredata.client.ExponentialBackOff;
import com.treasuredata.client.TDClient;
import com.treasuredata.client.TDClientException;
import com.treasuredata.client.TDClientInterruptedException;
import com.treasuredata.client.model.TDBulkImportSession;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;

class TreasureDataSQLTableOutputWriter
extends OutputWriter {
    private static final long ONE_MB = 0x100000L;
    private final int UPLOAD_FILE_CHUNK_SIZE = DKUApp.getProperty((String)"dku.treasuredata.uploadFile.sizeInMB", (int)100);
    private final int UPLOAD_FILE_ATTEMPT_COUNT = DKUApp.getProperty((String)"dku.treasuredata.uploadFile.attemptCount", (int)5);
    private final boolean DELETE_SUCCESSFUL_IMPORT_SESSIONS = DKUApp.getProperty((String)"dku.treasuredata.importSession.deleteSuccessful", (boolean)true);
    private final boolean DELETE_FAILED_IMPORT_SESSIONS = DKUApp.getProperty((String)"dku.treasuredata.importSession.deleteFailed", (boolean)true);
    private final AbstractSQLTableDatasetHandler handler;
    private final Partition targetPartition;
    private final WarningsContext warningsContext;
    private final List<RowData.Cell> dimensionValues;
    private final Output.WriteMode mode;
    private final CanShareSQLConnection.SQLConnectionShare connShare;
    private final StorageTypeVerifier storageTypeVerifier = new StorageTypeVerifier();
    private SQLConnectionProvider.SQLConnectionWrapper conn;
    private AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior writeJDBCBadDataBehavior;
    private StorageTypeVerifier.DataTypeMismatchBehavior dataTypeMismatchBehavior;
    private long numRowsEmitted;
    private long numRowsFailed;
    private long numRowsWithFailedCells;
    private List<SchemaColumn> schemaColumns;
    private List<Column> columns;
    private long writtenBytes = 0L;
    private long timestamp;
    private String sessionName;
    private TDClient tdClient;
    private ExecutorService executorService;
    private int uploadPartCount = 0;
    private UploadFile currentUploadFile;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql.treasuredata");

    public TreasureDataSQLTableOutputWriter(AbstractSQLTableDatasetHandler handler, WarningsContext warningsContext, Output.WriteMode mode, CanShareSQLConnection.SQLConnectionShare connShare, Partition targetPartition, List<RowData.Cell> dimensionValues) {
        this.handler = handler;
        this.warningsContext = warningsContext;
        this.mode = mode;
        this.connShare = connShare;
        this.targetPartition = targetPartition;
        this.dimensionValues = dimensionValues;
    }

    public void init(ColumnFactory columnFactory) throws Exception {
        AuthCtx authCtx = this.handler.getAuthCtx();
        Dataset dataset = this.handler.getDataset();
        Schema schema = dataset.getSchema();
        AbstractSQLDatasetHandler.AbstractSQLConfig config = this.handler.getResolvedAbstractConfig();
        SQLConnectionProvider.SQLConnectionData connData = this.connShare.getConnectionData();
        this.conn = this.connShare.take(authCtx, dataset.getProjectKey());
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)config.schema), (Object)"No Schema has been specified in the dataset settings. Schema is mandatory for TreasureData and corresponds to the TreasureData's database name.");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)config.table), (Object)"No table name has been specified in the dataset settings.");
        SQLDialect dialect = connData.getDialect();
        boolean dropPartitionedTableOnSchemaMismatch = false;
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        if (this.mode == Output.WriteMode.OVERWRITE) {
            dialect.dropAndRecreateTableOrPartition(authCtx, connData, this.conn, dataset, this.targetPartition, dropPartitionedTableOnSchemaMismatch, messages);
        } else {
            dialect.createTableIfNeeded(authCtx, connData, this.conn, dataset, dropPartitionedTableOnSchemaMismatch, messages);
        }
        if (!messages.isEmpty()) {
            this.warningsContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
        }
        SQLUtils.executePreWriteStatements(connData, this.conn, dataset);
        this.writeJDBCBadDataBehavior = config.writeJDBCBadDataBehavior;
        this.dataTypeMismatchBehavior = this.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.ERROR ? StorageTypeVerifier.DataTypeMismatchBehavior.ERROR : StorageTypeVerifier.DataTypeMismatchBehavior.DISCARD_WARNING;
        List dimensionNames = this.dimensionValues.stream().map(p -> p.name).collect(Collectors.toList());
        this.schemaColumns = schema.getColumns().stream().filter(sc -> !dimensionNames.contains(sc.getName())).collect(Collectors.toList());
        this.columns = this.schemaColumns.stream().map(sc -> columnFactory.column(sc.getName())).collect(Collectors.toList());
        this.timestamp = System.currentTimeMillis() / 1000L;
        this.sessionName = config.table + "_" + String.valueOf(UUID.randomUUID());
        logger.infoV("Starting bulk import, session=[%s]...", new Object[]{this.sessionName});
        TreasureDataClientConfig clientConfig = ((TreasureDataConnection)connData.getConnection()).getClientConfig(authCtx, dataset.getProjectKey());
        this.tdClient = clientConfig.buildClient();
        this.tdClient.createBulkImportSession(this.sessionName, config.schema, config.table);
        this.executorService = Executors.newCachedThreadPool();
    }

    public void emitRow(Row row) throws Exception {
        this.createUploadFileIfNeeded();
        RowData result = this.buildRowData(row);
        if (result.allTypesOk || this.writeJDBCBadDataBehavior == AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_CELL) {
            this.writeRow(this.currentUploadFile.packer, result.cells, result.timeColumnAdded);
            if (!result.allTypesOk) {
                ++this.numRowsWithFailedCells;
            }
        }
        ++this.numRowsEmitted;
        if (this.numRowsEmitted % 10000L == 0L) {
            this.logStatus();
            long totalWrittenBytes = this.currentUploadFile.getTotalWrittenBytes();
            if (totalWrittenBytes > (long)this.UPLOAD_FILE_CHUNK_SIZE * 0x100000L) {
                this.uploadCurrentFile();
            }
        }
    }

    public void lastRowEmitted() throws Exception {
        boolean failure = false;
        try {
            if (this.numRowsEmitted % 10000L != 0L) {
                this.logStatus();
            }
            logger.info((Object)"Last row emitted.");
            this.uploadCurrentFile();
            this.performImport();
            SQLUtils.executePostWriteStatements(this.connShare.getConnectionData(), this.conn, this.handler.getDataset());
            logger.info((Object)"Bulk import committed");
        }
        catch (Throwable t) {
            failure = true;
            throw t;
        }
        finally {
            this.cleanup(failure);
        }
    }

    public void cancel() throws SQLException {
        this.cleanup(true);
        logger.info((Object)"Write stream cancelled");
    }

    public long writtenBytes() {
        return this.writtenBytes;
    }

    private RowData buildRowData(Row row) {
        RowData rowData = new RowData();
        rowData.addAll(this.dimensionValues);
        for (int i = 0; i < this.schemaColumns.size(); ++i) {
            SchemaColumn schemaColumn = this.schemaColumns.get(i);
            Column column = this.columns.get(i);
            String columnName = column.getName();
            String value = row.get(column);
            if (StringUtils.isBlank((String)value)) continue;
            if ((value = this.storageTypeVerifier.verify(value, schemaColumn, this.dataTypeMismatchBehavior, this.warningsContext, null, true)) != null) {
                value = StorageTypeVerifier.normalize(value, schemaColumn);
                Type type = schemaColumn.getType();
                if (type != Type.ARRAY) {
                    rowData.add(RowData.Cell.primitive(columnName, value, type));
                    continue;
                }
                Type arrayItemType = this.getArrayItemType(schemaColumn.arrayContent);
                JsonArray array = this.parseAndVerifyArray(value, schemaColumn);
                if (array == null) {
                    rowData.allTypesOk = false;
                    if (this.writeJDBCBadDataBehavior != AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_ROW) continue;
                    ++this.numRowsFailed;
                    break;
                }
                rowData.add(RowData.Cell.array(columnName, array, arrayItemType));
                continue;
            }
            rowData.allTypesOk = false;
            if (this.writeJDBCBadDataBehavior != AbstractSQLDatasetHandler.AbstractSQLConfig.WriteJDBCBadDataBehavior.DISCARD_ROW) continue;
            ++this.numRowsFailed;
            break;
        }
        return rowData;
    }

    private JsonArray parseAndVerifyArray(String value, SchemaColumn column) {
        try {
            return JsonParser.parseString((String)value).getAsJsonArray();
        }
        catch (RuntimeException e) {
            WarningsContext.WarningType wt = WarningsContext.WarningType.OUTPUT_DATA_SQL_BAD_DATA;
            String ctx = StorageTypeVerifier.buildWarningMessage(value, column, this.warningsContext, null);
            switch (this.dataTypeMismatchBehavior) {
                case DISCARD_WARNING: 
                case IGNORE_WARNING: {
                    this.warningsContext.addWarning(wt, ctx, logger);
                    break;
                }
                case ERROR: {
                    throw ErrorContext.iae((String)("Data verify error: warning=" + String.valueOf(wt) + " " + ctx), (Exception)e);
                }
            }
            return null;
        }
    }

    private Type getArrayItemType(SchemaColumn column) {
        Type columnType = column.getType();
        return columnType == Type.ARRAY ? this.getArrayItemType(column.arrayContent) : columnType;
    }

    private void writeRow(MessagePacker packer, List<RowData.Cell> rowData, boolean timeColumnAdded) throws IOException {
        int rowSize = rowData.size() + (timeColumnAdded ? 0 : 1);
        packer.packMapHeader(rowSize);
        if (!timeColumnAdded) {
            packer.packString("time");
            packer.packLong(this.timestamp);
        }
        block6: for (RowData.Cell rowCell : rowData) {
            packer.packString(rowCell.name);
            switch (rowCell.type) {
                case TINYINT: 
                case SMALLINT: 
                case INT: 
                case BIGINT: {
                    packer.packLong(Long.parseLong(rowCell.value));
                    continue block6;
                }
                case BOOLEAN: {
                    packer.packBoolean(Boolean.parseBoolean(rowCell.value));
                    continue block6;
                }
                case FLOAT: 
                case DOUBLE: {
                    packer.packDouble(Double.parseDouble(rowCell.value));
                    continue block6;
                }
                case ARRAY: {
                    this.writeArray(packer, rowCell.array, rowCell.arrayItemType);
                    continue block6;
                }
            }
            packer.packString(rowCell.value);
        }
    }

    private void writeArray(MessagePacker packer, JsonArray array, Type itemType) throws IOException {
        packer.packArrayHeader(array.size());
        for (int i = 0; i < array.size(); ++i) {
            JsonElement element = array.get(i);
            if (element.isJsonPrimitive()) {
                switch (itemType) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INT: 
                    case BIGINT: {
                        packer.packLong(element.getAsLong());
                        break;
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        packer.packDouble(element.getAsDouble());
                        break;
                    }
                    default: {
                        packer.packString(element.getAsString());
                        break;
                    }
                }
                continue;
            }
            if (!element.isJsonArray()) continue;
            this.writeArray(packer, element.getAsJsonArray(), itemType);
        }
    }

    private void cleanup(boolean failure) throws SQLException {
        if (this.conn != null) {
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                this.executorService = null;
            }
            if (this.currentUploadFile != null) {
                try {
                    this.currentUploadFile.close();
                    this.currentUploadFile.delete();
                }
                catch (Exception e) {
                    logger.debug((Object)"Error while cleaning upload file", (Throwable)e);
                }
                this.currentUploadFile = null;
            }
            if (this.tdClient != null) {
                try {
                    if (failure && this.DELETE_FAILED_IMPORT_SESSIONS || !failure && this.DELETE_SUCCESSFUL_IMPORT_SESSIONS) {
                        logger.infoV("Deleting import session %s", new Object[]{this.sessionName});
                        this.tdClient.deleteBulkImportSession(this.sessionName);
                    }
                    this.tdClient.close();
                }
                catch (Exception e) {
                    logger.debug((Object)"Error while cleaning import session", (Throwable)e);
                }
                this.tdClient = null;
            }
            this.connShare.give(failure);
            this.conn = null;
        }
    }

    private void performImport() {
        logger.info((Object)"Waiting for all files to finish uploading");
        this.executorService.shutdown();
        try {
            while (!this.executorService.awaitTermination(5L, TimeUnit.MINUTES)) {
                logger.warn((Object)"Still waiting for files to finish uploading...");
            }
        }
        catch (InterruptedException e) {
            logger.warnV("Interrupted while waiting for all files to finish uploading. Deleting session %s", new Object[]{this.sessionName});
            Thread.currentThread().interrupt();
            return;
        }
        logger.infoV("Performing import. session=%s", new Object[]{this.sessionName});
        this.tdClient.performBulkImportSession(this.sessionName);
        TDBulkImportSession bulkImportSession = this.tdClient.getBulkImportSession(this.sessionName);
        ExponentialBackOff backoff = new ExponentialBackOff(1000, 5000, 1.5);
        Stopwatch waitWatch = Stopwatch.createStarted();
        while (bulkImportSession.getStatus() != TDBulkImportSession.ImportStatus.READY) {
            if (waitWatch.elapsed(TimeUnit.SECONDS) > 60L) {
                logger.infoV("Waiting for import session to be READY (currently %s)", new Object[]{bulkImportSession.getStatus()});
                waitWatch.reset().start();
            }
            try {
                Thread.sleep(backoff.nextWaitTimeMillis());
            }
            catch (InterruptedException e) {
                logger.warnV("Interrupted while waiting for all files to finish uploading. Deleting session %s", new Object[]{this.sessionName});
                Thread.currentThread().interrupt();
                return;
            }
            bulkImportSession = this.tdClient.getBulkImportSession(this.sessionName);
        }
        if (bulkImportSession.getValidRecords() == 0L) {
            logger.warn((Object)"No valid records processed. Not committing bulk import. Dataset will be empty");
            this.tdClient.deleteBulkImportSession(this.sessionName);
            return;
        }
        if (bulkImportSession.hasErrorOnPerform()) {
            logger.warn((Object)("Errors reported during processing phase: " + bulkImportSession.getErrorMessage()));
            if (bulkImportSession.getErrorRecords() > 0L) {
                this.tdClient.getBulkImportErrorRecords(this.sessionName, inputStream -> {
                    try {
                        MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((InputStream)new GZIPInputStream((InputStream)inputStream));
                        while (unpacker.hasNext()) {
                            logger.info((Object)("Error record: " + String.valueOf(unpacker.unpackValue())));
                        }
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Unable to dump error records", (Throwable)e);
                    }
                    return null;
                });
            }
        } else {
            logger.info((Object)"Import performed. No error reported by processing phase");
        }
        logger.info((Object)"Committing import");
        this.tdClient.commitBulkImportSession(this.sessionName);
        bulkImportSession = this.tdClient.getBulkImportSession(this.sessionName);
        backoff = new ExponentialBackOff(1000, 5000, 1.5);
        waitWatch = Stopwatch.createStarted();
        while (bulkImportSession.getStatus() != TDBulkImportSession.ImportStatus.COMMITTED) {
            if (waitWatch.elapsed(TimeUnit.SECONDS) > 60L) {
                logger.infoV("Waiting for import session to be committed (Currently %s)", new Object[]{bulkImportSession.getStatus()});
                waitWatch.reset().start();
            }
            try {
                Thread.sleep(backoff.nextWaitTimeMillis());
            }
            catch (InterruptedException e) {
                logger.warnV("Interrupted while waiting for all files to finish uploading. Deleting session %s", new Object[]{this.sessionName});
                Thread.currentThread().interrupt();
                return;
            }
            bulkImportSession = this.tdClient.getBulkImportSession(this.sessionName);
        }
        logger.info((Object)"Import committed");
    }

    private void uploadCurrentFile() throws IOException {
        this.writtenBytes += this.currentUploadFile.close();
        logger.infoV("Part ready to be uploaded: session=%s, part=%d, file=%s, size=%d", new Object[]{this.sessionName, this.currentUploadFile.partId, this.currentUploadFile.currentPackerFile, this.currentUploadFile.currentPackerFile == null ? 0L : this.currentUploadFile.currentPackerFile.length()});
        this.executorService.submit(new UploadFileTask(this.currentUploadFile));
        this.currentUploadFile = null;
    }

    private void logStatus() {
        String message = "Written rows=%d failedRows=%d rowsWithFailedCells=%d";
        logger.infoV(message, new Object[]{this.numRowsEmitted, this.numRowsFailed, this.numRowsWithFailedCells});
    }

    private void createUploadFileIfNeeded() throws IOException {
        if (this.currentUploadFile == null) {
            this.currentUploadFile = new UploadFile(this.uploadPartCount);
            ++this.uploadPartCount;
        }
    }

    private static class UploadFile {
        public int partId;
        public File currentPackerFile;
        public OutputStream currentPackerStream;
        public MessagePacker packer;

        public UploadFile(int partId) throws IOException {
            this.partId = partId;
            this.currentPackerFile = Files.createTempFile("td-writer", "msgpack.gz", new FileAttribute[0]).toFile();
            this.currentPackerStream = new GZIPOutputStream(new FileOutputStream(this.currentPackerFile));
            this.packer = MessagePack.newDefaultPacker((OutputStream)this.currentPackerStream);
        }

        public long getTotalWrittenBytes() {
            return this.packer.getTotalWrittenBytes();
        }

        public long close() throws IOException {
            this.packer.close();
            long writtenBytes = this.packer.getTotalWrittenBytes();
            logger.infoV("Written %d bytes into file %s", new Object[]{writtenBytes, this.currentPackerFile});
            return this.packer.getTotalWrittenBytes();
        }

        public void delete() {
            try {
                DKUFileUtils.forceDelete((File)this.currentPackerFile);
            }
            catch (IOException e) {
                logger.error((Object)("Unable to delete temporary file: " + this.currentPackerFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private class UploadFileTask
    implements Runnable {
        public final UploadFile uploadFile;
        private int retryCount = 0;

        private UploadFileTask(UploadFile uploadFile) {
            this.uploadFile = uploadFile;
        }

        @Override
        public void run() {
            this.tryUploadFile();
        }

        private void tryUploadFile() {
            logger.infoV("Uploading file: session=%s, part=%d", new Object[]{TreasureDataSQLTableOutputWriter.this.sessionName, this.uploadFile.partId});
            while (this.retryCount < TreasureDataSQLTableOutputWriter.this.UPLOAD_FILE_ATTEMPT_COUNT) {
                try {
                    TreasureDataSQLTableOutputWriter.this.tdClient.uploadBulkImportPart(TreasureDataSQLTableOutputWriter.this.sessionName, "data_" + this.uploadFile.partId, this.uploadFile.currentPackerFile);
                    logger.infoV("Uploaded file: session=%s, part=%s", new Object[]{TreasureDataSQLTableOutputWriter.this.sessionName, this.uploadFile.partId});
                    break;
                }
                catch (TDClientInterruptedException e) {
                    logger.infoV((Throwable)e, "Upload file interrupted: session=%s, part=%s", new Object[]{TreasureDataSQLTableOutputWriter.this.sessionName, this.uploadFile.partId});
                    break;
                }
                catch (TDClientException e) {
                    logger.infoV((Throwable)e, "Error while uploading file. Will try again (%d/%d): session=%s, part=%s", new Object[]{this.retryCount, TreasureDataSQLTableOutputWriter.this.UPLOAD_FILE_ATTEMPT_COUNT, TreasureDataSQLTableOutputWriter.this.sessionName, this.uploadFile.partId});
                    ++this.retryCount;
                }
            }
            this.uploadFile.delete();
        }
    }
}

