/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.FSBasedStreamWriter;
import com.dataiku.dip.output.CanListFilesWrittenTo;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class UnpartitionedFSBasedStreamWriter
extends FSBasedStreamWriter {
    private FSBasedStreamWriter.FSBasedOpenOutputPartition openPartition = null;
    private static Logger logger = Logger.getLogger((String)"dip.stream.unpartitioned.fs.writer");

    public UnpartitionedFSBasedStreamWriter(AuthCtx authCtx, AbstractFSDatasetHandler outputDH, String sourceId, int splitId) throws Exception {
        super(authCtx, outputDH, sourceId, splitId);
        this.detectFailureAndRecover(sourceId);
    }

    private FSBasedStreamWriter.FSBasedOpenOutputPartition getOrOpenPartition() throws Exception {
        FSBasedStreamWriter.FSBasedOpenOutputPartition oop = this.openPartition;
        if (oop != null) {
            return oop;
        }
        oop = new FSBasedStreamWriter.FSBasedOpenOutputPartition();
        oop.setupNewOpenOutputPartition("NP");
        this.openPartition = oop;
        return oop;
    }

    @Override
    public void append(Row row) throws Exception {
        FSBasedStreamWriter.FSBasedOpenOutputPartition oop = this.getOrOpenPartition();
        oop.writer.emitRow(row);
    }

    @Override
    protected void closeOpenPartitions() throws Exception {
        if (this.openPartition != null) {
            this.openPartition.lastRowEmitted();
            this.openPartition = null;
        }
    }

    @Override
    protected void cancelOpenPartitions() throws Exception {
        if (this.openPartition != null) {
            this.openPartition.cancel();
            this.openPartition = null;
        }
    }

    @Override
    protected JsonElement gatherWritesInProgress() throws IOException, InterruptedException {
        ArrayList paths = Lists.newArrayList();
        FSBasedStreamWriter.FSBasedOpenOutputPartition oop = this.openPartition;
        if (oop != null && oop.output instanceof CanListFilesWrittenTo) {
            paths.addAll(((CanListFilesWrittenTo)oop.output).list(oop.writer));
        }
        return JSON.toJsonElement((Object)paths);
    }

    @Override
    protected void clearTempWriteFiles() throws Exception {
        Output output;
        ArrayList paths = Lists.newArrayList();
        if (this.outputDH instanceof AbstractFSDatasetHandler && (output = this.outputDH.buildOutput(Partition.newNP(), this.splitId, 1, new WarningsContext())) instanceof CanListFilesWrittenTo) {
            paths.addAll(((CanListFilesWrittenTo)output).recoverList());
        }
        this.clearTempWriteFiles(paths);
    }
}

