/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.twitter;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.TwitterConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.twitter.TwitterDatasetConfig;
import com.dataiku.dip.datasets.twitter.TwitterStream;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.DSSAuthCtx;
import com.twitter.hbc.ClientBuilder;
import com.twitter.hbc.core.endpoint.StatusesFilterEndpoint;
import com.twitter.hbc.core.endpoint.StreamingEndpoint;
import com.twitter.hbc.core.processor.HosebirdMessageProcessor;
import com.twitter.hbc.core.processor.StringDelimitedProcessor;
import com.twitter.hbc.httpclient.BasicClient;
import com.twitter.hbc.httpclient.auth.Authentication;
import com.twitter.hbc.httpclient.auth.OAuth1;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TwitterStreamManager {
    private static final int MAX_QUEUE_SIZE = 10000;
    private Set<String> keywordsSet = new HashSet<String>();
    private Map<String, Pattern> keywordsPatterns = new HashMap<String, Pattern>();
    private BlockingQueue<String> globalQueue = new LinkedBlockingQueue<String>(10000);
    private AuthParameters authParameters;
    private QueueEmptier thread;
    private BasicClient client;
    private ProxySettings proxySettings;
    private Map<String, ArrayList<TwitterStream>> keywordsRouting = new HashMap<String, ArrayList<TwitterStream>>();
    private static Logger logger = Logger.getLogger((String)"dip.twitter");

    public synchronized void removeDataset(String name) {
        boolean restart = false;
        if (this.isStreaming()) {
            restart = true;
            this.stopStreaming();
        }
        HashSet<String> keywordsToRemove = new HashSet<String>();
        boolean isClosed = false;
        for (Map.Entry<String, ArrayList<TwitterStream>> entry : this.keywordsRouting.entrySet()) {
            String k = entry.getKey();
            ArrayList<TwitterStream> list = entry.getValue();
            Iterator<TwitterStream> iter = list.iterator();
            while (iter.hasNext()) {
                TwitterStream s = iter.next();
                if (!s.getName().equals(name)) continue;
                if (!isClosed) {
                    s.close();
                    isClosed = true;
                }
                iter.remove();
            }
            if (!list.isEmpty()) continue;
            keywordsToRemove.add(k);
        }
        for (String k : keywordsToRemove) {
            this.keywordsRouting.remove(k);
            this.keywordsSet.remove(k);
            this.keywordsPatterns.remove(k);
        }
        if (this.hasFilters() && restart) {
            this.startStreaming();
        }
    }

    public synchronized void registerDataset(Dataset dataset) {
        boolean restart = false;
        if (this.isStreaming()) {
            restart = true;
            this.stopStreaming();
        }
        TwitterStream ts = new TwitterStream(DSSAuthCtx.newNone(), dataset);
        for (String k : dataset.getParamsAs(TwitterDatasetConfig.class).keywords) {
            ArrayList<TwitterStream> l;
            if (!this.keywordsSet.contains(k)) {
                this.keywordsSet.add(k);
                this.keywordsPatterns.put(k, Pattern.compile(".*" + Pattern.quote(k) + ".*", 34));
            }
            if ((l = this.keywordsRouting.get(k)) == null) {
                l = new ArrayList();
                l.add(ts);
                this.keywordsRouting.put(k, l);
                continue;
            }
            l.add(ts);
        }
        if (this.hasFilters() && restart) {
            this.startStreaming();
        }
    }

    public void setConnection(String conn) throws DKUSecurityException, IOException {
        TwitterConnection tc;
        try {
            tc = ConnectionsDAO.get().getMandatoryConnectionAs(DSSAuthCtx.newNone(), conn, TwitterConnection.class);
            this.proxySettings = tc.getProxySettings();
            if (this.proxySettings.hasProxy() && this.proxySettings.hasAuthentication()) {
                throw new UnsupportedOperationException("Twitter connection doesn't support proxy authentication.");
            }
        }
        catch (DKUSecurityException | IOException e) {
            logger.error((Object)("Could not open twitter connection " + conn), e);
            return;
        }
        tc.forceLocalResolution = true;
        TwitterConnection.SerializableTwitterCredentials creds = tc.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(DSSAuthCtx.newNone(), null), TwitterConnection.SerializableTwitterCredentials.class);
        this.authParameters = new AuthParameters(creds.api_key, creds.api_secret, creds.token_key, creds.token_secret);
    }

    public synchronized void startStreaming() {
        if (!this.hasFilters()) {
            logger.error((Object)"register a dataset before streaming");
            return;
        }
        if (this.authParameters == null) {
            logger.error((Object)"set a connection before streaming");
            return;
        }
        if (this.isStreaming()) {
            logger.error((Object)"already connected");
            return;
        }
        StatusesFilterEndpoint endpoint = new StatusesFilterEndpoint();
        endpoint.stallWarnings(false);
        ArrayList<String> trackTermsList = new ArrayList<String>();
        trackTermsList.addAll(this.keywordsSet);
        endpoint.trackTerms(trackTermsList);
        this.client = new ClientBuilder(){

            public BasicClient build() {
                BasicHttpParams params = new BasicHttpParams();
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Hosebird-Client");
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.socketTimeoutMillis);
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeoutMillis);
                if (TwitterStreamManager.this.proxySettings.hasProxy()) {
                    params.setParameter("http.route.default-proxy", (Object)new HttpHost(TwitterStreamManager.this.proxySettings.host, TwitterStreamManager.this.proxySettings.port));
                }
                PoolingClientConnectionManager clientConnectionManager = new PoolingClientConnectionManager();
                return new BasicClient(this.name, this.hosts, this.endpoint, this.auth, this.enableGZip, this.processor, this.reconnectionManager, this.rateTracker, this.executorService, this.eventQueue, (HttpParams)params, (ClientConnectionManager)clientConnectionManager);
            }
        }.name("dataikuTwitterClient").hosts("https://stream.twitter.com").endpoint((StreamingEndpoint)endpoint).authentication(this.authParameters.getAuth()).processor((HosebirdMessageProcessor)new StringDelimitedProcessor(this.globalQueue)).build();
        logger.debug((Object)("twitter request sent : " + endpoint.getPostParamString()));
        this.client.connect();
        this.thread = new QueueEmptier();
        this.thread.start();
    }

    public synchronized void stopStreaming() {
        if (this.isStreaming()) {
            this.client.stop();
            this.client = null;
            this.thread.stopThread();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.thread = null;
        } else {
            logger.error((Object)"cannot stop streaming : not streaming");
        }
    }

    public synchronized boolean hasFilters() {
        return !this.keywordsSet.isEmpty() && !this.keywordsRouting.isEmpty();
    }

    public synchronized boolean isStreaming() {
        return this.client != null && !this.client.isDone();
    }

    public synchronized void printRouting() {
        for (Map.Entry<String, ArrayList<TwitterStream>> entry : this.keywordsRouting.entrySet()) {
            String keyword = entry.getKey();
            StringBuilder datasetNames = new StringBuilder();
            for (TwitterStream stream : entry.getValue()) {
                datasetNames.append(stream.getName()).append(" ");
            }
            logger.debug((Object)("filtering keyword " + keyword + " : " + datasetNames.toString()));
        }
    }

    private static String toMatch(JSONObject root) {
        StringBuilder tweet = new StringBuilder();
        try {
            tweet.append(root.getString("text"));
        }
        catch (JSONException e) {
            logger.error((Object)"Tweet has no 'text' field");
            return "";
        }
        try {
            JSONObject entities = root.getJSONObject("entities");
            if (entities.has("urls")) {
                JSONArray urls = entities.getJSONArray("urls");
                for (int i = 0; i < urls.length(); ++i) {
                    JSONObject url = urls.getJSONObject(i);
                    tweet.append(url.getString("expanded_url"));
                }
            }
            if (root.has("retweeted_status")) {
                tweet.append(TwitterStreamManager.toMatch(root.getJSONObject("retweeted_status")));
            }
        }
        catch (JSONException e) {
            logger.debug((Object)"Could not retrieve tweet field", (Throwable)e);
        }
        return tweet.toString();
    }

    private static class AuthParameters {
        private String consumerKey;
        private String consumerSecret;
        private String token;
        private String secret;

        public AuthParameters(String consumerKey, String consumerSecret, String token, String secret) {
            this.consumerKey = consumerKey;
            this.consumerSecret = consumerSecret;
            this.token = token;
            this.secret = secret;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof AuthParameters) {
                AuthParameters ap = (AuthParameters)o;
                return this.consumerKey.equals(ap.consumerKey) && this.consumerSecret.equals(ap.consumerSecret) && this.token.equals(ap.token) && this.secret.equals(ap.secret);
            }
            return false;
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.consumerKey).append((Object)this.consumerSecret).append((Object)this.token).append((Object)this.secret).toHashCode();
        }

        public Authentication getAuth() {
            return new OAuth1(this.consumerKey, this.consumerSecret, this.token, this.secret);
        }
    }

    private class QueueEmptier
    extends Thread {
        private boolean running = true;

        private QueueEmptier() {
        }

        public synchronized void stopThread() {
            this.running = false;
        }

        public synchronized boolean isRunning() {
            return this.running;
        }

        @Override
        public void run() {
            while (this.isRunning()) {
                String msg;
                try {
                    msg = TwitterStreamManager.this.globalQueue.poll(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    msg = null;
                }
                if (msg == null) continue;
                this.processTweet(msg);
            }
        }

        private void processTweet(String msg) {
            JSONObject root;
            try {
                root = new JSONObject(msg);
            }
            catch (Exception e) {
                logger.error((Object)("Unparsable tweet " + msg), (Throwable)e);
                return;
            }
            if (root.has("text")) {
                String tweet = TwitterStreamManager.toMatch(root);
                HashMap<TwitterStream, ArrayList<String>> matchingStreams = new HashMap<TwitterStream, ArrayList<String>>();
                for (String string : TwitterStreamManager.this.keywordsSet) {
                    Matcher m = TwitterStreamManager.this.keywordsPatterns.get(string).matcher(tweet);
                    if (!m.matches()) continue;
                    for (TwitterStream stream : TwitterStreamManager.this.keywordsRouting.get(string)) {
                        ArrayList<String> l = (ArrayList<String>)matchingStreams.get(stream);
                        if (l == null) {
                            l = new ArrayList<String>();
                            matchingStreams.put(stream, l);
                        }
                        l.add(string);
                    }
                }
                if (matchingStreams.size() == 0) {
                    logger.warn((Object)("No matching stream found ! : " + msg));
                }
                for (Map.Entry entry : matchingStreams.entrySet()) {
                    ((TwitterStream)entry.getKey()).process(root, (List)entry.getValue());
                }
            } else if (!root.has("limit") && !root.has("delete")) {
                logger.warn((Object)("Unrecognized message : " + msg));
            }
        }
    }
}

