/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.docextraction.DocExtractionKernelPool;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;

public class DocExtractionServer {
    private final DSSAuthCtx authCtx;
    private final String envName;
    private final String kernelId;
    private SimplePythonKernel kernel;
    private final String projectKey;
    private final String containerConfName;
    private final Settings settings;
    private static final Logger logger = Logger.getLogger((String)"dku.doc-extraction.server");

    public DocExtractionServer(AuthCtx authCtx, String envName, String projectKey, String containerConfName, Settings settings) {
        this.authCtx = (DSSAuthCtx)authCtx;
        this.envName = envName;
        this.projectKey = projectKey;
        this.settings = settings;
        this.containerConfName = containerConfName;
        this.kernelId = "doc-extraction-" + SecretKeyGenerator.generateSmall();
    }

    public void close() {
        if (this.kernel != null) {
            try {
                this.kernel.close();
            }
            catch (Throwable e) {
                logger.error((Object)"Failed to kill kernel", e);
            }
        }
    }

    public boolean isAlive() {
        return this.kernel != null && this.kernel.isAlive();
    }

    public void start() throws Exception {
        this.kernel = SimplePythonKernelFactory.prepareKernel(this.authCtx, this.projectKey, GeneralSettingsDAO.CGrouppableProcessType.ML_KERNEL, this.envName, "dataiku.llm.docextraction.docextraction_server", false, this.containerConfName, this.kernelId);
        this.kernel.start();
        this.kernel.getLink().getAsyncLink().request((Object)new StartCommand(this.settings), JsonElement.class);
    }

    public CompletableFuture<DocExtractionKernelPool.StructuredContentResponse> processAsync(DocExtractionKernelPool.StructuredExtractionCommand command) {
        return this.kernel.getLink().getAsyncLink().asyncStreamRequest((Object)command, DocExtractionKernelPool.StructuredContentResponse.class).last().doOnNext(scr -> logger.info((Object)("Got response: " + JSON.safeSampleJson((Object)scr, (int)120)))).toFuture();
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public static class Settings {
        public StructuredExtractor.ImageHandlingMode imageHandlingMode;
        public StructuredExtractor.OCRSettings ocrSettings;
        public int documentBatchSize = 4;
        public int pageBatchSize = 8;
        public ConfigOptimizationMode configOptimizationMode = ConfigOptimizationMode.AUTO;
        public String pdfBackend;
    }

    public static class StartCommand {
        public final String type = "start";
        public final Settings settings;

        public StartCommand(Settings settings) {
            this.settings = settings;
        }
    }

    public static enum ConfigOptimizationMode {
        AUTO,
        FAST,
        ACCURATE;

    }
}

