/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.grouping;

import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.filtering.IntervalFilter;
import com.dataiku.dip.eda.compute.filtering.MissingValueFilter;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.GroupingResult;
import com.dataiku.dip.eda.worksheets.models.BinningMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class BinnedGrouping
extends Grouping {
    public static final String TYPE = "binned";
    public String column;
    public BinningMode mode = BinningMode.AUTO;
    public boolean keepNA = false;
    @Nullable
    public Integer nbBins = null;
    @Nullable
    public double[] customBounds = null;

    private BinnedGrouping() {
    }

    public BinnedGrouping(String column) {
        this.column = column;
    }

    public BinnedGrouping(String column, BinningMode mode, boolean keepNA, @Nullable Integer nbBins, @Nullable double[] customBounds) {
        this.column = column;
        this.mode = mode;
        this.keepNA = keepNA;
        this.nbBins = nbBins;
        this.customBounds = customBounds;
    }

    public static class BinnedGroupingResult
    extends GroupingResult {
        public String column;
        public double[] edges;
        public boolean hasNA;

        @Override
        public List<Filter> listFilters() {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            for (int i = 1; i < this.edges.length; ++i) {
                double left = this.edges[i - 1];
                double right = this.edges[i];
                filters.add(new IntervalFilter(this.column, left, right, IntervalFilter.ClosedMode.LEFT));
            }
            if (this.hasNA) {
                filters.add(new MissingValueFilter(this.column));
            }
            return filters;
        }

        @Override
        public int size() {
            return this.edges.length - 1 + (this.hasNA ? 1 : 0);
        }
    }
}

