/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.common;

import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.Count;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.filtering.AnumFilter;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.compute.grouping.BinnedGrouping;
import com.dataiku.dip.eda.compute.grouping.CrossGrouping;
import com.dataiku.dip.eda.compute.grouping.Grouping;
import com.dataiku.dip.eda.compute.grouping.MergeGrouping;
import com.dataiku.dip.eda.compute.grouping.SubsetGrouping;
import com.dataiku.dip.eda.compute.grouping.UnionGrouping;
import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractNSampTestCard
extends BivariateCard
implements CardWithConfidenceLevel {
    @Nullable
    public List<String> yValues;
    public int maxGroups = 10;
    public double confidenceLevel;

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    protected static abstract class AbstractNSampleTestCardResult
    extends CardResult {
        public BivariateHistogramCard.BivariateHistogramData histogramData;
        public List<GroupInfo> groups;
        public GroupInfo allGroups;

        protected AbstractNSampleTestCardResult() {
        }
    }

    protected abstract class AbstractCompiledNSampTestCard
    extends AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult> {
        protected AbstractCompiledNSampTestCard() {
        }

        protected abstract Computation getTestComputation(Grouping var1);

        protected abstract AbstractNSampleTestCardResult buildTestCardResult(ComputationResult var1, List<String> var2, List<GroupInfo> var3, GroupInfo var4, BivariateHistogramCard.BivariateHistogramData var5);

        protected Grouping getGrouping() {
            if (AbstractNSampTestCard.this.yValues == null) {
                return new AnumGrouping(AbstractNSampTestCard.this.yColumn.name, AbstractNSampTestCard.this.maxGroups, false);
            }
            ArrayList<Grouping> subsets = new ArrayList<Grouping>();
            for (String yValue : AbstractNSampTestCard.this.yValues) {
                subsets.add(new SubsetGrouping(AnumFilter.single(AbstractNSampTestCard.this.yColumn.name, yValue)));
            }
            return new UnionGrouping(subsets);
        }

        @Override
        public MultiComputation getComputationPlan() {
            Grouping grouping = this.getGrouping();
            return new MultiComputation(new GroupedComputation(BoxPlotFragment.getComputationPlan(AbstractNSampTestCard.this.xColumn.name), grouping), new GroupedComputation(BoxPlotFragment.getComputationPlan(AbstractNSampTestCard.this.xColumn.name), new MergeGrouping(grouping)), new GroupedComputation(new Count(), new CrossGrouping(new BinnedGrouping(AbstractNSampTestCard.this.xColumn.name), grouping)), this.getTestComputation(grouping));
        }

        protected boolean numberOfGroupsWasCapped(GroupedComputation.GroupedComputationResult groupStats) {
            if (AbstractNSampTestCard.this.yValues == null) {
                return !groupStats.groups.asAnum().hasAllValues;
            }
            return false;
        }

        @Override
        public CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
            GroupedComputation.GroupedComputationResult groupStats = result.get(0).as(GroupedComputation.GroupedComputationResult.class);
            GroupedComputation.GroupedComputationResult mergedGroupStats = result.get(1).as(GroupedComputation.GroupedComputationResult.class);
            GroupedComputation.GroupedComputationResult histogramResults = result.get(2).as(GroupedComputation.GroupedComputationResult.class);
            ComputationResult testResult = result.get(3);
            ArrayList<String> warnings = new ArrayList<String>();
            if (this.numberOfGroupsWasCapped(groupStats)) {
                warnings.add("The number of groups has been capped to " + AbstractNSampTestCard.this.maxGroups + ": remaining data has been ignored");
            }
            ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
            for (GroupedComputation.GroupResult groupedResult : groupStats.getGroupedResults()) {
                groups.add(new GroupInfo(groupedResult.filter, BoxPlotFragment.build(groupedResult.result)));
            }
            GroupInfo allGroups = new GroupInfo(mergedGroupStats.groups.listFilters().get(0), BoxPlotFragment.build(mergedGroupStats.results.get(0)));
            List<Filter> xVals = histogramResults.groups.asCross().groups.get(0).listFilters();
            List<Filter> yVals = histogramResults.groups.asCross().groups.get(1).listFilters();
            long[] counts = new long[xVals.size() * yVals.size()];
            for (int i = 0; i < counts.length; ++i) {
                counts[i] = histogramResults.results.get((int)i).as(Count.CountResult.class).count;
            }
            BivariateHistogramCard.BivariateHistogramData histogramData = new BivariateHistogramCard.BivariateHistogramData(xVals, yVals, counts, null);
            return this.buildTestCardResult(testResult, warnings, groups, allGroups, histogramData);
        }
    }

    @UIModel
    public static class GroupInfo
    extends ImmutableValueObject {
        public Filter filter;
        public BoxPlotFragment boxPlot;

        public GroupInfo(Filter filter, BoxPlotFragment boxPlot) {
            this.filter = filter;
            this.boxPlot = boxPlot;
        }

        private GroupInfo() {
        }
    }
}

