/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.AbstractSampledExport;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.Sampler;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CachedQueryExporter
extends AbstractSampledExport {
    @Autowired
    private transient VariablesService variablesService;
    private List<String[]> rows;
    private List<String> colNames = new ArrayList<String>();
    private transient List<Column> cols;
    private Schema schema;
    private ExportInput.InputDescription description;
    private String projectKey;
    private String notebookId;
    private SQLNotebookQuery query;

    public CachedQueryExporter(SQLNotebookQuery query, QueryRunResult qrr, String projectKey, String notebookId) {
        this.query = query;
        this.projectKey = projectKey;
        this.notebookId = notebookId;
        SpringUtils.getInstance().autowire((Object)this);
        VariablesContext vc = this.variablesService.getForProject(projectKey);
        this.description = new ExportInput.InputDescription();
        this.description.projectKey = projectKey;
        this.description.name = query.mode == SQLNotebookQuery.QueryMode.HIVE ? "Hive query" : "SQL query";
        this.description.description = query.getExpandedSql(vc);
        this.rows = qrr.rows;
        this.cols = new ArrayList<Column>();
        this.schema = new Schema();
        for (QueryRunResult.ScriptRunResultColumn col : qrr.columns) {
            this.colNames.add(col.name);
            this.schema.addColumn(col.name, col.dssType == null ? Type.STRING : col.dssType);
        }
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.schema;
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.description;
    }

    @Override
    public long getInputSize() {
        return this.rows.size();
    }

    @Override
    public void close() {
    }

    @Override
    public void initializeImpl(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws Exception {
        for (String colName : this.colNames) {
            this.cols.add(cf.column(colName));
        }
    }

    @Override
    public void streamImpl(Sampler output) throws Exception {
        for (String[] rowData : this.rows) {
            StreamRow row = new StreamRow();
            for (int i = 0; i < rowData.length; ++i) {
                row.put(this.cols.get(i), rowData[i]);
            }
            output.emitRow((Row)row);
        }
        output.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return new FuturePayload.FuturePayloadTarget(this.projectKey, this.notebookId, ITaggingService.TaggableType.SQL_NOTEBOOK.name(), this.notebookId).withPart(this.query.mode == SQLNotebookQuery.QueryMode.HIVE ? this.query.hiveQueryId : this.query.id);
    }
}

