/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class ExtraLogFileAppender
extends AppenderSkeleton {
    private static InheritableThreadLocal<File> extraOutput = new InheritableThreadLocal();
    private static final ExtraLogFileAppender INSTANCE = new ExtraLogFileAppender();

    public static void setupIfNeeded() {
        DKUtils.startLogAppender((Appender)INSTANCE);
    }

    public static void startLoggingToExtraFile(File output) {
        extraOutput.set(output);
    }

    public static void stopLoggingToExtraFile() {
        extraOutput.remove();
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        File output;
        String[] s;
        String data = this.layout.format(event);
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            StringBuilder dataBuilder = new StringBuilder(data);
            for (int i = 0; i < s.length; ++i) {
                dataBuilder.append(s[i]);
                dataBuilder.append(Layout.LINE_SEP);
            }
            data = dataBuilder.toString();
        }
        if ((output = (File)extraOutput.get()) != null) {
            try {
                FileUtils.writeStringToFile((File)output, (String)data, (Charset)StandardCharsets.UTF_8, (boolean)true);
            }
            catch (IOException e) {
                System.out.println("Failed to log to extra log file: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

