/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.mistralai.api;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.marshall.FinishReasonResponseAdapter;
import com.dataiku.dip.llm.online.mistralai.api.MistralAIChatChunkResponse;
import com.dataiku.dip.llm.online.mistralai.api.MistralAIChatResponseAdapter;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class MistralAIChatChunkResponseAdapter {
    private MistralAIChatChunkResponseAdapter() {
    }

    public static LLMClient.StreamedCompletionResponseChunk adapt(MistralAIChatChunkResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            throw new IllegalArgumentException("Empty chat chunk response");
        }
        MistralAIChatChunkResponse.Choice choice = response.choices.get(0);
        LLMClient.StreamedCompletionResponseChunk resp = new LLMClient.StreamedCompletionResponseChunk();
        resp.text = choice.delta.content;
        if (choice.delta.toolCalls != null && !choice.delta.toolCalls.isEmpty()) {
            resp.toolCalls = choice.delta.toolCalls.stream().map(MistralAIChatResponseAdapter::adapt).collect(Collectors.toList());
        }
        return resp;
    }

    @Nullable
    public static LLMClient.FinishReason extractFinishReason(MistralAIChatChunkResponse response) {
        if (response.choices == null || response.choices.isEmpty()) {
            return null;
        }
        MistralAIChatChunkResponse.Choice choice = response.choices.get(0);
        if (choice.finishReason == null) {
            return null;
        }
        return FinishReasonResponseAdapter.adapt(choice.finishReason);
    }
}

