/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSBackendMain;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceInfoService {
    @Autowired
    private LicenseStatusService licenseStatusService;

    public InstanceInfo get(boolean includeAdminOnlyInfo) {
        InstanceInfo ret = new InstanceInfo();
        ret.dssStartupTimestamp = DSSBackendMain.BACKEND_STARTUP_TIME;
        ret.dataDirPath = ApplicationConfigurator.getBaseFolder();
        ret.installDirPath = ApplicationConfigurator.getInstallFolder();
        try {
            ret.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            ret.hostname = "Failed to compute: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        try {
            ret.basePort = DKUApp.getIniValue((String)"server", (String)"port");
        }
        catch (Exception e) {
            ret.basePort = "Failed to read install.ini:" + ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        ret.rawNodeType = ApplicationConfigurator.getNodeType();
        boolean projectsModuleEnabled = true;
        try {
            projectsModuleEnabled = !"false".equals(DKUApp.getIniValue((String)"modules", (String)"projects"));
        }
        catch (Exception e) {
            projectsModuleEnabled = true;
        }
        ret.nodeType = ret.rawNodeType == ApplicationConfigurator.DSSNodeType.AUTOMATION && !projectsModuleEnabled ? "DEPLOYER" : ret.rawNodeType.toString();
        ret.nodeId = DKUApp.getNodeId();
        ret.nodeName = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().nodeName;
        ret.installId = DKUApp.getInstallId();
        ret.dipInstanceId = DKUApp.dipInstanceId();
        LicenseStatusService.LicensingStatus status = this.licenseStatusService.getLicensingStatus();
        try {
            if (!status.hasLicense) {
                ret.licenseId = "NOLIC";
                ret.licenseInstanceId = "NOLIC";
            } else {
                ret.licenseId = status.licenseContent.licenseId;
                ret.licenseInstanceId = status.licenseContent.instanceId;
            }
        }
        catch (Throwable e) {
            ret.licenseId = "ERR";
            ret.licenseInstanceId = "ERR";
        }
        ret.dssVersion = DKUApp.getDSSVersion().product_version;
        if (System.getenv("DKUDISTRIB") != null) {
            String str = System.getenv("DKUDISTRIB");
            ret.os = StringUtils.split((String)str, (char)' ')[0];
            ret.osVersion = str.substring(ret.os.length() + 1);
        } else {
            ret.os = "unknown";
            ret.osVersion = "unknown";
        }
        ret.javaVendor = System.getProperty("java.vendor");
        ret.javaVersion = System.getProperty("java.version");
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(System.getenv("DKUPYTHONBIN"), "-c", "import sys;print(sys.version)");
        try {
            ret.basePythonInterpreter = new String(DKUtils.execAndGetOutput((ProcessBuilder)pb), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            ret.basePythonInterpreter = "Failed to get python interpreter: " + ExceptionUtils.getMessageWithCauses((Throwable)e);
        }
        return ret;
    }

    public static class InstanceInfo {
        public long dssStartupTimestamp;
        public String dataDirPath;
        public String installDirPath;
        public ApplicationConfigurator.DSSNodeType rawNodeType;
        public String nodeType;
        public String hostname;
        public String basePort;
        public String nodeId;
        public String nodeName;
        public String installId;
        public String dipInstanceId;
        public String licenseInstanceId;
        public String licenseId;
        public String dssVersion;
        public String os;
        public String osVersion;
        public String javaVendor;
        public String javaVersion;
        public String basePythonInterpreter;
    }
}

