/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.naming;

import com.dataiku.dip.shaker.text.StringNormalizer;
import cz.jirutka.unidecode.Unidecode;
import fr.free.nrw.jakaroma.Jakaroma;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class ASCIITransliterator {
    private static Unidecode unidecode = Unidecode.toAscii();

    public static String transliterateToASCII(String input, boolean lowercase) {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        input = ASCIITransliterator.containsKanji(input) ? new Jakaroma().convert(input, true, false) : unidecode.decode(input);
        input = StringNormalizer.normalize((String)input);
        if (lowercase) {
            input = input.toLowerCase(Locale.ENGLISH);
        }
        return input;
    }

    public static String transliterateToASCIIAlphanumAndUnderscore(String input, String defaultIfImpossible) {
        return ASCIITransliterator.transliterateToASCIIAlphanumAndUnderscore(input, false, defaultIfImpossible);
    }

    public static String transliterateToASCIIAlphanumAndUnderscore(String input, boolean lowercase, String defaultIfImpossible) {
        if (StringUtils.isBlank((String)input)) {
            return defaultIfImpossible;
        }
        input = ASCIITransliterator.transliterateToASCII(input, lowercase);
        if ((input = input.replaceAll("[^A-Za-z0-9_]", "_")).matches("^_*$")) {
            return defaultIfImpossible;
        }
        return input;
    }

    public static String transliterateToASCIIVariableName(String input, String defaultIfImpossible) {
        Object name = ASCIITransliterator.transliterateToASCIIAlphanumAndUnderscore(input, defaultIfImpossible);
        if (((String)name).length() > 0 && Character.isDigit(((String)name).charAt(0))) {
            name = "v" + (String)name;
        }
        return name;
    }

    private static boolean isKanji(char c2) {
        return Character.UnicodeBlock.of(c2) == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS;
    }

    private static boolean containsKanji(String s) {
        for (char c2 : s.toCharArray()) {
            if (!ASCIITransliterator.isKanji(c2)) continue;
            return true;
        }
        return false;
    }
}

