/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.notifications;

import com.dataiku.dip.notifications.NotificationsRouter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.AnalysesListChangedEvent;
import com.dataiku.dip.server.notifications.backend.CommitEvent;
import com.dataiku.dip.server.notifications.backend.CommitMentionEvent;
import com.dataiku.dip.server.notifications.backend.DatasetsListChangedEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionMentionEvent;
import com.dataiku.dip.server.notifications.backend.DiscussionReplyEvent;
import com.dataiku.dip.server.notifications.backend.NotebooksListChangedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectCreatedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectDeletedEvent;
import com.dataiku.dip.server.notifications.backend.ProjectRefreshedEvent;
import com.dataiku.dip.server.notifications.backend.RecipesListChangedEvent;
import com.dataiku.dip.server.notifications.backend.ScenariosListChanged;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectsListChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.timelines.EnrichmentService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import java.io.IOException;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InternalForwardNotificationsRouter
implements NotificationsRouter {
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPermissionsService permService;
    @Autowired
    private IWorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private EnrichmentService enrichmentService;
    static Logger logger = Logger.getLogger((String)"dku.notifications.forward");

    @Override
    @PostConstruct
    public void init() {
        logger.debug((Object)"Init internal forward router");
        this.pubSub.subscribe("object-change", (DSSEventListener)new DSSEventListener<TaggableObjectChangedEvent>(){

            public void on(TaggableObjectChangedEvent evt) {
                switch (evt.action) {
                    case PROJECT_CREATE: 
                    case PROJECT_DUPLICATE: {
                        InternalForwardNotificationsRouter.this.pubSub.publish(new ProjectCreatedEvent(evt.projectKey, evt.objectName));
                        break;
                    }
                    case PROJECT_GIT_CHECKOUT: 
                    case PROJECT_GIT_PULL: {
                        InternalForwardNotificationsRouter.this.pubSub.publish(new ProjectRefreshedEvent(evt.projectKey, evt.objectName));
                        break;
                    }
                    case PROJECT_DELETE: {
                        InternalForwardNotificationsRouter.this.pubSub.publish(new ProjectDeletedEvent(evt.projectKey, evt.objectName));
                        break;
                    }
                    case ANALYSIS_CREATE: 
                    case ANALYSIS_DELETE: {
                        InternalForwardNotificationsRouter.this.publishWithDebounceIfNotDeletion(evt, new AnalysesListChangedEvent(evt.getProjectKey()), "analyses-list-changed");
                        break;
                    }
                    case DATASET_CREATE: 
                    case DATASET_DELETE: 
                    case DATASET_RENAME: 
                    case MANAGED_FOLDER_CREATE: 
                    case MANAGED_FOLDER_DELETE: 
                    case STREAMING_ENDPOINT_CREATE: 
                    case STREAMING_ENDPOINT_DELETE: {
                        InternalForwardNotificationsRouter.this.publishWithDebounceIfNotDeletion(evt, new DatasetsListChangedEvent(evt.getProjectKey()), "datasets-list-changed");
                        break;
                    }
                    case RECIPE_CREATE: 
                    case RECIPE_DELETE: 
                    case RECIPE_RENAME: {
                        InternalForwardNotificationsRouter.this.publishWithDebounceIfNotDeletion(evt, new RecipesListChangedEvent(evt.getProjectKey()), "recipes-list-changed");
                        break;
                    }
                    case SCENARIO_CREATE: 
                    case SCENARIO_DELETE: {
                        InternalForwardNotificationsRouter.this.publishWithDebounceIfNotDeletion(evt, new ScenariosListChanged(evt.getProjectKey()), "scenarios-list-changed");
                        break;
                    }
                    case JUPYTER_NOTEBOOK_CREATE: 
                    case JUPYTER_NOTEBOOK_DELETE: 
                    case SQL_NOTEBOOK_CREATE: 
                    case SQL_NOTEBOOK_DELETE: {
                        InternalForwardNotificationsRouter.this.publishWithDebounceIfNotDeletion(evt, new NotebooksListChangedEvent(evt.getProjectKey()), "notebooks-list-changed");
                        break;
                    }
                }
            }
        });
        this.pubSub.subscribe("discussion-reply", (DSSEventListener)new DSSEventListener<DiscussionReplyEvent>(){

            public void on(DiscussionReplyEvent evt) throws IOException {
                HashSet<String> toBeNotified = new HashSet<String>();
                try (Transaction t = InternalForwardNotificationsRouter.this.transactionService.beginRead();){
                    InternalForwardNotificationsRouter.this.enrichmentService.enrich(evt);
                    for (String mentionedUser : InternalForwardNotificationsRouter.this.usersService.getMentions(evt.text)) {
                        if (mentionedUser.equals(evt.user) || !InternalForwardNotificationsRouter.this.isAuthorized(mentionedUser, evt.projectKey, evt.workspaceKey)) continue;
                        toBeNotified.add(mentionedUser);
                    }
                }
                for (String mentionedUser : toBeNotified) {
                    InternalForwardNotificationsRouter.this.pubSub.publish(new DiscussionMentionEvent(evt.text, evt.user, evt.objectType, evt.projectKey, evt.workspaceKey, evt.objectId, evt.discussionId, mentionedUser, evt.details.deepCopy()));
                }
            }
        });
        this.pubSub.subscribe("commit", (DSSEventListener)new DSSEventListener<CommitEvent>(){

            public void on(CommitEvent evt) throws IOException {
                HashSet<String> toBeNotified = new HashSet<String>();
                try (Transaction t = InternalForwardNotificationsRouter.this.transactionService.beginRead();){
                    for (String mentionedUser : InternalForwardNotificationsRouter.this.usersService.getMentions(evt.getMessage())) {
                        if (mentionedUser.equals(evt.getUserLogin()) || !InternalForwardNotificationsRouter.this.isAuthorized(mentionedUser, evt.getProjectKey(), null)) continue;
                        toBeNotified.add(mentionedUser);
                    }
                }
                for (String mentionedUser : toBeNotified) {
                    InternalForwardNotificationsRouter.this.pubSub.publish(new CommitMentionEvent(evt.getMessage(), evt.getUserLogin(), evt.getProjectKey(), mentionedUser));
                }
            }
        });
        logger.debug((Object)"Done init internal forward router");
    }

    private void publishWithDebounceIfNotDeletion(TaggableObjectChangedEvent origEvt, TaggableObjectsListChangedEvent listEvt, String listEvtName) {
        String key = listEvtName + "___" + origEvt.getProjectKey();
        if (!origEvt.isProjectDeletion) {
            this.pubSub.publishWithDebounce(key, listEvt, 1000);
        } else {
            logger.info((Object)"Project itself is being deleted, not sending list update notif");
        }
    }

    private boolean isAuthorized(String user, String projectKey, String workspaceKey) {
        try {
            AuthCtx authCtx = this.authCtxCreationService.create(user);
            if (!StringUtils.isBlank((String)workspaceKey)) {
                return this.workspacePermissionsService.hasWorkspacePrivileges(authCtx, workspaceKey, Privileges.WorkspaceLevelPrivilegeType.READ);
            }
            if (!StringUtils.isBlank((String)projectKey)) {
                return this.permService.hasAnyProjectAccess(authCtx, projectKey);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get user permissions", (Throwable)e);
            return false;
        }
        return true;
    }
}

