/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.partitioning;

import com.dataiku.dip.input.filter.InputFilter;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PrettyString;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PartitionFactory {
    public static InputFilter inputFilterFromPartitionSpec(PartitioningScheme scheme, String spec) {
        return new InputFilter().withSelectedPartitions(PartitionFactory.fromPartitionSpec(scheme, spec));
    }

    public static List<Partition> fromPartitionSpec(PartitioningScheme scheme, String spec) {
        if (spec == null) {
            return Lists.newArrayList((Object[])new Partition[]{new Partition(scheme)});
        }
        if (scheme == null || !scheme.isPartitioned()) {
            if (spec.equals("NP")) {
                return Lists.newArrayList((Object[])new Partition[]{new Partition(null)});
            }
            throw ErrorContext.iae((String)("Invalid partition spec: " + spec + " for a non-partitioned dataset"));
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String specElt : StringUtils.split((String)spec, (String)",")) {
            String[] dimPatterns = StringUtils.split((String)specElt, (String)"|");
            if (scheme.getDimensionNames().size() != dimPatterns.length) {
                throw ErrorContext.iae((String)PrettyString.scat((Object[])new Object[]{"For", PrettyString.pquoted((Object)spec) + ":", "Invalid partition identifier, has", dimPatterns.length, "dimensions, expected", scheme.getDimensionNames().size()}));
            }
            Partition template = new Partition(scheme);
            PartitionFactory.fillList(template, 0, dimPatterns, partitions);
        }
        return partitions;
    }

    private static void fillList(Partition template, int i, String[] dimensionValuesPatterns, List<Partition> partitions) {
        String dname = (String)template.getScheme().getDimensionNames().get(i);
        Dimension dimension = template.getScheme().getDimension(dname);
        String dimensionValuePattern = dimensionValuesPatterns[i];
        if (i == dimensionValuesPatterns.length - 1) {
            List vals = dimension.getValuesFromPattern(dimensionValuePattern);
            for (DimensionValue val : vals) {
                Partition p2 = template.copy();
                p2.setDimensionValue(dname, val);
                partitions.add(p2);
            }
        } else {
            List vals = dimension.getValuesFromPattern(dimensionValuePattern);
            for (DimensionValue val : vals) {
                template.setDimensionValue(dname, val);
                PartitionFactory.fillList(template, i + 1, dimensionValuesPatterns, partitions);
            }
        }
    }

    public static Partition fromIdentifier(PartitioningScheme scheme, String identifier) {
        if (identifier == null) {
            identifier = "";
        }
        if (scheme == null || !scheme.isPartitioned()) {
            if (identifier.equals("NP")) {
                return new Partition(null);
            }
            throw ErrorContext.iae((String)("Invalid partition identifier: " + identifier + " for a non-partitioned dataset"));
        }
        String[] dimensionValuesIds = StringUtils.split((String)identifier, (String)"|");
        if (scheme.getDimensionNames().size() != dimensionValuesIds.length) {
            throw ErrorContext.iae((String)PrettyString.scat((Object[])new Object[]{"For", PrettyString.pquoted((Object)identifier) + ":", "Invalid partition identifier, has", dimensionValuesIds.length, "dimensions, expected", scheme.getDimensionNames().size()}));
        }
        Partition p = new Partition(scheme);
        for (int i = 0; i < dimensionValuesIds.length; ++i) {
            String dname = (String)scheme.getDimensionNames().get(i);
            Dimension dimension = scheme.getDimension(dname);
            DimensionValue val = dimension.getValueFromId(dimensionValuesIds[i]);
            p.setDimensionValue(dname, val);
        }
        return p;
    }
}

