/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.utils;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.backend.sql.queries.InputTable;
import com.dataiku.dip.pivot.backend.sql.utils.QueryUtils;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;

public class PartitionUtils {
    public static void appendPartitionFilteringClause(InputTable table, com.dataiku.dip.pivot.backend.sql.queries.SelectQueryBuilder queryBuilder) {
        String partitionFilteringClause = PartitionUtils.getPartitionFilteringClause(table);
        if (partitionFilteringClause != null) {
            queryBuilder.where(partitionFilteringClause);
        }
    }

    public static void appendPartitionFilteringClause(InputTable table, SelectQueryBuilder queryBuilder) {
        String partitionFilteringClause = PartitionUtils.getPartitionFilteringClause(table);
        if (partitionFilteringClause != null) {
            queryBuilder.where(ExpressionUtils.ef.expr(partitionFilteringClause));
        }
    }

    private static String getPartitionFilteringClause(InputTable table) {
        InputTable.PartitionSelection partitionSelection = table.partitionSelection;
        if (partitionSelection == null || partitionSelection.partitioningColumn == null) {
            return null;
        }
        if (partitionSelection.partitions == null) {
            return null;
        }
        if (partitionSelection.partitions.isEmpty()) {
            throw new UnsupportedOperation("At least one partition must be selected !");
        }
        SQLDialect dialect = table.dialect;
        String colExpr = dialect.quoteIdentifier(partitionSelection.partitioningColumn);
        return QueryUtils.inValues(dialect, colExpr, partitionSelection.partitions, null, Type.STRING);
    }
}

