/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel;

import com.dataiku.dip.pivot.backend.model.PivotTableTensorResponse;
import com.dataiku.dip.pivot.frontend.excel.AreaBarLine2DExporter;
import com.dataiku.dip.pivot.frontend.excel.BarLine1DExporter;
import com.dataiku.dip.pivot.frontend.excel.BubbleChartExporter;
import com.dataiku.dip.pivot.frontend.excel.KpiExporter;
import com.dataiku.dip.pivot.frontend.excel.PivotTableChartExporter;
import com.dataiku.dip.pivot.frontend.excel.Stacked1DExporter;
import com.dataiku.dip.pivot.frontend.model.ChartDef;
import com.dataiku.dip.pivot.frontend.model.FontFormatting;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFWorkbook;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nullable;

class ExcelChartExporter {
    ExcelChartExporter() {
    }

    static XSSFWorkbook export(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx, @Nullable List<FontFormatting> colorMap) throws IOException {
        switch (chartDef.type) {
            case stacked_columns: 
            case stacked_area: {
                if (chartDef.genericDimension1.isEmpty()) {
                    return Stacked1DExporter.export(chartDef, response, animationFrameIdx);
                }
                return AreaBarLine2DExporter.export(chartDef, response, animationFrameIdx);
            }
            case grouped_columns: 
            case lines: {
                if (chartDef.genericDimension1.isEmpty()) {
                    return BarLine1DExporter.export(chartDef, response, animationFrameIdx);
                }
                return AreaBarLine2DExporter.export(chartDef, response, animationFrameIdx);
            }
            case pivot_table: {
                return PivotTableChartExporter.export(chartDef, response, animationFrameIdx, colorMap);
            }
            case grouped_xy: {
                return BubbleChartExporter.export(chartDef, response, animationFrameIdx);
            }
            case kpi: {
                return KpiExporter.export(chartDef, response, colorMap);
            }
        }
        throw ErrorContext.iae((String)("It is not possible to export this kind of chart (" + String.valueOf((Object)chartDef.type) + ")"));
    }

    static void export(ChartDef chartDef, PivotTableTensorResponse response, int animationFrameIdx, @Nullable List<FontFormatting> colorMap, OutputStream outputStream) throws IOException {
        XSSFWorkbook export = ExcelChartExporter.export(chartDef, response, animationFrameIdx, colorMap);
        export.write(outputStream);
    }
}

