/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend.excel.xssf;

import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.BorderStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Cell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.CellType;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Row;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.usermodel.Sheet;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.RegionUtil;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCell;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFCellStyle;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFRow;
import com.dataiku.dss.shadelibpoi.org.apache.poi.xssf.usermodel.XSSFSheet;

public class SheetUtils {
    public static final String CHART_SHEET_NAME = "Chart";
    public static final String DATA_SHEET_NAME = "Data";

    public static Double readNumCell(XSSFSheet sheet, int rowIdx, int cellIdx) {
        XSSFCell cell;
        XSSFRow row = sheet.getRow(rowIdx);
        if (row != null && (cell = row.getCell(cellIdx, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL)).getCellType() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        return null;
    }

    public static void autoFitColumns(XSSFSheet sheet) {
        int nbCols = 0;
        for (Row row : sheet) {
            nbCols = Math.max(row.getLastCellNum(), nbCols);
        }
        for (int i = 0; i < nbCols; ++i) {
            sheet.autoSizeColumn(i, true);
        }
    }

    public static XSSFCell writeCell(XSSFSheet sheet, int rowIdx, int cellIdx, String val) {
        XSSFCell cell = SheetUtils.getOrCreateCell(sheet, rowIdx, cellIdx);
        cell.setCellType(CellType.STRING);
        cell.setCellValue(val);
        return cell;
    }

    public static XSSFCell getOrCreateCell(XSSFSheet sheet, int rowIdx, int cellIdx) {
        XSSFRow row = sheet.getRow(rowIdx);
        if (row == null) {
            row = sheet.createRow(rowIdx);
        }
        return row.getCell(cellIdx, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    public static XSSFCell writeFormula(XSSFSheet sheet, int rowIdx, int cellIdx, String val) {
        XSSFFormulaEvaluator evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        XSSFCell cell = SheetUtils.getOrCreateCell(sheet, rowIdx, cellIdx);
        cell.setCellFormula(val);
        evaluator.evaluateFormulaCell((Cell)cell);
        return cell;
    }

    public static XSSFCell writeCell(XSSFSheet sheet, int rowIdx, int cellIdx, double val) {
        XSSFCell cell = SheetUtils.getOrCreateCell(sheet, rowIdx, cellIdx);
        cell.setCellType(CellType.NUMERIC);
        cell.setCellValue(val);
        return cell;
    }

    public static XSSFCell writeCell(XSSFSheet sheet, int rowIdx, int cellIdx, DateTime dateTime) {
        XSSFCell cell = SheetUtils.getOrCreateCell(sheet, rowIdx, cellIdx);
        if (dateTime != null) {
            cell.setCellValue(dateTime.toLocalDateTime().toDate());
        } else {
            cell.setBlank();
        }
        return cell;
    }

    public static void addMergedRegion(XSSFSheet sheet, CellRangeAddress rangeAddress) {
        XSSFCell firstCell = SheetUtils.getOrCreateCell(sheet, rangeAddress.getFirstRow(), rangeAddress.getFirstColumn());
        XSSFCellStyle style = firstCell.getCellStyle();
        sheet.addMergedRegion(rangeAddress);
        if (style != null) {
            RegionUtil.setBorderTop((BorderStyle)style.getBorderTop(), (CellRangeAddress)rangeAddress, (Sheet)sheet);
            RegionUtil.setBorderBottom((BorderStyle)style.getBorderBottom(), (CellRangeAddress)rangeAddress, (Sheet)sheet);
            RegionUtil.setBorderLeft((BorderStyle)style.getBorderLeft(), (CellRangeAddress)rangeAddress, (Sheet)sheet);
            RegionUtil.setBorderRight((BorderStyle)style.getBorderRight(), (CellRangeAddress)rangeAddress, (Sheet)sheet);
        }
    }
}

