/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.populardatasets;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.List;

public class UIPopularDataset {
    private UIPopularDataset() {
    }

    public static class DiscoverablePopularDataset
    extends AbstractPopularDataset {
        private DiscoverablePopularDataset() {
        }

        public DiscoverablePopularDataset(SerializedDataset sd, String projectName, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, boolean hasAnyProjectAccess, boolean canRequestProjectAccess, double score) {
            super(sd, projectName, objectAuthorizations, hasAnyProjectAccess, canRequestProjectAccess, score);
        }
    }

    public static class PopularDataset
    extends AbstractPopularDataset {
        public boolean isFeatureGroup;
        public int numberOfColumns;
        public int numberOfProjects;
        public int numberOfDataCollections;
        public long lastBuiltOn;

        private PopularDataset() {
        }

        public PopularDataset(SerializedDataset sd, String projectName, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, int numberOfColumns, int numberOfProjects, int numberOfDataCollections, long lastBuiltOn, boolean hasAnyProjectAccess, boolean canRequestProjectAccess, double score) {
            super(sd, projectName, objectAuthorizations, hasAnyProjectAccess, canRequestProjectAccess, score);
            this.isFeatureGroup = sd.featureGroup;
            this.numberOfColumns = numberOfColumns;
            this.numberOfProjects = numberOfProjects;
            this.numberOfDataCollections = numberOfDataCollections;
            this.lastBuiltOn = lastBuiltOn;
        }
    }

    @PolyJSON(value={@Mapping(value=PopularDataset.class, type="DATASET"), @Mapping(value=DiscoverablePopularDataset.class, type="DISCOVERABLE-DATASET")})
    @UIModel
    public static abstract class AbstractPopularDataset {
        public String name;
        public String projectKey;
        public String projectName;
        public String datasetType;
        public ExposedObjectsService.ObjectAuthorizations objectAuthorizations;
        public boolean hasAnyProjectAccess;
        public boolean canRequestProjectAccess;
        public List<String> tags;
        public String shortDesc;
        public double score;

        private AbstractPopularDataset() {
        }

        protected AbstractPopularDataset(SerializedDataset sd, String projectName, ExposedObjectsService.ObjectAuthorizations objectAuthorizations, boolean hasAnyProjectAccess, boolean canRequestProjectAccess, double score) {
            this.name = sd.name;
            this.projectKey = sd.projectKey;
            this.projectName = projectName;
            this.datasetType = sd.type;
            this.tags = sd.tags;
            this.shortDesc = sd.shortDesc;
            this.objectAuthorizations = objectAuthorizations;
            this.hasAnyProjectAccess = hasAnyProjectAccess;
            this.canRequestProjectAccess = canRequestProjectAccess;
            this.score = score;
        }
    }

    @UIModel
    public static class PopularDatasetsStatus {
        public long lastRunDuration;
        public long lastRunTimestamp;
        public long nextScheduledRun;
        public int numberOfDatasets;

        public PopularDatasetsStatus(long lastRunDuration, long lastRunTimestamp, long nextScheduledRun, int numberOfDatasets) {
            this.lastRunDuration = lastRunDuration;
            this.lastRunTimestamp = lastRunTimestamp;
            this.nextScheduledRun = nextScheduledRun;
            this.numberOfDatasets = numberOfDatasets;
        }
    }

    @UIModel
    public static class PopularDatasetList {
        public PopularDatasetsStatus status;
        public List<AbstractPopularDataset> datasets;

        public PopularDatasetList(PopularDatasetsStatus status, List<AbstractPopularDataset> datasets) {
            this.status = status;
            this.datasets = datasets;
        }
    }
}

