/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.google.gson.JsonObject;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RecipeSchemaComputer {
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected GenericRecipesValidationService recipesValidationService;
    protected final JobActivity activity;
    protected final SerializedRecipe recipe;
    protected final AuthCtx authCtx;

    public RecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        this.authCtx = authCtx;
        this.activity = activity;
        this.recipe = ((RecipeRunnableSubgraph)activity.getSubgraph()).getRecipe().getModel();
        SpringUtils.getInstance().autowire((Object)this);
    }

    public boolean computesDiffItself() {
        return false;
    }

    public boolean canUpdateRecipe() {
        return false;
    }

    public RecipeSchemaService.RecipeSchemaAutoupdateResult updateRecipe_NT(JsonObject options) throws Exception {
        throw new Error("This recipe kind does not update recipe automatically");
    }

    public RecipeSchemaService.RecipeSchemaAutoupdateResult getAutoupdateResult_NT() throws Exception {
        throw new Error("This recipe kind does not compute diff itself");
    }

    public List<Schema> getSchemasForOutputRole_NT(String role) throws Exception {
        throw new Error("This recipe kind does compute diff itself");
    }

    public SerializedRecipe getRecipe() {
        return this.recipe;
    }

    public static class DontWantToCompute
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final InfoMessage.MessageCode code;

        public DontWantToCompute(InfoMessage.MessageCode code, String message) {
            super(message);
            this.code = code;
        }

        public InfoMessage.MessageCode getCode() {
            return this.code;
        }
    }

    public static interface RecipeSchemaComputerWithPayload {
        public void setPayload(String var1);
    }
}

