/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sparksql;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLExecutor;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeJobDef;
import com.dataiku.dip.recipes.code.sparksql.SparkSQLQueryRecipeRunnerBase;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SparkSQLMultiQueryExecutor
extends SparkSQLQueryRecipeRunnerBase
implements AbortableRecipeRunner {
    private Map<String, String> originalQueries;
    private Map<String, String> finalQueries;
    private SparkSQLExecutor.SparkSQLExecutorParams params;
    static Logger logger = Logger.getLogger((String)"dku.recipes.embeddableSparkSQL");

    public SparkSQLMultiQueryExecutor(JobActivity activity, SparkSQLExecutor.SparkSQLExecutorParams params, Map<String, String> sqls) {
        super(activity);
        this.params = params;
        this.originalQueries = sqls;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
        this.finalQueries = Maps.newHashMap();
        for (Map.Entry<String, String> e : this.originalQueries.entrySet()) {
            this.finalQueries.put(e.getKey(), this.jobDefBuilder.buildFinalQuery(e.getValue()));
        }
    }

    @Override
    public void run() throws Exception {
        logger.info((Object)("SparkSQL queries:\n" + Joiner.on((String)"\n").join(this.finalQueries.values())));
        HashMap queriesWithPreQueries = Maps.newHashMap();
        for (Map.Entry<String, String> e : this.finalQueries.entrySet()) {
            Object queryWithPreQueries = e.getValue();
            if (!StringUtils.isBlank((String)this.params.preQueries)) {
                queryWithPreQueries = this.params.preQueries + "\n;\n" + (String)queryWithPreQueries;
            }
            queriesWithPreQueries.put(e.getKey(), queryWithPreQueries);
        }
        SparkSQLQueryRecipeJobDef jobDef = this.jobDefBuilder.buildJobDef(queriesWithPreQueries, this.params.overwriteOutputSchema, this.params.useGlobalMetastore, this.params.readParams);
        this.clearOutputIfNeeded();
        this.executeJobDef(jobDef, this.params.sparkConfig, this.params.executionEngine);
    }
}

