/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler;

import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.scheduler.scenarios.ScenarioRun;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;

public class PerScenarioLoggingAppender
extends AppenderSkeleton {
    private final ScenarioRunContext scenarioRunContext;
    private static final Set<String> ignoredLoggers = Sets.newHashSet((Object[])new String[]{"dku.jobs.state.dump"});

    public PerScenarioLoggingAppender(ScenarioRunContext scenarioRunContext) {
        this.scenarioRunContext = scenarioRunContext;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        String[] s;
        if (ignoredLoggers.contains(event.getLoggerName())) {
            return;
        }
        String data = this.layout.format(event);
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            StringBuilder dataBuilder = new StringBuilder(data);
            for (int i = 0; i < s.length; ++i) {
                dataBuilder.append(s[i]);
                dataBuilder.append(Layout.LINE_SEP);
            }
            data = dataBuilder.toString();
        }
        try {
            ScenarioRun scenarioRun = this.scenarioRunContext.getScenarioRun();
            if (scenarioRun != null) {
                File scenarioFile = ScenarioRunContext.getLog(scenarioRun);
                FileUtils.writeStringToFile((File)scenarioFile, (String)data, (String)"utf8", (boolean)true);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to log per-scenario run line: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            StepRun stepRun = this.scenarioRunContext.getStepRun();
            if (stepRun != null) {
                File stepFile = ScenarioRunContext.getLog(stepRun);
                FileUtils.writeStringToFile((File)stepFile, (String)data, (String)"utf8", (boolean)true);
            }
        }
        catch (IOException e) {
            System.out.println("Failed to log per-step run line: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            ScenarioRunContext.ScenarioFromJobLoc jobLoc = this.scenarioRunContext.getJob();
            if (jobLoc != null) {
                File activityFile;
                File jobFile = FlowJobUtils.jobLogFile(false, jobLoc.projectKey, jobLoc.jobId);
                if (jobFile.exists()) {
                    FileUtils.writeStringToFile((File)jobFile, (String)data, (String)"utf8", (boolean)true);
                }
                if ((activityFile = DKUFileUtils.getWithin((File)FlowJobUtils.jobFolder(false, jobLoc.projectKey, jobLoc.jobId), (String[])new String[]{jobLoc.activityId + ".log"})).exists()) {
                    FileUtils.writeStringToFile((File)activityFile, (String)data, (String)"utf8", (boolean)true);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Failed to log per-scenario run line: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

